/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTestFrameworks {
    @NotNull
    public static List<OCTestFramework> getFrameworks() {
        return OCTestFramework.EP_NAME.getExtensionList();
    }

    @Nullable
    public static OCTestFramework getFrameworkWithSuspendedTestIndex(@NotNull PsiFile file) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.hasSuspendedTestIndex(file) || !each.isAvailable(file)) continue;
            return each;
        }
        return null;
    }

    public static boolean isTestClassOrStruct(@Nullable OCSymbol clazz, @Nullable PsiElement element, @NotNull Project project) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestClassOrStruct(clazz, element, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestMethodOrFunction(@Nullable OCSymbol method, @Nullable PsiElement element, @NotNull Project project) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestMethodOrFunction(method, element, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestNamespace(@Nullable OCNamespaceSymbol namespaceSymbol, @Nullable PsiElement element, @NotNull Project project) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestNamespace(namespaceSymbol, element, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestGlobalVar(@Nullable OCDeclaratorSymbol varSymbol, @Nullable PsiElement element, @NotNull Project project) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestGlobalVar(varSymbol, element, project)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement e) {
        PsiElement idOwner = OCLineMarkerProvider.getOwnerById(e);
        if (idOwner != null) {
            for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
                OCTestLineMarkInfo info = each.getTestLineMarkInfo(idOwner);
                if (info == null) continue;
                return info;
            }
        }
        return null;
    }
}

