/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWrapperWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import icons.CidrLangIcons;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCIcons {
    private static final Map<Pair<Icon, Icon>, Icon> ourPatchedIcons = new ConcurrentHashMap<Pair<Icon, Icon>, Icon>();

    private OCIcons() {
    }

    public static Icon getMethodIcon(boolean isStatic, boolean isOptional, boolean isAbstract) {
        Icon icon = isOptional ? CidrLangIcons.CodeAssistantMemberOptional : (isAbstract ? CidrLangIcons.CodeAssistantMemberAbstract : CidrLangIcons.CodeAssistantMember);
        return isStatic ? OCIcons.getStaticIcon(icon) : icon;
    }

    public static Icon getPropertyIcon(boolean isStatic, boolean isOptional) {
        Icon icon = isOptional ? CidrLangIcons.CodeAssistantPropertyOptional : CidrLangIcons.CodeAssistantProperty;
        return isStatic ? OCIcons.getStaticIcon(icon) : icon;
    }

    public static Icon getFunctionIcon(boolean isStatic, boolean isAbstract, boolean isNonVirtual, OCVisibility visibility) {
        Icon icon = isAbstract ? CidrLangIcons.CodeAssistantFunctionAbstract : CidrLangIcons.CodeAssistantFunction;
        icon = isStatic ? OCIcons.getStaticIcon(icon) : icon;
        icon = isNonVirtual ? OCIcons.getConstIconWithTooltip(icon, OCSymbolKind.FUNCTION_DECLARATION) : icon;
        return OCIcons.getVisibilityIcon(visibility, icon);
    }

    @Nullable
    private static Icon addLayer(@Nullable Icon baseIcon, @NotNull Icon newLayer, boolean nextRow) {
        if (baseIcon == null) {
            return null;
        }
        Pair pair = Pair.create((Object)baseIcon, (Object)newLayer);
        Icon patchedIcon = ourPatchedIcons.get(pair);
        if (patchedIcon == null) {
            if (baseIcon instanceof LayeredIcon && !nextRow) {
                Icon[] layers = ((LayeredIcon)baseIcon).getAllLayers();
                LayeredIcon layeredIcon = new LayeredIcon(layers.length + 1);
                for (int i = 0; i < layers.length; ++i) {
                    layeredIcon.setIcon(layers[i], i);
                }
                layeredIcon.setIcon(newLayer, layers.length);
                patchedIcon = layeredIcon;
            } else if (nextRow) {
                RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
                rowIcon.setIcon(baseIcon, 0);
                rowIcon.setIcon(newLayer, 1);
                patchedIcon = rowIcon;
            } else {
                patchedIcon = new LayeredIcon(new Icon[]{baseIcon, newLayer});
            }
            ourPatchedIcons.put((Pair<Icon, Icon>)pair, patchedIcon);
        }
        return patchedIcon;
    }

    public static Icon getStaticIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, IconManager.getInstance().getPlatformIcon(PlatformIcons.StaticMark), false);
    }

    public static Icon getConstIconWithTooltip(@Nullable Icon icon, @NotNull OCSymbolKind symbolKind) {
        Icon constIcon = OCIcons.getConstIcon(icon);
        return new IconWrapperWithToolTip(constIcon, OCBundle.messagePointer("icon.tooltip.const.decl", symbolKind.getNameLowercase()));
    }

    public static Icon getConstIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, IconManager.getInstance().getPlatformIcon(PlatformIcons.FinalMark), false);
    }

    public static Icon getVisibilityIcon(@Nullable OCVisibility visibility, Icon baseIcon) {
        if (visibility == null) {
            return baseIcon;
        }
        IconManager iconManager = IconManager.getInstance();
        return switch (visibility) {
            case OCVisibility.PUBLIC -> OCIcons.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Public), true);
            case OCVisibility.PACKAGE -> OCIcons.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Local), true);
            case OCVisibility.PROTECTED -> OCIcons.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Protected), true);
            case OCVisibility.PRIVATE -> OCIcons.addLayer(baseIcon, iconManager.getPlatformIcon(PlatformIcons.Private), true);
            default -> baseIcon;
        };
    }

    @Nullable
    public static Icon getTestIcon(@Nullable Icon icon) {
        return OCIcons.addLayer(icon, IconManager.getInstance().getPlatformIcon(PlatformIcons.TestMark), false);
    }
}

