/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomHeaderProvider {
    public static final ExtensionPointName<CustomHeaderProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.customHeaderProvider");
    private final Map<HeaderSearchStage, StageProvider> myStageProviders = new EnumMap<HeaderSearchStage, StageProvider>(HeaderSearchStage.class);

    public abstract boolean accepts(@Nullable OCResolveRootAndConfiguration var1);

    @Nullable
    public abstract String provideSerializationPath(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getCustomSerializedHeaderFile(@NotNull String var1, @NotNull Project var2, @NotNull VirtualFile var3);

    @Nullable
    public OCCompilerSettings getCompilerSettings(@NotNull OCResolveConfiguration configuration, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        return null;
    }

    @Nullable
    public VirtualFile getCustomHeaderFile(@NotNull String headerName, @NotNull HeaderSearchStage stage, @Nullable OCResolveConfiguration configuration) {
        StageProvider provider2 = this.myStageProviders.get((Object)stage);
        if (provider2 != null) {
            return provider2.getHeader(headerName, configuration);
        }
        return null;
    }

    protected void registerProvider(@NotNull HeaderSearchStage stage, @NotNull StageProvider provider2) {
        this.myStageProviders.put(stage, provider2);
    }

    @NotNull
    public static Helper getProviders(@NotNull String headerName, @Nullable OCResolveRootAndConfiguration configuration) {
        ArrayList<CustomHeaderProvider> helpers = new ArrayList<CustomHeaderProvider>();
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            if (!provider2.accepts(configuration)) continue;
            helpers.add(provider2);
        }
        return new Helper(ContainerUtil.trimToSize(helpers), headerName, configuration != null ? configuration.getConfiguration() : null);
    }

    @Nullable
    public static String provideSerializationPathForFile(@NotNull VirtualFile file) {
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            String path = provider2.provideSerializationPath(file);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomHeaderFile(@NotNull String serializationPath, @NotNull Project project, @NotNull VirtualFile file) {
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            VirtualFile headerFile = provider2.getCustomSerializedHeaderFile(serializationPath, project, file);
            if (headerFile == null) continue;
            return headerFile;
        }
        return null;
    }

    @Nullable
    public static OCCompilerSettings getCustomCompilerSettings(@NotNull OCResolveConfiguration configuration, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            OCCompilerSettings settings = provider2.getCompilerSettings(configuration, rootAndConfiguration);
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    @Nullable
    public static String getFrameworkNameFromImport(@NotNull String importPath) {
        String headerName;
        String adjustedName = OCIncludeHelpers.adjustHeaderName(importPath);
        List parts2 = StringsKt.split((CharSequence)adjustedName, (String[])new String[]{"/"}, (boolean)false, (int)3);
        if (parts2.size() != 2) {
            return null;
        }
        String frameworkName = (String)parts2.get(0);
        if (!FileUtil.pathsEqual((String)frameworkName, (String)(headerName = StringUtil.trimEnd((String)((String)parts2.get(1)), (String)".h")))) {
            return null;
        }
        return frameworkName;
    }

    public static enum HeaderSearchStage {
        BEFORE_START,
        BEFORE_CURRENT,
        BEFORE_LIBRARIES,
        BEFORE_FRAMEWORKS,
        AFTER_END;

    }

    protected static interface StageProvider {
        @Nullable
        public VirtualFile getHeader(@NotNull String var1, @Nullable OCResolveConfiguration var2);
    }

    public static class Helper {
        @NotNull
        private final List<CustomHeaderProvider> myProviders;
        @NotNull
        private final String myHeaderName;
        @Nullable
        private final OCResolveConfiguration myConfiguration;

        public Helper(@NotNull List<CustomHeaderProvider> providers, @NotNull String headerName, @Nullable OCResolveConfiguration configuration) {
            this.myProviders = providers;
            this.myHeaderName = headerName;
            this.myConfiguration = configuration;
        }

        @Nullable
        public VirtualFile getCustomHeader(HeaderSearchStage stage) {
            for (CustomHeaderProvider provider2 : this.myProviders) {
                VirtualFile file = provider2.getCustomHeaderFile(this.myHeaderName, stage, this.myConfiguration);
                if (file == null) continue;
                return file;
            }
            return null;
        }
    }
}

