/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsRunConfigurationEditorBase;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestWithScopeElementsRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestWithScopeElementsRunConfigurationEditorBase<BC, TARGET, CONFIGURATION, BCH> {
    private final CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> myFramework;

    public CidrTestWithScopeElementsRunConfigurationEditor(@NotNull Project project, @NotNull BCH configHelper, @Nullable CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework) {
        super(project, configHelper);
        this.myFramework = framework;
    }

    protected boolean isChecking() {
        return this.myFramework.getUpdater(this.myProject).isIndexing();
    }

    @NotNull
    protected final Set<String> collectStringsFromProject(@NotNull Project project, @Nullable Consumer<Pair<CidrTestScopeElement, Set<String>>> consumer) {
        return CidrTestWithScopeElementsRunConfigurationEditor.collectStringsFromProject(processor2 -> this.consumeTestObjects(project, (Processor<CidrTestScopeElement>)processor2), project, consumer);
    }

    protected void consumeTestObjects(@NotNull Project project, Processor<? super CidrTestScopeElement> processor2) {
        this.myFramework.consumeTestObjects(project, null, processor2);
    }

    @NotNull
    public static Set<String> collectStringsFromProject(@NotNull Consumer<Processor<? super CidrTestScopeElement>> consumeTestObjects, @NotNull Project project, @Nullable Consumer<Pair<CidrTestScopeElement, Set<String>>> consumer) {
        return (Set)OCFieldAdapter.collectAllValues((Project)project, Collections.emptySet(), () -> {
            if (project.isDisposed()) {
                return Collections.emptySet();
            }
            TreeSet result = new TreeSet();
            consumeTestObjects.accept(testInfo -> {
                if (consumer != null) {
                    consumer.accept(Pair.create((Object)testInfo, (Object)result));
                }
                return true;
            });
            return result;
        });
    }
}

