/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.execution.testing.CidrTestBaseUtil;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestUtil {
    public static boolean processNamespaceRecursively(@NotNull OCSymbol symbol, @NotNull Processor<? super OCSymbol> processor2) {
        if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
            List<OCSymbol> membersList = ((OCNamespaceSymbol)symbol).getMembersList();
            if (membersList != null) {
                for (OCSymbol nsSymbol : membersList) {
                    if (processor2.process((Object)nsSymbol)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getAsPatternForCommandLine(@NotNull Project project, @NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull CidrTestScope testScope, @NotNull ProgressIndicator progress) {
        return CidrTestExecutionUtil.getAsPatternForCommandLine((Project)project, file -> framework.getTestObjects(OCLanguageUtils.tryGetOCFile(file)).values(), emptyTestScopeProducer, () -> FileSymbolTablesCache.areSymbolsLoaded(project), (CidrTestScope)testScope, (ProgressIndicator)progress);
    }

    @Nullable
    public static String getCanonicalNameFromSymbol(@NotNull OCSymbolWithQualifiedName namespaceSymbol, @NotNull OCResolveContext context) {
        OCQualifiedName namespaceQName = namespaceSymbol.getResolvedQualifiedName(context);
        return namespaceQName == null ? null : CidrTestBaseUtil.replaceTemplateParamTo((String)namespaceQName.getFullName(context), (String)"");
    }

    @NotNull
    public static String createFilePattern(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull PsiFile file, @NotNull Predicate<CidrTestScopeElement> filter) {
        return CidrTestUtil.filePatternAsRef() ? CidrTestUtil.createFilePatternAsRef(framework, file) : CidrTestExecutionUtil.createFilePatternAsTestList(framework.getTestObjects(file).values(), emptyTestScopeProducer, filter);
    }

    public static boolean filePatternAsRef() {
        return Registry.is((String)"cidr.test.framework.filePatternAsRef") && !PluginUtils.hasAppCode();
    }

    @NotNull
    public static String createFilePatternAsRef(@NotNull CidrTestWithScopeElementsFramework<? extends CidrTestScopeElement> framework, @NotNull PsiFile file) {
        framework.updateTestsListOrScheduleUpdateIfCannotWait(file);
        return "all-tests(" + file.getVirtualFile().getUrl() + ")";
    }
}

