/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementForCacheImpl;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrTestScopeSerialization {
    @NotNull
    @Contract(value="_ -> new")
    public static CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> getTestSerializer(Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        return new CidrTestWithScopeElementsSerializer(generator);
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForCaching(final @Nullable String testName, final @Nullable String suiteName, final long offsetAsNaturalOrder, final @Nullable String uniqueTestBodyElementId, @NotNull PsiFile pfile, final @Nullable OCSymbolKind kind, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        return new CidrTestScopeElementWithSerializerImpl(pfile, offsetAsNaturalOrder, suiteName, testName, generator){

            @Override
            public void write(@NotNull Output output2) {
                output2.writeString(testName);
                output2.writeString(suiteName);
                output2.writeLong(offsetAsNaturalOrder);
                output2.writeString(uniqueTestBodyElementId);
                output2.writeString(kind == null ? null : kind.toString());
            }

            protected void verify(@Nullable PsiFile psiFile, @NotNull VirtualFile vFile) {
                super.verify(psiFile, vFile);
                if (OCLanguageUtils.tryGetOCFile(psiFile) == null) {
                    CidrTestLog.LOG.error("File is not C/C++/ObjC/ObjC++", new String[]{vFile.getPath()});
                }
            }

            @Contract(pure=true)
            protected PsiElement findFromOrderInFile(@NotNull PsiFile psiFile) {
                return psiFile.findElementAt(OCSymbolOffsetUtil.getTextOffset(offsetAsNaturalOrder));
            }

            @Nullable
            protected PsiElement getElementSlow(@NotNull PsiFile psiFile) {
                OCFile realSource;
                if (!(psiFile instanceof OCFile) || uniqueTestBodyElementId == null) {
                    return null;
                }
                OCSymbolReference.GlobalReference bodyRef = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.parse(uniqueTestBodyElementId));
                OCFile source = (OCFile)psiFile;
                if (OCRootUtil.isNeedToFindRoot(psiFile) && (realSource = ((OCFile)psiFile).getAssociatedFile()) != null) {
                    source = realSource;
                }
                List<OCSymbol> symbols = bodyRef.resolveToSymbols(OCResolveContext.forPsi(source));
                OCSymbol preDeclaration = null;
                for (OCSymbol symbol : symbols) {
                    PsiElement element = this.extractElement(symbol);
                    if (element != null) {
                        return element;
                    }
                    if (preDeclaration != null || symbol.getKind() != OCSymbolKind.FUNCTION_PREDECLARATION) continue;
                    preDeclaration = symbol;
                }
                if (preDeclaration != null) {
                    return this.extractElement(preDeclaration.getDefinitionSymbol(source.getProject()));
                }
                return null;
            }

            @Nullable
            public String getId() {
                return uniqueTestBodyElementId;
            }

            @Contract(value="null -> null")
            @Nullable
            private PsiElement extractElement(@Nullable OCSymbol symbol) {
                if (symbol != null && symbol.getKind() == kind) {
                    return OCSymbolHolderVirtualPsiElement.create(symbol, this.myProject);
                }
                return null;
            }
        };
    }

    public static class CidrTestWithScopeElementsSerializer
    implements CidrTestWithScopeElementsFramework.CidrTestScopeSerializer<CidrTestScopeElement> {
        Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> myGenerator;
        private static final int SKIP_WATERMARK = -1;
        private static final int TEST_WITH_SCOPE_ELEMENTS_SERIALIZER = 0;

        public CidrTestWithScopeElementsSerializer() {
            this.myGenerator = null;
        }

        public CidrTestWithScopeElementsSerializer(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            this.myGenerator = generator;
        }

        public void setGenerator(@NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            this.myGenerator = generator;
        }

        @Override
        public void write(@NotNull Kryo kryo, @NotNull Output output2, @NotNull CidrTestScopeElement testScope) {
            if (testScope instanceof CidrTestScopeElementWithSerializerImpl) {
                output2.writeInt(0);
                ((CidrTestScopeElementWithSerializerImpl)testScope).write(output2);
                return;
            }
            output2.writeInt(-1);
        }

        @Override
        @Nullable
        public CidrTestScopeElement read(@NotNull Kryo kryo, @NotNull Input input2, @NotNull PsiFile psiFileWithTest) {
            int watermark = input2.readInt();
            if (watermark == 0) {
                return CidrTestScopeElementWithSerializerImpl.read(input2, psiFileWithTest, this.getGenerator());
            }
            return null;
        }

        @NotNull
        @Contract(pure=true)
        public Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> getGenerator() {
            assert (this.myGenerator != null);
            return this.myGenerator;
        }
    }

    private static abstract class CidrTestScopeElementWithSerializerImpl
    extends CidrTestScopeElementForCacheImpl {
        CidrTestScopeElementWithSerializerImpl(@NotNull PsiFile psiFile, long offsetAsNaturalOrder, @Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            super(psiFile, offsetAsNaturalOrder, suiteName, testName, generator);
        }

        public abstract void write(@NotNull Output var1);

        @NotNull
        public static CidrTestScopeElement read(@NotNull Input input2, @NotNull PsiFile psiFileWithTest, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
            String testName = input2.readString();
            String suiteName = input2.readString();
            long offsetAsNaturalOrder = input2.readLong();
            String uniqueTestBodyElementId = input2.readString();
            String name = input2.readString();
            OCSymbolKind kind = StringUtil.isEmpty((String)name) ? null : OCSymbolKind.valueOf(name);
            return CidrTestScopeSerialization.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, uniqueTestBodyElementId, psiFileWithTest, kind, generator);
        }
    }
}

