/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestIndexingTask {
    private final Ref<Task.Backgroundable> myUIProgressTask = Ref.create();
    private volatile ProgressSuspender myUIProgressTaskSuspender = null;
    private volatile ProgressIndicator myUIProgressIndicator = null;
    private volatile boolean myIsSuspended = false;
    private final Project myProject;
    private final HashSet<CidrTestListUpdater> myUpdaters = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTextInfo(@Nullable String text1, @Nullable String text2) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myUIProgressIndicator != null) {
                double min = 1.0;
                for (CidrTestListUpdater updater : this.myUpdaters) {
                    double fraction = updater.getFraction();
                    if (!updater.isIndexing() || !(fraction < min)) continue;
                    min = fraction;
                }
                if (this.myUIProgressIndicator.isIndeterminate()) {
                    this.myUIProgressIndicator.setIndeterminate(false);
                }
                this.myUIProgressIndicator.setFraction(min);
                if (text1 != null) {
                    this.myUIProgressIndicator.setText(text1);
                }
                if (text2 != null) {
                    this.myUIProgressIndicator.setText2(text2);
                }
            }
        }
    }

    public static CidrTestIndexingTask getInstance(@NotNull Project project) {
        return (CidrTestIndexingTask)project.getService(CidrTestIndexingTask.class);
    }

    protected CidrTestIndexingTask(@NotNull Project project) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                if ("cidr.test.framework.showIndexingAsTask".equals(id)) {
                    if (CidrTestListUpdater.showTestIndexingProgress()) {
                        CidrTestIndexingTask.this.updateVisibilityStatus(true, false);
                    } else {
                        CidrTestIndexingTask.this.hideSuspendableTestIndexingTask();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull CidrTestListUpdater updater) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUpdaters.add(updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(@NotNull CidrTestListUpdater updater) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUpdaters.remove(updater);
            this.updateVisibilityStatus(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibilityStatus(boolean showIfNeed, boolean hideIfNeed) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            for (CidrTestListUpdater updater : this.myUpdaters) {
                if (!updater.isIndexing()) continue;
                if (showIfNeed) {
                    this.showSuspendableTestIndexingTask();
                }
                return;
            }
            if (hideIfNeed) {
                this.hideSuspendableTestIndexingTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            return this.myIsSuspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            return this.doIsVisible();
        }
    }

    private boolean doIsVisible() {
        return this.myUIProgressTask.get() != null && this.myUIProgressTaskSuspender != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myIsSuspended) {
                this.doResume();
                this.doSyncSuspenderStateInUI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (!this.myIsSuspended) {
                this.doSuspend(true);
                this.doSyncSuspenderStateInUI();
            }
        }
    }

    private void doResume() {
        CidrTestListUpdater.log("Resume Test Indexing", new Object[0]);
        this.myIsSuspended = false;
        this.myUpdaters.forEach(updater -> updater.scheduleUpdatePass());
    }

    private void doSuspend(boolean cleanupUpdateQueue) {
        CidrTestListUpdater.log("Suspend Test Indexing with cleanup update queue: " + cleanupUpdateQueue, new Object[0]);
        this.myIsSuspended = true;
        this.myUpdaters.forEach(updater -> {
            updater.suspendedUpdatePass();
            if (cleanupUpdateQueue) {
                updater.cancelTestIndexing(false, true);
            }
        });
    }

    private void doSyncSuspenderStateInUI() {
        if (this.doIsVisible()) {
            if (this.myIsSuspended) {
                this.myUIProgressTaskSuspender.suspendProcess(CTestingBundle.message("test.project.indexing.tests.cancel", new Object[0]));
            } else {
                this.myUIProgressTaskSuspender.resumeProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSuspendableTestIndexingTask() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myUIProgressTask.get() == null) {
                MySubProgressTask subProgressTask = new MySubProgressTask();
                this.myUIProgressTask.set((Object)subProgressTask);
                ApplicationUtil.invokeLaterSomewhere((EdtReplacementThread)EdtReplacementThread.EDT, (ModalityState)ModalityState.NON_MODAL, () -> subProgressTask.setCancelText(CTestingBundle.message("test.project.indexing.tests.cancel", new Object[0])).setCancelTooltipText(CTestingBundle.message("test.project.indexing.tests.cancel.tooltip", new Object[0])).queue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSuspendableTestIndexingTask() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUIProgressTask.set(null);
            this.myUIProgressTask.notifyAll();
        }
    }

    private class MySubProgressTask
    extends Task.Backgroundable {
        private MySubProgressTask() {
            super(CidrTestIndexingTask.this.myProject, CTestingBundle.message("test.project.indexing.tests", new Object[0]), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (this.myProject == null || this.myProject.isDisposed()) {
                return;
            }
            Disposable taskLiveTime = Disposer.newDisposable();
            Disposer.register((Disposable)this.myProject, (Disposable)taskLiveTime);
            Ref<Task.Backgroundable> ref = CidrTestIndexingTask.this.myUIProgressTask;
            synchronized (ref) {
                try {
                    CidrTestIndexingTask.this.myUIProgressIndicator = indicator;
                    CidrTestIndexingTask.this.updateTextInfo(null, null);
                    String message = CTestingBundle.message("test.project.indexing.tests.paused", new Object[0]);
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender = ProgressSuspender.markSuspendable((ProgressIndicator)indicator, (String)message);
                    if (CidrTestIndexingTask.this.myIsSuspended) {
                        CidrTestIndexingTask.this.myUIProgressTaskSuspender.suspendProcess(message);
                    }
                    MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(taskLiveTime);
                    connection.subscribe(ProgressSuspender.TOPIC, (Object)new MySuspenderListener());
                    while (CidrTestIndexingTask.this.myUIProgressTask.get() != null) {
                        try {
                            CidrTestIndexingTask.this.myUIProgressTask.wait(250L);
                            if (!indicator.isCanceled()) continue;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
                finally {
                    if (indicator.isCanceled()) {
                        CidrTestIndexingTask.this.doSuspend(true);
                    }
                    CidrTestIndexingTask.this.myUIProgressIndicator = null;
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender.close();
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender = null;
                    CidrTestIndexingTask.this.myUIProgressTask.set(null);
                    Disposer.dispose((Disposable)taskLiveTime);
                }
            }
        }
    }

    private class MySuspenderListener
    implements ProgressSuspender.SuspenderListener {
        private MySuspenderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
            Ref<Task.Backgroundable> ref = CidrTestIndexingTask.this.myUIProgressTask;
            synchronized (ref) {
                if (CidrTestIndexingTask.this.myUIProgressTaskSuspender == changedSuspender) {
                    if (CidrTestIndexingTask.this.myUIProgressTaskSuspender.isSuspended()) {
                        CidrTestIndexingTask.this.doSuspend(false);
                    } else {
                        CidrTestIndexingTask.this.doResume();
                    }
                }
            }
        }
    }
}

