/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestIndexContributor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrTestIndexProvider;", "", "()V", "MAP_TF_CONTRIBUTOR", "Lcom/intellij/openapi/util/Key;", "", "", "Lcom/jetbrains/cidr/execution/testing/CidrTestIndexContributor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "findContributorByName", "name", "findTestObject", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "element", "Lcom/intellij/psi/PsiElement;", "extractIfNotRecognized", "Lkotlin/Function0;", "gatherTestLinks", "", "file", "Lcom/intellij/psi/PsiFile;", "framework", "getDefaultContributor", "pickCollector", "updateMaintainer", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "contributor", "intellij.c.testing"})
public final class CidrTestIndexProvider {
    @NotNull
    public static final CidrTestIndexProvider INSTANCE = new CidrTestIndexProvider();
    @NotNull
    private static final Key<Map<String, CidrTestIndexContributor>> MAP_TF_CONTRIBUTOR = Key.create((String)"LAST_TEST_INDEX_CONTRIBUTOR");

    private CidrTestIndexProvider() {
    }

    private final CidrTestIndexContributor findContributorByName(String name) {
        return (CidrTestIndexContributor)ContainerUtil.find((Iterable)CidrTestIndexContributor.getInstances(), arg_0 -> CidrTestIndexProvider.findContributorByName$lambda$0((Function1)new Function1<CidrTestIndexContributor, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(CidrTestIndexContributor it) {
                return Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)this.$name);
            }
        }, arg_0));
    }

    private final CidrTestIndexContributor getDefaultContributor(PsiFile file, String framework) {
        return switch (framework) {
            case "gtest" -> this.findContributorByName("CidrGoogleTestIndexContributor");
            case "boost" -> this.findContributorByName("CidrBoostTestIndexContributor");
            case "doctest" -> this.findContributorByName("CidrDoctestTestIndexContributor");
            case "catch" -> this.findContributorByName("CidrCatchIndexContributor");
            default -> null;
        };
    }

    private final CidrTestIndexContributor pickCollector(PsiFile file, String framework) {
        CidrTestIndexContributor cidrTestIndexContributor = (CidrTestIndexContributor)ContainerUtil.find((Iterable)CidrTestIndexContributor.getInstances(), arg_0 -> CidrTestIndexProvider.pickCollector$lambda$1((Function1)new Function1<CidrTestIndexContributor, Boolean>(file, framework){
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ String $framework;
            {
                this.$file = $file;
                this.$framework = $framework;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CidrTestIndexContributor t) {
                return t.canProcessFile(this.$file, this.$framework);
            }
        }, arg_0));
        if (cidrTestIndexContributor == null) {
            cidrTestIndexContributor = this.getDefaultContributor(file, framework);
        }
        return cidrTestIndexContributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateMaintainer(VirtualFile vFile, String framework, CidrTestIndexContributor contributor) {
        VirtualFile virtualFile = vFile;
        synchronized (virtualFile) {
            boolean bl = false;
            Map cached = (Map)MAP_TF_CONTRIBUTOR.get((UserDataHolder)vFile);
            if (cached == null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)framework, (Object)contributor)};
                MAP_TF_CONTRIBUTOR.set((UserDataHolder)vFile, (Object)MapsKt.mutableMapOf((Pair[])pairArray));
                return;
            }
            cached.put(framework, contributor);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Map<String, CidrTestScopeElement> gatherTestLinks(@NotNull PsiFile file, @NotNull String framework) {
        CidrTestIndexContributor cidrTestIndexContributor = this.pickCollector(file, framework);
        if (cidrTestIndexContributor == null) {
            return MapsKt.emptyMap();
        }
        CidrTestIndexContributor contributor = cidrTestIndexContributor;
        Map<String, CidrTestScopeElement> result = MapsKt.emptyMap();
        try {
            result = contributor.gatherTestLinks(file, framework);
            this.updateMaintainer(file.getVirtualFile(), framework, contributor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            CidrTestIndexContributor defaultContributor = this.getDefaultContributor(file, framework);
            if (defaultContributor == null || Intrinsics.areEqual((Object)defaultContributor, (Object)contributor)) {
                return MapsKt.emptyMap();
            }
            result = defaultContributor.gatherTestLinks(file, framework);
            this.updateMaintainer(file.getVirtualFile(), framework, defaultContributor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CidrTestScopeElement findTestObject(@NotNull PsiElement element, @NotNull Function0<? extends CidrTestScopeElement> extractIfNotRecognized) {
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        Object cached = null;
        VirtualFile virtualFile = vFile;
        synchronized (virtualFile) {
            boolean bl = false;
            cached = MAP_TF_CONTRIBUTOR.get((UserDataHolder)vFile);
            Unit unit = Unit.INSTANCE;
        }
        if (cached == null) {
            return (CidrTestScopeElement)extractIfNotRecognized.invoke();
        }
        for (Map.Entry entry : ((Map)cached).entrySet()) {
            CidrTestIndexContributor contributor = (CidrTestIndexContributor)entry.getValue();
            CidrTestScopeElement cidrTestScopeElement = contributor.findTest(element);
            if (cidrTestScopeElement == null) continue;
            return cidrTestScopeElement;
        }
        return null;
    }

    private static final boolean findContributorByName$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean pickCollector$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

