/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestNoIndexSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestFrameworkLanguageSupport
implements CidrTestLanguageSupport {
    protected final CidrTestWithScopeElementsAndGeneratorFramework myFramework;

    public CidrTestFrameworkLanguageSupport(CidrTestWithScopeElementsAndGeneratorFramework framework) {
        this.myFramework = framework;
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return this.myFramework.getProtocolPrefix();
    }

    @NonNls
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return this.myFramework.getPatternSeparatorInCommandLine();
    }

    public boolean isAvailable(@Nullable PsiFile file) {
        return CidrTestNoIndexSupport.findCachedTestObject((PsiElement)file, (String)this.getProtocolPrefix()) != null || this.myFramework.isAvailable(file);
    }

    public CidrTestScopeElement findTestObject(PsiElement element) {
        CidrTestScopeElement findCachedTestObject = CidrTestNoIndexSupport.findCachedTestObject((PsiElement)element, (String)this.getProtocolPrefix());
        if (findCachedTestObject != null) {
            return findCachedTestObject;
        }
        return (CidrTestScopeElement)this.myFramework.findTestObject(element);
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        return this.myFramework.getProjectSourcesScope(project);
    }

    public boolean areSymbolsLoaded(@NotNull Project project) {
        return FileSymbolTablesCache.areSymbolsLoaded(project);
    }

    public boolean isIndexing(@NotNull Project project) {
        return this.myFramework.getUpdater(project).isIndexing();
    }

    public Collection<? extends CidrTestScopeElement> getElementsInFile(@NotNull PsiFile file) {
        return this.myFramework.getTestObjects(OCLanguageUtils.tryGetOCFile(file)).values();
    }

    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        return this.myFramework.getUpdater(project);
    }

    @NotNull
    public Collection<CidrTestScopeElement> findTestScopeElementsSync(@NotNull @NonNls String locationPath, @NotNull @NonNls String configName, @Nullable @NonNls String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        return this.myFramework.collectTestObjects(locationPath, project, scope);
    }

    @NotNull
    public List<Location> getLocationSafe(@NotNull Project project, @NotNull Computable<List<Location>> findLocationsInScope) {
        return (List)OCTestExecution.executeWithCachedValuesFast(() -> this.myFramework.getUpdater(project).getLocation(findLocationsInScope));
    }
}

