/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrTargetConfigurationHelper;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTargetConfigurationHelper
implements CidrTargetConfigurationHelper {
    protected static final Key<Pair<Boolean, Long>> ourIsEntryPoint = Key.create((String)"Is entry point");
    protected static final Key<Pair<Boolean, Long>> ourFileHasEntryPoint = Key.create((String)"file.has.entry.point");

    public boolean isInEntryPointBody(@NotNull Location location) {
        return OCTargetConfigurationHelper.isInEntryPointBody(location.getPsiElement());
    }

    @RequiresBackgroundThread
    public static boolean hasEntryPoint(PsiFile file) {
        if (file instanceof OCFile) {
            Pair<Boolean, Long> entryVersion = OCTargetConfigurationHelper.getEntryPointData((PsiElement)file, ourFileHasEntryPoint, (Producer<Boolean>)((Producer)() -> {
                PsiElement function = (PsiElement)ContainerUtil.find((Object[])file.getChildren(), element -> OCTargetConfigurationHelper.isEntryPoint(element));
                if (function != null) {
                    return true;
                }
                return null;
            }));
            return entryVersion != null && entryVersion.first == Boolean.TRUE;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEntryPoint(@Nullable PsiElement maybeMainDecl) {
        if (maybeMainDecl instanceof OCFunctionDefinition) {
            Pair<Boolean, Long> entryVersion = OCTargetConfigurationHelper.getEntryPointData(maybeMainDecl, ourIsEntryPoint, (Producer<Boolean>)((Producer)() -> {
                OCFunctionSymbol symbol = ((OCFunctionDefinition)maybeMainDecl).getSymbol();
                if (symbol != null && symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION) {
                    return symbol.isMainFunction();
                }
                return null;
            }));
            return entryVersion != null && entryVersion.first == Boolean.TRUE;
        }
        return false;
    }

    public static boolean isInEntryPointBody(@NotNull PsiElement element) {
        return OCTargetConfigurationHelper.isInEntryPointBody(element, null);
    }

    private static boolean isInEntryPointBody(@NotNull PsiElement element, @Nullable PsiElement topParent) {
        for (PsiElement current = element; current != null; current = current.getParent()) {
            if (current instanceof PsiFile || current == topParent) {
                return false;
            }
            if (current instanceof OCMacroCall && topParent == null) {
                Ref ref = new Ref();
                PsiElement macroAsParent = current;
                ((OCMacroCall)current).processExpansionLeaves((Processor<? super PsiElement>)((Processor)leaf -> {
                    boolean inEP = OCTargetConfigurationHelper.isInEntryPointBody(leaf, macroAsParent);
                    if (inEP) {
                        ref.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }));
                if (ref.get() != Boolean.TRUE) continue;
                return true;
            }
            if (!OCTargetConfigurationHelper.isEntryPoint(current)) continue;
            return true;
        }
        return false;
    }

    private static Pair<Boolean, Long> getEntryPointData(@NotNull PsiElement element, Key<Pair<Boolean, Long>> key, Producer<Boolean> computeRunnable) {
        Boolean res;
        Pair entryVersion = (Pair)key.get((UserDataHolder)element);
        long version = FileSymbolTablesCache.getInstance(element.getProject()).getOutOfBlockModificationTracker().getModificationCount();
        if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
            return entryVersion;
        }
        if (OCTestExecution.canWaitInThisThread() && (res = (Boolean)computeRunnable.produce()) != null) {
            entryVersion = Pair.pair((Object)res, (Object)version);
            key.set((UserDataHolder)element, (Object)entryVersion);
        }
        if (entryVersion != null && ((Long)entryVersion.second).equals(version)) {
            return entryVersion;
        }
        return null;
    }
}

