/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveConfigurationProvider
implements CidrResolveConfigurationProvider {
    public Collection<OCResolveConfiguration> getAllResolveConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        return OCInclusionContextUtil.getAllBuildConfigurationsForFile(file, null);
    }

    public Collection<OCResolveConfiguration> getAllResolveConfigurationsOfTargetsOfFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)virtualFile, (Project)project);
    }

    @NotNull
    public Collection<VirtualFile> findRoots(@NotNull Project project, @NotNull VirtualFile file) {
        if (OCRootUtil.isNeedToFindRoot(file, project)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(file);
            @Nullable VirtualFile rootFile = rootAndConfiguration.getRootFile();
            if (rootFile != null && !OCRootUtil.isNeedToFindRoot(rootFile, project)) {
                return Collections.singleton(rootFile);
            }
            ProgressManager.checkCanceled();
            return OCImportGraph.getInstance(Objects.requireNonNull(project)).getAllHeaderRoots(file);
        }
        return Collections.singleton(file);
    }
}

