/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocComment;
import com.jetbrains.cidr.doxygen.psi.DxFile;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoxygenUtil {
    public static final String DOCUMENTATION_COMMENT_PREFIX = "/**";
    public static final String DOCUMENTATION_COMMENT_PREFIX2 = "/*!";
    public static final String BLOCK_COMMENT_SUFFIX = "*/";
    public static final String EOL_DOCUMENTATION_COMMENT_PREFIX = "///";
    public static final String EOL_DOCUMENTATION_COMMENT_PREFIX2 = "//!";
    public static final String ELLIPSIS = "...";

    private DoxygenUtil() {
    }

    public static boolean isDoxygenComment(@NotNull PsiComment comment) {
        return DoxygenUtil.isDoxygenBlockComment(comment.getText()) || DoxygenUtil.isDoxygenEOLComment(comment.getText());
    }

    public static boolean isDoxygenBlockComment(String commentText) {
        if (commentText.equals("/**/")) {
            return false;
        }
        return commentText.startsWith(DOCUMENTATION_COMMENT_PREFIX) || commentText.startsWith(DOCUMENTATION_COMMENT_PREFIX2);
    }

    public static boolean isDoxygenEOLComment(String commentText) {
        return commentText.startsWith(EOL_DOCUMENTATION_COMMENT_PREFIX) || commentText.startsWith(EOL_DOCUMENTATION_COMMENT_PREFIX2);
    }

    public static boolean hasArrow(@NotNull PsiComment comment) {
        String text = comment.getText();
        return text.length() > 3 && text.charAt(3) == '<';
    }

    @Nullable
    public static DxDocComment convertToDoxygen(@NotNull PsiComment comment) {
        PsiElement child;
        PsiElement element;
        InjectedLanguageManager langMgr = InjectedLanguageManager.getInstance((Project)comment.getProject());
        List files = langMgr.getInjectedPsiFiles((PsiElement)comment);
        if (files != null && !files.isEmpty() && (element = (PsiElement)((Pair)files.get((int)0)).first) instanceof DxFile && (child = element.getFirstChild()) instanceof DxDocComment) {
            return (DxDocComment)child;
        }
        return null;
    }

    @Nullable
    public static PsiComment getHostComment(@NotNull PsiElement dxPsiElement) {
        InjectedLanguageManager langMgr = InjectedLanguageManager.getInstance((Project)dxPsiElement.getProject());
        PsiLanguageInjectionHost host = langMgr.getInjectionHost(dxPsiElement);
        return (PsiComment)host;
    }

    @Nullable
    public static OCCallable<?> findFunction(@Nullable PsiComment comment) {
        PsiElement owner;
        if (comment instanceof PsiDocCommentBase && (owner = ((PsiDocCommentBase)comment).getOwner()) instanceof OCCallable) {
            return (OCCallable)owner;
        }
        return null;
    }

    public static boolean hasNextDocCommentSibling(@Nullable PsiComment comment) {
        if (comment != null) {
            for (PsiElement child = comment.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace) continue;
                if (child instanceof PsiComment) {
                    if (!DoxygenUtil.isDoxygenComment((PsiComment)child)) continue;
                    return true;
                }
                if (!(child instanceof OCCallable)) break;
                List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)child, PsiComment.class);
                for (PsiComment c : comments) {
                    if (!DoxygenUtil.isDoxygenComment(c)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static void traverseTemplateParametersList(@Nullable PsiElement owner, @NotNull Consumer<? super String> c) {
        DoxygenUtil.traverseTemplateParametersList(owner, (? super PsiNamedElement element, ? super String name) -> {
            c.accept((String)name);
            return true;
        });
    }

    @Nullable
    public static PsiNamedElement traverseTemplateParametersList(@Nullable PsiElement owner, @NotNull BiFunction<? super PsiNamedElement, ? super String, Boolean> f) {
        if (owner instanceof OCDeclaration) {
            List templateParametersList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)owner, OCTemplateParameterList.class);
            for (OCTemplateParameterList templateParameters : templateParametersList) {
                for (OCElement param : templateParameters.getParameters()) {
                    String name = null;
                    PsiNameIdentifierOwner element = null;
                    if (param instanceof OCTypeParameterDeclaration) {
                        element = (OCTypeParameterDeclaration)param;
                        name = element.getName();
                    } else if (param instanceof OCParameterDeclaration && (element = ((OCParameterDeclaration)param).getDeclarator()) != null) {
                        name = element.getName();
                    }
                    if (f.apply((PsiNamedElement)element, DoxygenUtil.getName(name, (PsiNamedElement)element)).booleanValue()) continue;
                    return element;
                }
            }
        }
        return null;
    }

    @NotNull
    public static String getName(@Nullable String name, @Nullable PsiNamedElement element) {
        Object symbol;
        if (name != null && !name.isEmpty() && !"<unnamed>".equals(name)) {
            return name;
        }
        if (element != null && element.getText().equals(ELLIPSIS)) {
            return ELLIPSIS;
        }
        if (element instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCTypeParameterSymbol && ((OCTypeParameterSymbol)symbol).isVariadic()) {
            return ELLIPSIS;
        }
        return "<unnamed>";
    }
}

