/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.dev.psiViewer.PsiViewerExtension;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiViewerSourceWrapper
implements Comparable<PsiViewerSourceWrapper> {
    final FileType myFileType;
    final PsiViewerExtension myExtension;

    private PsiViewerSourceWrapper(@NotNull FileType fileType) {
        this.myFileType = fileType;
        this.myExtension = null;
    }

    private PsiViewerSourceWrapper(@NotNull PsiViewerExtension extension) {
        this.myFileType = null;
        this.myExtension = extension;
    }

    public String getText() {
        return this.myFileType != null ? this.myFileType.getName() + " file" : this.myExtension.getName();
    }

    @Nullable
    public Icon getIcon() {
        return this.myFileType != null ? this.myFileType.getIcon() : this.myExtension.getIcon();
    }

    @Override
    public int compareTo(@NotNull PsiViewerSourceWrapper o) {
        return this.getText().compareToIgnoreCase(o.getText());
    }

    @NotNull
    static List<PsiViewerSourceWrapper> getExtensionBasedWrappers() {
        return ContainerUtil.map((Collection)PsiViewerExtension.EP_NAME.getExtensionList(), el -> new PsiViewerSourceWrapper((PsiViewerExtension)el));
    }

    @NotNull
    static List<PsiViewerSourceWrapper> getFileTypeBasedWrappers() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        ArrayList<PsiViewerSourceWrapper> sourceWrappers = new ArrayList<PsiViewerSourceWrapper>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        for (FileType fileType : allFileTypes) {
            if (!PsiViewerSourceWrapper.isAcceptableFileType(fileType)) continue;
            PsiViewerSourceWrapper wrapper = new PsiViewerSourceWrapper(fileType);
            sourceWrappers.add(wrapper);
        }
        return sourceWrappers;
    }

    private static boolean isAcceptableFileType(FileType fileType) {
        return fileType != StdFileTypes.GUI_DESIGNER_FORM && fileType != ModuleFileType.INSTANCE && fileType != ProjectFileType.INSTANCE && fileType != WorkspaceFileType.INSTANCE && fileType != ArchiveFileType.INSTANCE && fileType != FileTypes.UNKNOWN && fileType != FileTypes.PLAIN_TEXT && !(fileType instanceof AbstractFileType) && !fileType.isBinary() && !fileType.isReadOnly();
    }
}

