/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.dev.psiViewer.DevPsiViewerBundle;
import com.intellij.dev.psiViewer.PsiViewerExtension;
import com.intellij.dev.psiViewer.PsiViewerSettings;
import com.intellij.dev.psiViewer.PsiViewerSourceWrapper;
import com.intellij.dev.psiViewer.ViewerNodeDescriptor;
import com.intellij.dev.psiViewer.ViewerPsiBasedTree;
import com.intellij.dev.psiViewer.ViewerTreeStructure;
import com.intellij.dev.psiViewer.formatter.BlockViewerPsiBasedTree;
import com.intellij.dev.psiViewer.stubs.StubViewerPsiBasedTree;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiViewerDialog
extends DialogWrapper
implements DataProvider {
    private static final Color BOX_COLOR = new JBColor(new Color(16542720), new Color(14576641));
    public static final Logger LOG = Logger.getInstance(PsiViewerDialog.class);
    private final Project myProject;
    private final StructureTreeModel<ViewerTreeStructure> myStructureTreeModel;
    private final ViewerTreeStructure myTreeStructure;
    private JPanel myPanel;
    private JComboBox<PsiViewerSourceWrapper> myFileTypeComboBox;
    private JCheckBox myShowWhiteSpacesBox;
    private JCheckBox myShowTreeNodesCheckBox;
    private JBLabel myDialectLabel;
    private JComboBox<Language> myDialectComboBox;
    private JLabel myExtensionLabel;
    private JComboBox<String> myExtensionComboBox;
    private JPanel myTextPanel;
    private JSplitPane myTextSplit;
    private JSplitPane myTreeSplit;
    private Tree myPsiTree;
    private final JList<String> myRefs;
    private TitledSeparator myTextSeparator;
    private TitledSeparator myPsiTreeSeparator;
    @NotNull
    private final StubViewerPsiBasedTree myStubTree;
    @NotNull
    private final BlockViewerPsiBasedTree myBlockTree;
    private RangeHighlighter myHighlighter;
    private final Set<PsiViewerSourceWrapper> mySourceWrappers;
    private final EditorEx myEditor;
    private final EditorListener myEditorListener;
    private String myLastParsedText;
    private int myLastParsedTextHashCode;
    private int myNewDocumentHashCode;
    private final boolean myExternalDocument;
    private final Map<PsiElement, PsiElement[]> myRefsResolvedCache;
    private final PsiFile myOriginalPsiFile;
    @NotNull
    private final JBTabs myTabs;
    private static final Pattern EXT_PATTERN = Pattern.compile("[a-z\\d]*");

    private void createUIComponents() {
        this.myPsiTree = new Tree();
    }

    PsiViewerDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.mySourceWrappers = new TreeSet<PsiViewerSourceWrapper>();
        this.myEditorListener = new EditorListener();
        this.myLastParsedTextHashCode = 17;
        this.myNewDocumentHashCode = 11;
        this.myRefsResolvedCache = new HashMap<PsiElement, PsiElement[]>();
        this.myProject = project;
        this.myExternalDocument = selectedEditor != null;
        this.myOriginalPsiFile = PsiViewerDialog.getOriginalPsiFile(project, selectedEditor);
        this.myTabs = this.createTabPanel(project);
        this.myRefs = new JBList(new DefaultListModel());
        this.myTreeStructure = new ViewerTreeStructure(this.myProject);
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.myTreeStructure, (Comparator)IndexComparator.INSTANCE, this.getDisposable());
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myStructureTreeModel, this.getDisposable());
        this.myPsiTree.setModel((TreeModel)asyncTreeModel);
        ViewerPsiBasedTree.PsiTreeUpdater psiTreeUpdater = new ViewerPsiBasedTree.PsiTreeUpdater(){
            private final TextAttributes myAttributes = new TextAttributes();
            {
                this.myAttributes.setEffectColor(BOX_COLOR);
                this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
            }

            @Override
            public void updatePsiTree(@NotNull PsiElement toSelect, @Nullable TextRange selectRangeInEditor) {
                if (selectRangeInEditor != null) {
                    int start = selectRangeInEditor.getStartOffset();
                    int end = selectRangeInEditor.getEndOffset();
                    PsiViewerDialog.this.clearSelection();
                    if (end <= PsiViewerDialog.this.myEditor.getDocument().getTextLength()) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                        PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                }
                PsiViewerDialog.this.updateReferences(toSelect);
                if (!PsiViewerDialog.this.myPsiTree.hasFocus()) {
                    PsiViewerDialog.this.selectElement(toSelect);
                }
            }
        };
        this.myStubTree = new StubViewerPsiBasedTree(project, psiTreeUpdater);
        this.myBlockTree = new BlockViewerPsiBasedTree(project, psiTreeUpdater);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myStubTree);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBlockTree);
        this.setOKButtonText("&Build PSI Tree");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle((String)(selectedFile == null ? "PSI Viewer" : "PSI Viewer: " + selectedFile.getName()));
        if (selectedEditor != null) {
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        } else {
            PsiViewerSettings settings = PsiViewerSettings.getSettings();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)settings.text));
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
            this.myEditor.getSelectionModel().setSelection(0, document.getTextLength());
        }
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        DocRenderManager.setDocRenderingEnabled((Editor)this.myEditor, (Boolean)false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true));
                this.myEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    @Nullable
    private static PsiFile getOriginalPsiFile(@NotNull Project project, @Nullable Editor selectedEditor) {
        return selectedEditor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedEditor.getDocument()) : null;
    }

    @NotNull
    private JBTabs createTabPanel(@NotNull Project project) {
        JBEditorTabsBase tabs = JBTabsFactory.createEditorTabs((Project)project, (Disposable)this.getDisposable());
        tabs.getPresentation().setAlphabeticalMode(false).setSupportsCompression(false);
        return tabs;
    }

    protected void init() {
        TabInfo defaultInfo;
        this.initMnemonics();
        PsiViewerDialog.initTree((JTree)this.myPsiTree);
        TreeCellRenderer renderer = this.myPsiTree.getCellRenderer();
        this.myPsiTree.setCellRenderer((tree, value, selected, expanded, leaf, row, hasFocus) -> {
            Object userObject;
            Component c = renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ViewerNodeDescriptor) {
                Object element = ((ViewerNodeDescriptor)((Object)((Object)userObject))).getElement();
                if (c instanceof NodeRenderer) {
                    ((NodeRenderer)c).setToolTipText(element == null ? null : element.getClass().getName());
                }
                if (element instanceof PsiElement && FileContextUtil.getFileContext((PsiFile)((PsiElement)element).getContainingFile()) != null || element instanceof ViewerTreeStructure.Inject) {
                    TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
                    c.setBackground(attr.getBackgroundColor());
                }
            }
            return c;
        });
        this.myPsiTree.addTreeSelectionListener((TreeSelectionListener)new MyPsiTreeSelectionListener());
        JPanel panelWrapper = new JPanel(new BorderLayout());
        panelWrapper.add(this.myTabs.getComponent());
        this.myTreeSplit.add((Component)panelWrapper, "right");
        JPanel referencesPanel = new JPanel(new BorderLayout());
        referencesPanel.add(this.myRefs);
        referencesPanel.setBorder(IdeBorderFactory.createBorder());
        this.myTabs.addTab(new TabInfo((JComponent)referencesPanel).setText("References"));
        this.myTabs.addTab(new TabInfo(this.myBlockTree.getComponent()).setText("Block Structure"));
        this.myTabs.addTab(new TabInfo(this.myStubTree.getComponent()).setText("Stub Structure"));
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        int tabIndex = settings.lastSelectedTabIndex;
        TabInfo tabInfo = defaultInfo = tabIndex < this.myTabs.getTabCount() ? this.myTabs.getTabAt(tabIndex) : null;
        if (defaultInfo != null) {
            this.myTabs.select(defaultInfo, false);
        }
        this.myTabs.setSelectionChangeHandler((tab, focus, el) -> {
            settings.lastSelectedTabIndex = this.myTabs.getIndexOf(tab);
            return el.run();
        });
        GoToListener listener = new GoToListener();
        this.myRefs.addKeyListener(listener);
        this.myRefs.addMouseListener(listener);
        this.myRefs.getSelectionModel().addListSelectionListener(listener);
        this.myRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PsiElement[] elements = PsiViewerDialog.this.myRefsResolvedCache.get(PsiViewerDialog.this.getPsiElement());
                if (elements == null || elements.length <= index || elements[index] == null) {
                    comp.setForeground((Color)JBColor.RED);
                }
                return comp;
            }
        });
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this.myEditorListener, this.getDisposable());
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorListener);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this.myEditorListener);
        FocusTraversalPolicy oldPolicy = this.getPeer().getWindow().getFocusTraversalPolicy();
        this.getPeer().getWindow().setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(@NotNull Window window) {
                return PsiViewerDialog.this.myEditor.getComponent();
            }
        });
        Disposer.register((Disposable)this.getDisposable(), () -> this.getPeer().getWindow().setFocusTraversalPolicy(oldPolicy));
        VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
        Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file);
        String type = curLanguage != null ? curLanguage.getDisplayName() : settings.type;
        PsiViewerSourceWrapper lastUsed = null;
        this.mySourceWrappers.addAll(PsiViewerSourceWrapper.getExtensionBasedWrappers());
        List<PsiViewerSourceWrapper> fileTypeBasedWrappers = PsiViewerSourceWrapper.getFileTypeBasedWrappers();
        for (PsiViewerSourceWrapper wrapper : fileTypeBasedWrappers) {
            this.mySourceWrappers.addAll(fileTypeBasedWrappers);
            if ((lastUsed != null || !wrapper.getText().equals(type)) && (curLanguage == null || wrapper.myFileType != curLanguage.getAssociatedFileType())) continue;
            lastUsed = wrapper;
        }
        this.myFileTypeComboBox.setModel((ComboBoxModel<PsiViewerSourceWrapper>)new CollectionComboBoxModel(new ArrayList<PsiViewerSourceWrapper>(this.mySourceWrappers), lastUsed));
        this.myFileTypeComboBox.setRenderer((ListCellRenderer<PsiViewerSourceWrapper>)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getText());
                label.setIcon(value.getIcon());
            }
        }));
        new ComboboxSpeedSearch(this.myFileTypeComboBox){

            protected String getElementText(Object element) {
                return element instanceof PsiViewerSourceWrapper ? ((PsiViewerSourceWrapper)element).getText() : null;
            }
        };
        this.myFileTypeComboBox.addActionListener(__ -> {
            this.updateDialectsCombo(null);
            this.updateExtensionsCombo();
            this.updateEditor();
        });
        this.myDialectComboBox.addActionListener(__ -> this.updateEditor());
        new ComboboxSpeedSearch(this.myDialectComboBox){

            protected String getElementText(Object element) {
                return element instanceof Language ? ((Language)element).getDisplayName() : "<default>";
            }
        };
        this.myFileTypeComboBox.addFocusListener(new AutoExpandFocusListener(this.myFileTypeComboBox));
        if (!this.myExternalDocument && lastUsed == null && !this.mySourceWrappers.isEmpty()) {
            this.myFileTypeComboBox.setSelectedIndex(0);
        }
        this.myDialectComboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((String)"(none)", value -> value.getDisplayName()));
        this.myDialectComboBox.addFocusListener(new AutoExpandFocusListener(this.myDialectComboBox));
        this.myExtensionComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", value -> "." + value));
        this.myExtensionComboBox.addFocusListener(new AutoExpandFocusListener(this.myExtensionComboBox));
        this.myShowWhiteSpacesBox.addActionListener(__ -> {
            this.myTreeStructure.setShowWhiteSpaces(this.myShowWhiteSpacesBox.isSelected());
            this.myStructureTreeModel.invalidateAsync();
        });
        this.myShowTreeNodesCheckBox.addActionListener(__ -> {
            this.myTreeStructure.setShowTreeNodes(this.myShowTreeNodesCheckBox.isSelected());
            this.myStructureTreeModel.invalidateAsync();
        });
        this.myShowWhiteSpacesBox.setSelected(settings.showWhiteSpaces);
        this.myTreeStructure.setShowWhiteSpaces(settings.showWhiteSpaces);
        this.myShowTreeNodesCheckBox.setSelected(settings.showTreeNodes);
        this.myTreeStructure.setShowTreeNodes(settings.showTreeNodes);
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.updateDialectsCombo(settings.dialect);
        this.updateExtensionsCombo();
        this.registerCustomKeyboardActions();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), (Dimension)JBUI.size((int)800, (int)600), this.myProject);
        }
        this.myTextSplit.setDividerLocation(settings.textDividerLocation);
        this.myTreeSplit.setDividerLocation(settings.treeDividerLocation);
        this.updateEditor();
        super.init();
    }

    public static void initTree(JTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        ToolTipManager.sharedInstance().registerComponent(tree);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.internal.psiView.PsiViewerDialog";
    }

    protected String getHelpId() {
        return "reference.psi.viewer";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    private void registerCustomKeyboardActions() {
        int mask = SystemInfo.isMac ? 256 : 512;
        this.registerKeyboardAction(__ -> this.focusEditor(), KeyStroke.getKeyStroke(84, mask));
        this.registerKeyboardAction(__ -> this.focusTree(), KeyStroke.getKeyStroke(83, mask));
        this.registerKeyboardAction(__ -> this.myBlockTree.focusTree(), KeyStroke.getKeyStroke(75, mask));
        this.registerKeyboardAction(__ -> this.focusRefs(), KeyStroke.getKeyStroke(82, mask));
        this.registerKeyboardAction(__ -> {
            if (this.myRefs.isFocusOwner()) {
                this.myBlockTree.focusTree();
            } else if (this.myPsiTree.isFocusOwner()) {
                this.focusRefs();
            } else if (this.myBlockTree.isFocusOwner()) {
                this.focusTree();
            }
        }, KeyStroke.getKeyStroke(9, 0));
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void focusEditor() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), true);
    }

    private void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myPsiTree, true);
    }

    private void focusRefs() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myRefs, true);
        if (this.myRefs.getModel().getSize() > 0 && this.myRefs.getSelectedIndex() == -1) {
            this.myRefs.setSelectedIndex(0);
        }
    }

    private void initMnemonics() {
        this.myTextSeparator.setLabelFor((Component)this.myEditor.getContentComponent());
        this.myPsiTreeSeparator.setLabelFor((Component)this.myPsiTree);
    }

    @Nullable
    private PsiElement getPsiElement() {
        TreePath path = this.myPsiTree.getSelectionPath();
        return path == null ? null : PsiViewerDialog.getPsiElement((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement getPsiElement(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ViewerNodeDescriptor) {
            ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
            Object elementObject = descriptor.getElement();
            return elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
        }
        return null;
    }

    private void updateDialectsCombo(@Nullable String lastUsed) {
        Object source = this.getSource();
        ArrayList items = new ArrayList();
        if (source instanceof LanguageFileType) {
            Language baseLang = ((LanguageFileType)source).getLanguage();
            ((JBTreeTraverser)JBTreeTraverser.from(Language::getDialects).withRoot((Object)baseLang)).preOrderDfsTraversal().addAllTo(items);
            items.subList(1, items.size()).sort(LanguageUtil.LANGUAGE_COMPARATOR);
        }
        this.myDialectComboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(items));
        boolean visible = items.size() > 1;
        this.myDialectLabel.setVisible(visible);
        this.myDialectComboBox.setVisible(visible);
        if (visible && (this.myExternalDocument || lastUsed != null)) {
            VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file);
            int idx = items.indexOf(curLanguage);
            this.myDialectComboBox.setSelectedIndex(Math.max(idx, 0));
        }
    }

    private void updateExtensionsCombo() {
        List<String> extensions;
        Object source = this.getSource();
        if (source instanceof LanguageFileType && (extensions = PsiViewerDialog.getAllExtensions((LanguageFileType)source)).size() > 1) {
            String fileExt;
            ExtensionComparator comp = new ExtensionComparator(extensions.get(0));
            extensions.sort(comp);
            SortedComboBoxModel model = new SortedComboBoxModel((Comparator)comp);
            model.setAll(extensions);
            this.myExtensionComboBox.setModel((ComboBoxModel<String>)model);
            this.myExtensionComboBox.setVisible(true);
            this.myExtensionLabel.setVisible(true);
            VirtualFile file = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            String string = fileExt = file == null ? "" : FileUtilRt.getExtension((String)file.getName());
            if (!fileExt.isEmpty() && extensions.contains(fileExt)) {
                this.myExtensionComboBox.setSelectedItem(fileExt);
                return;
            }
            this.myExtensionComboBox.setSelectedIndex(0);
            return;
        }
        this.myExtensionComboBox.setVisible(false);
        this.myExtensionLabel.setVisible(false);
    }

    private static List<String> getAllExtensions(LanguageFileType fileType) {
        List associations = FileTypeManager.getInstance().getAssociations((FileType)fileType);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(StringUtil.toLowerCase((String)fileType.getDefaultExtension()));
        for (FileNameMatcher matcher : associations) {
            String ext;
            String presentableString = StringUtil.toLowerCase((String)matcher.getPresentableString());
            if (!presentableString.startsWith("*.") || (ext = presentableString.substring(2)).isEmpty() || extensions.contains(ext) || !EXT_PATTERN.matcher(ext).matches()) continue;
            extensions.add(ext);
        }
        return extensions;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    private Object getSource() {
        PsiViewerSourceWrapper wrapper = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            return wrapper.myFileType != null ? wrapper.myFileType : wrapper.myExtension;
        }
        return null;
    }

    protected Action @NotNull [] createActions() {
        AbstractAction copyPsi = new AbstractAction("Cop&y PSI"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                PsiElement element = PsiViewerDialog.this.parseText(PsiViewerDialog.this.myEditor.getDocument().getText());
                PsiViewerDialog.this.setOriginalFiles(element);
                ArrayList<PsiElement> allToParse = new ArrayList<PsiElement>();
                if (element instanceof PsiFile) {
                    allToParse.addAll(((PsiFile)element).getViewProvider().getAllFiles());
                } else if (element != null) {
                    allToParse.add(element);
                }
                StringBuilder data = new StringBuilder();
                for (PsiElement psiElement : allToParse) {
                    data.append(DebugUtil.psiToString((PsiElement)psiElement, (boolean)PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected(), (boolean)true));
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(data.toString()));
            }
        };
        return (Action[])ArrayUtil.mergeArrays((Object[])new Action[]{copyPsi}, (Object[])super.createActions());
    }

    protected void doOKAction() {
        String text = this.myEditor.getDocument().getText();
        this.myEditor.getSelectionModel().removeSelection();
        this.myLastParsedText = text;
        this.myNewDocumentHashCode = this.myLastParsedTextHashCode = text.hashCode();
        PsiElement rootElement = this.parseText(text);
        this.setOriginalFiles(rootElement);
        this.focusTree();
        this.myTreeStructure.setRootPsiElement(rootElement);
        this.myStructureTreeModel.invalidateAsync();
        this.myPsiTree.setRootVisible(true);
        this.myPsiTree.expandRow(0);
        this.myPsiTree.setRootVisible(false);
        this.myBlockTree.reloadTree(rootElement, text);
        this.myStubTree.reloadTree(rootElement, text);
        this.myRefsResolvedCache.clear();
    }

    private PsiElement parseText(@NotNull String text) {
        Object source = this.getSource();
        try {
            if (source instanceof PsiViewerExtension) {
                return ((PsiViewerExtension)source).createElement(this.myProject, text);
            }
            if (source instanceof FileType) {
                Language dialect;
                FileType type = (FileType)source;
                String ext = type.getDefaultExtension();
                if (this.myExtensionComboBox.isVisible() && this.myExtensionComboBox.getSelectedItem() != null) {
                    ext = StringUtil.toLowerCase((String)this.myExtensionComboBox.getSelectedItem().toString());
                }
                if (type instanceof LanguageFileType && (dialect = (Language)this.myDialectComboBox.getSelectedItem()) != null) {
                    return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, dialect, (CharSequence)text);
                }
                return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, type, (CharSequence)text);
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)"Error", (Icon)Messages.getErrorIcon());
        }
        return null;
    }

    private void setOriginalFiles(@Nullable PsiElement root) {
        if (root != null && this.myOriginalPsiFile != null) {
            PsiFile newPsiFile = root.getContainingFile();
            newPsiFile.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)this.myOriginalPsiFile);
            VirtualFile newVirtualFile = newPsiFile.getVirtualFile();
            if (newVirtualFile instanceof LightVirtualFile) {
                ((LightVirtualFile)newVirtualFile).setOriginalFile(this.myOriginalPsiFile.getVirtualFile());
            }
        }
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return slowId -> this.getSlowData(slowId);
        }
        return null;
    }

    @Nullable
    private PsiFile getSlowData(@NonNls String d) {
        if (CommonDataKeys.NAVIGATABLE.is(d)) {
            String fqn = null;
            if (this.myPsiTree.hasFocus()) {
                TreePath path = this.myPsiTree.getSelectionPath();
                if (path != null) {
                    PsiElement element;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                        return null;
                    }
                    ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                    Object elementObject = descriptor.getElement();
                    Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                    if (element != null) {
                        fqn = element.getClass().getName();
                    }
                }
            } else if (this.myRefs.hasFocus()) {
                fqn = this.myRefs.getSelectedValue();
            }
            if (fqn != null) {
                return this.getContainingFileForClass(fqn);
            }
        }
        return null;
    }

    private void updateReferences(@NotNull PsiElement element) {
        DefaultListModel model = (DefaultListModel)this.myRefs.getModel();
        model.clear();
        String progressTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.update.refs", new Object[0]);
        Callable<List> updater = () -> (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.doUpdateReferences(element));
        List psiReferences = PsiViewerDialog.computeSlowOperationsSafeInBgThread(this.myProject, progressTitle, updater);
        for (PsiReference reference : psiReferences) {
            model.addElement(reference.getClass().getName());
        }
    }

    @NotNull
    private List<PsiReference> doUpdateReferences(@NotNull PsiElement element) {
        PsiReferenceService referenceService = PsiReferenceService.getService();
        List psiReferences = referenceService.getReferences(element, PsiReferenceService.Hints.NO_HINTS);
        if (this.myRefsResolvedCache.containsKey(element)) {
            return psiReferences;
        }
        PsiElement[] cache = new PsiElement[psiReferences.size()];
        for (int i = 0; i < psiReferences.size(); ++i) {
            ResolveResult[] results;
            PsiReference reference = (PsiReference)psiReferences.get(i);
            PsiElement resolveResult = reference instanceof PsiPolyVariantReference ? ((results = ((PsiPolyVariantReference)reference).multiResolve(true)).length == 0 ? null : results[0].getElement()) : reference.resolve();
            cache[i] = resolveResult;
        }
        this.myRefsResolvedCache.put(element, cache);
        return psiReferences;
    }

    private void clearSelection() {
        if (this.myHighlighter != null) {
            this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter.dispose();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        PsiViewerSourceWrapper wrapper = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            settings.type = wrapper.getText();
        }
        if (!this.myExternalDocument) {
            settings.text = StringUtil.first((String)this.myEditor.getDocument().getText(), (int)2048, (boolean)true);
        }
        settings.showTreeNodes = this.myShowTreeNodesCheckBox.isSelected();
        settings.showWhiteSpaces = this.myShowWhiteSpacesBox.isSelected();
        Object selectedDialect = this.myDialectComboBox.getSelectedItem();
        settings.dialect = this.myDialectComboBox.isVisible() && selectedDialect != null ? selectedDialect.toString() : "";
        settings.textDividerLocation = this.myTextSplit.getDividerLocation();
        settings.treeDividerLocation = this.myTreeSplit.getDividerLocation();
    }

    public void dispose() {
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        super.dispose();
    }

    @Nullable
    private PsiFile getContainingFileForClass(@NotNull String fqn) {
        Object filename = fqn;
        if (fqn.contains(".")) {
            filename = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        if (((String)filename).contains("$")) {
            filename = ((String)filename).substring(0, ((String)filename).indexOf(36));
        }
        filename = (String)filename + ".java";
        Object[] files = FilenameIndex.getFilesByName((Project)this.myProject, (String)filename, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        return (PsiFile)ArrayUtil.getFirstElement((Object[])files);
    }

    private void updateEditor() {
        LightVirtualFile lightFile;
        Object source = this.getSource();
        String fileName = "Dummy." + (source instanceof FileType ? ((FileType)source).getDefaultExtension() : "txt");
        if (source instanceof PsiViewerExtension) {
            lightFile = new LightVirtualFile(fileName, ((PsiViewerExtension)source).getDefaultFileType(), (CharSequence)"");
        } else if (source instanceof LanguageFileType) {
            lightFile = new LightVirtualFile(fileName, (Language)ObjectUtils.chooseNotNull((Object)((Language)this.myDialectComboBox.getSelectedItem()), (Object)((LanguageFileType)source).getLanguage()), (CharSequence)"");
        } else if (source instanceof FileType) {
            lightFile = new LightVirtualFile(fileName, (FileType)source, (CharSequence)"");
        } else {
            return;
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)lightFile);
        try {
            this.myEditor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    private void selectElement(@NotNull PsiElement element) {
        this.myStructureTreeModel.select((Object)element, (JTree)this.myPsiTree, path -> {});
    }

    private static <T> T computeSlowOperationsSafeInBgThread(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String progressDialogTitle, final @NotNull Callable<T> callable) {
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(project, progressDialogTitle, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                return ReadAction.nonBlocking((Callable)callable).executeSynchronously();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        JBLabel jBLabel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TitledSeparator titledSeparator2;
        JSplitPane jSplitPane;
        JPanel jPanel;
        JSplitPane jSplitPane2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTextSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setDividerLocation(250);
        jSplitPane2.setDividerSize(4);
        jSplitPane2.setOrientation(0);
        jPanel2.add((Component)jSplitPane2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myTextPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setLeftComponent(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setRightComponent(jPanel3);
        this.myTreeSplit = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        jSplitPane.setDividerSize(4);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel4);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = this.myPsiTree;
        jBScrollPane.setViewportView((Component)tree);
        this.myPsiTreeSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("P&SI Tree");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setDoubleBuffered(true);
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 8, 2, 7, 0, null, null, null));
        this.myShowWhiteSpacesBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Show PsiWhiteSpace");
        jCheckBox2.setMnemonic('W');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowTreeNodesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setSelected(true);
        jCheckBox.setText("Show tree nodes");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(10);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtensionLabel = jLabel = new JLabel();
        jLabel.setText("Extension:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel6.add((Component)jLabel, "West");
        JComboBox jComboBox = new JComboBox();
        this.myExtensionComboBox = jComboBox;
        jPanel6.add(jComboBox, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDialectLabel = jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jBLabel, "West");
        JComboBox jComboBox2 = new JComboBox();
        this.myDialectComboBox = jComboBox2;
        jPanel7.add(jComboBox2, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIconTextGap(0);
        jLabel2.setText("Show PSI structure for:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel8.add((Component)jLabel2, "West");
        JComboBox jComboBox3 = new JComboBox();
        this.myFileTypeComboBox = jComboBox3;
        jComboBox3.setMaximumRowCount(30);
        jPanel8.add(jComboBox3, "Center");
        this.myTextSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Text");
        titledSeparator.setToolTipText("Type or paste source code which you want to explore, then click Build PSI Tree");
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class EditorListener
    implements SelectionListener,
    DocumentListener,
    CaretListener {
        private EditorListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (!this.available() || PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            if (rootPsiElement == null) {
                return;
            }
            PsiElement rootElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            int baseOffset = rootPsiElement.getTextRange().getStartOffset();
            int offset = PsiViewerDialog.this.myEditor.getCaretModel().getOffset() + baseOffset;
            String progressDialogTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.get.element.at.offset", new Object[0]);
            Callable<PsiElement> finder = () -> InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)offset);
            PsiElement element = PsiViewerDialog.computeSlowOperationsSafeInBgThread(PsiViewerDialog.this.myProject, progressDialogTitle, finder);
            PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element);
            PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element);
            PsiViewerDialog.this.selectElement(element);
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            Callable<PsiElement> finder;
            if (!this.available() || !PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiElement rootElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
            if (rootElement == null) {
                return;
            }
            SelectionModel selection = PsiViewerDialog.this.myEditor.getSelectionModel();
            TextRange textRange = rootElement.getTextRange();
            int baseOffset = textRange != null ? textRange.getStartOffset() : 0;
            int start = selection.getSelectionStart() + baseOffset;
            int end = selection.getSelectionEnd() + baseOffset - 1;
            String progressDialogTitle = DevPsiViewerBundle.message("psi.viewer.progress.dialog.get.common.parent", new Object[0]);
            PsiElement element = PsiViewerDialog.computeSlowOperationsSafeInBgThread(PsiViewerDialog.this.myProject, progressDialogTitle, finder = () -> EditorListener.findCommonParent(InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)start), InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)rootElement.getContainingFile(), (int)end)));
            if (element != null) {
                if (PsiViewerDialog.this.myEditor.getContentComponent().hasFocus()) {
                    PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element);
                    PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element);
                }
                PsiViewerDialog.this.selectElement(element);
            }
        }

        @Nullable
        private static PsiElement findCommonParent(PsiElement start, PsiElement end) {
            PsiElement parent;
            if (end == null || start == end) {
                return start;
            }
            TextRange endRange = end.getTextRange();
            for (parent = start.getContext(); parent != null && !parent.getTextRange().contains(endRange); parent = parent.getContext()) {
            }
            return parent;
        }

        private boolean available() {
            return PsiViewerDialog.this.myLastParsedTextHashCode == PsiViewerDialog.this.myNewDocumentHashCode && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus();
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            PsiViewerDialog.this.myNewDocumentHashCode = event.getDocument().getText().hashCode();
        }
    }

    private class MyPsiTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        MyPsiTreeSelectionListener() {
            this.myAttributes.setEffectColor(BOX_COLOR);
            this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (!PsiViewerDialog.this.myEditor.getDocument().getText().equals(PsiViewerDialog.this.myLastParsedText) || PsiViewerDialog.this.myBlockTree.isFocusOwner()) {
                return;
            }
            TreePath path = PsiViewerDialog.this.myPsiTree.getSelectionPath();
            PsiViewerDialog.this.clearSelection();
            if (path != null) {
                PsiElement element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                    return;
                }
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                Object elementObject = descriptor.getElement();
                Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                if (element != null) {
                    int textLength;
                    TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                    int start = rangeInHostFile.getStartOffset();
                    int end = rangeInHostFile.getEndOffset();
                    PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
                    if (rootPsiElement != null) {
                        int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                        start -= baseOffset;
                        end -= baseOffset;
                    }
                    if (end <= (textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength())) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                            PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        }
                    }
                    if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                        PsiViewerDialog.this.myBlockTree.selectNodeFromPsi(element);
                        PsiViewerDialog.this.myStubTree.selectNodeFromPsi(element);
                    }
                    PsiViewerDialog.this.updateReferences(element);
                }
            }
        }
    }

    private class GoToListener
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private RangeHighlighter myListenerHighlighter;

        private GoToListener() {
        }

        private void navigate() {
            String fqn = PsiViewerDialog.this.myRefs.getSelectedValue();
            PsiFile file = PsiViewerDialog.this.getContainingFileForClass(fqn);
            if (file != null) {
                file.navigate(true);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.navigate();
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.navigate();
            }
        }

        @Override
        public void valueChanged(@NotNull ListSelectionEvent e) {
            PsiReference[] references;
            this.clearSelection();
            PsiViewerDialog.this.updateDialectsCombo(null);
            PsiViewerDialog.this.updateExtensionsCombo();
            int ind = PsiViewerDialog.this.myRefs.getSelectedIndex();
            PsiElement element = PsiViewerDialog.this.getPsiElement();
            if (ind > -1 && element != null && ind < (references = element.getReferences()).length) {
                TextRange textRange = references[ind].getRangeInElement();
                TextRange range = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                int start = range.getStartOffset();
                PsiElement rootPsiElement = PsiViewerDialog.this.myTreeStructure.getRootPsiElement();
                if (rootPsiElement != null) {
                    int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                    start -= baseOffset;
                }
                int end = (start += textRange.getStartOffset()) + textRange.getLength();
                TextAttributes highlightReferenceTextRange = new TextAttributes(null, null, (Color)JBColor.namedColor((String)"PsiViewer.referenceHighlightColor", (int)11059235), EffectType.BOLD_DOTTED_LINE, 0);
                this.myListenerHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, highlightReferenceTextRange, HighlighterTargetArea.EXACT_RANGE);
            }
        }

        public void clearSelection() {
            if (this.myListenerHighlighter != null && ArrayUtil.contains((Object)this.myListenerHighlighter, (Object[])PsiViewerDialog.this.myEditor.getMarkupModel().getAllHighlighters())) {
                this.myListenerHighlighter.dispose();
                this.myListenerHighlighter = null;
            }
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
        }
    }

    private static final class AutoExpandFocusListener
    extends FocusAdapter {
        private final JComboBox<?> myComboBox;
        private final Component myParent;

        private AutoExpandFocusListener(JComboBox<?> comboBox) {
            this.myComboBox = comboBox;
            this.myParent = UIUtil.findUltimateParent(this.myComboBox);
        }

        @Override
        public void focusGained(@NotNull FocusEvent e) {
            Component from = e.getOppositeComponent();
            if (!e.isTemporary() && from != null && !this.myComboBox.isPopupVisible() && AutoExpandFocusListener.isUnder(from, this.myParent)) {
                this.myComboBox.setPopupVisible(true);
            }
        }

        private static boolean isUnder(@NotNull Component component, Component parent) {
            while (component != null) {
                if (component == parent) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }
    }

    private static class ExtensionComparator
    implements Comparator<String> {
        private final String myOnTop;

        ExtensionComparator(String onTop) {
            this.myOnTop = onTop;
        }

        @Override
        public int compare(@NotNull String o1, @NotNull String o2) {
            if (o1.equals(this.myOnTop)) {
                return -1;
            }
            if (o2.equals(this.myOnTop)) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

