/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.proto;

import com.android.tools.idea.protobuf.AbstractParser;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.CodedOutputStream;
import com.android.tools.idea.protobuf.Descriptors;
import com.android.tools.idea.protobuf.ExtensionRegistryLite;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.protobuf.Internal;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.protobuf.Message;
import com.android.tools.idea.protobuf.MessageLite;
import com.android.tools.idea.protobuf.Parser;
import com.android.tools.idea.protobuf.UnknownFieldSet;
import com.google.services.firebase.insights.proto.ErrorType;
import com.google.services.firebase.insights.proto.FirebaseCrashlyticsProto;
import com.google.services.firebase.insights.proto.IssueFilterOrBuilder;
import com.google.services.firebase.insights.proto.IssueSignals;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IssueFilter
extends GeneratedMessageV3
implements IssueFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile Object id_;
    public static final int ERROR_TYPES_FIELD_NUMBER = 2;
    private List<Integer> errorTypes_;
    private static final Internal.ListAdapter.Converter<Integer, ErrorType> errorTypes_converter_ = new Internal.ListAdapter.Converter<Integer, ErrorType>(){

        public ErrorType convert(Integer from) {
            ErrorType result = ErrorType.valueOf(from);
            return result == null ? ErrorType.UNRECOGNIZED : result;
        }
    };
    private int errorTypesMemoizedSerializedSize;
    public static final int SIGNALS_FIELD_NUMBER = 3;
    private List<Integer> signals_;
    private static final Internal.ListAdapter.Converter<Integer, IssueSignals.Signal> signals_converter_ = new Internal.ListAdapter.Converter<Integer, IssueSignals.Signal>(){

        public IssueSignals.Signal convert(Integer from) {
            IssueSignals.Signal result = IssueSignals.Signal.valueOf(from);
            return result == null ? IssueSignals.Signal.UNRECOGNIZED : result;
        }
    };
    private int signalsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final IssueFilter DEFAULT_INSTANCE = new IssueFilter();
    private static final Parser<IssueFilter> PARSER = new AbstractParser<IssueFilter>(){

        public IssueFilter parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new IssueFilter(input, extensionRegistry);
        }
    };

    private IssueFilter(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private IssueFilter() {
        this.id_ = "";
        this.errorTypes_ = Collections.emptyList();
        this.signals_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new IssueFilter();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private IssueFilter(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block14: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block14;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.id_ = s;
                        continue block14;
                    }
                    case 16: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.errorTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 1;
                        }
                        this.errorTypes_.add(rawValue);
                        continue block14;
                    }
                    case 18: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 1) == 0) {
                                this.errorTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 1;
                            }
                            this.errorTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block14;
                    }
                    case 24: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.signals_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 2;
                        }
                        this.signals_.add(rawValue);
                        continue block14;
                    }
                    case 26: {
                        int rawValue;
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 2) == 0) {
                                this.signals_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 2;
                            }
                            this.signals_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block14;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.errorTypes_ = Collections.unmodifiableList(this.errorTypes_);
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.signals_ = Collections.unmodifiableList(this.signals_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(IssueFilter.class, Builder.class);
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<ErrorType> getErrorTypesList() {
        return new Internal.ListAdapter(this.errorTypes_, errorTypes_converter_);
    }

    @Override
    public int getErrorTypesCount() {
        return this.errorTypes_.size();
    }

    @Override
    public ErrorType getErrorTypes(int index) {
        return (ErrorType)((Object)errorTypes_converter_.convert((Object)this.errorTypes_.get(index)));
    }

    @Override
    public List<Integer> getErrorTypesValueList() {
        return this.errorTypes_;
    }

    @Override
    public int getErrorTypesValue(int index) {
        return this.errorTypes_.get(index);
    }

    @Override
    public List<IssueSignals.Signal> getSignalsList() {
        return new Internal.ListAdapter(this.signals_, signals_converter_);
    }

    @Override
    public int getSignalsCount() {
        return this.signals_.size();
    }

    @Override
    public IssueSignals.Signal getSignals(int index) {
        return (IssueSignals.Signal)((Object)signals_converter_.convert((Object)this.signals_.get(index)));
    }

    @Override
    public List<Integer> getSignalsValueList() {
        return this.signals_;
    }

    @Override
    public int getSignalsValue(int index) {
        return this.signals_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.id_);
        }
        if (this.getErrorTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.errorTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.errorTypes_.size(); ++i) {
            output.writeEnumNoTag(this.errorTypes_.get(i).intValue());
        }
        if (this.getSignalsList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.signalsMemoizedSerializedSize);
        }
        for (i = 0; i < this.signals_.size(); ++i) {
            output.writeEnumNoTag(this.signals_.get(i).intValue());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.id_);
        }
        int dataSize = 0;
        for (i = 0; i < this.errorTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.errorTypes_.get(i));
        }
        size += dataSize;
        if (!this.getErrorTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.errorTypesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.signals_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.signals_.get(i));
        }
        size += dataSize;
        if (!this.getSignalsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.signalsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IssueFilter)) {
            return super.equals(obj);
        }
        IssueFilter other = (IssueFilter)obj;
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (!this.errorTypes_.equals(other.errorTypes_)) {
            return false;
        }
        if (!this.signals_.equals(other.signals_)) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + IssueFilter.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getId().hashCode();
        if (this.getErrorTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.errorTypes_.hashCode();
        }
        if (this.getSignalsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.signals_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static IssueFilter parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(InputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static IssueFilter parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IssueFilter parseDelimitedFrom(InputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static IssueFilter parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IssueFilter parseFrom(CodedInputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static IssueFilter parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return IssueFilter.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(IssueFilter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static IssueFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<IssueFilter> parser() {
        return PARSER;
    }

    public Parser<IssueFilter> getParserForType() {
        return PARSER;
    }

    public IssueFilter getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements IssueFilterOrBuilder {
        private int bitField0_;
        private Object id_ = "";
        private List<Integer> errorTypes_ = Collections.emptyList();
        private List<Integer> signals_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(IssueFilter.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.id_ = "";
            this.errorTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.signals_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
        }

        public IssueFilter getDefaultInstanceForType() {
            return IssueFilter.getDefaultInstance();
        }

        public IssueFilter build() {
            IssueFilter result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public IssueFilter buildPartial() {
            IssueFilter result = new IssueFilter(this);
            int from_bitField0_ = this.bitField0_;
            result.id_ = this.id_;
            if ((this.bitField0_ & 1) != 0) {
                this.errorTypes_ = Collections.unmodifiableList(this.errorTypes_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.errorTypes_ = this.errorTypes_;
            if ((this.bitField0_ & 2) != 0) {
                this.signals_ = Collections.unmodifiableList(this.signals_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.signals_ = this.signals_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof IssueFilter) {
                return this.mergeFrom((IssueFilter)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(IssueFilter other) {
            if (other == IssueFilter.getDefaultInstance()) {
                return this;
            }
            if (!other.getId().isEmpty()) {
                this.id_ = other.id_;
                this.onChanged();
            }
            if (!other.errorTypes_.isEmpty()) {
                if (this.errorTypes_.isEmpty()) {
                    this.errorTypes_ = other.errorTypes_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureErrorTypesIsMutable();
                    this.errorTypes_.addAll(other.errorTypes_);
                }
                this.onChanged();
            }
            if (!other.signals_.isEmpty()) {
                if (this.signals_.isEmpty()) {
                    this.signals_ = other.signals_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureSignalsIsMutable();
                    this.signals_.addAll(other.signals_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            IssueFilter parsedMessage = null;
            try {
                parsedMessage = (IssueFilter)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (IssueFilter)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = IssueFilter.getDefaultInstance().getId();
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            IssueFilter.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.onChanged();
            return this;
        }

        private void ensureErrorTypesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.errorTypes_ = new ArrayList<Integer>(this.errorTypes_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<ErrorType> getErrorTypesList() {
            return new Internal.ListAdapter(this.errorTypes_, errorTypes_converter_);
        }

        @Override
        public int getErrorTypesCount() {
            return this.errorTypes_.size();
        }

        @Override
        public ErrorType getErrorTypes(int index) {
            return (ErrorType)((Object)errorTypes_converter_.convert((Object)this.errorTypes_.get(index)));
        }

        public Builder setErrorTypes(int index, ErrorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addErrorTypes(ErrorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllErrorTypes(Iterable<? extends ErrorType> values) {
            this.ensureErrorTypesIsMutable();
            for (ErrorType errorType : values) {
                this.errorTypes_.add(errorType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearErrorTypes() {
            this.errorTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getErrorTypesValueList() {
            return Collections.unmodifiableList(this.errorTypes_);
        }

        @Override
        public int getErrorTypesValue(int index) {
            return this.errorTypes_.get(index);
        }

        public Builder setErrorTypesValue(int index, int value) {
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addErrorTypesValue(int value) {
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllErrorTypesValue(Iterable<Integer> values) {
            this.ensureErrorTypesIsMutable();
            for (int value : values) {
                this.errorTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureSignalsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.signals_ = new ArrayList<Integer>(this.signals_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<IssueSignals.Signal> getSignalsList() {
            return new Internal.ListAdapter(this.signals_, signals_converter_);
        }

        @Override
        public int getSignalsCount() {
            return this.signals_.size();
        }

        @Override
        public IssueSignals.Signal getSignals(int index) {
            return (IssueSignals.Signal)((Object)signals_converter_.convert((Object)this.signals_.get(index)));
        }

        public Builder setSignals(int index, IssueSignals.Signal value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSignalsIsMutable();
            this.signals_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSignals(IssueSignals.Signal value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSignalsIsMutable();
            this.signals_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSignals(Iterable<? extends IssueSignals.Signal> values) {
            this.ensureSignalsIsMutable();
            for (IssueSignals.Signal signal : values) {
                this.signals_.add(signal.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSignals() {
            this.signals_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSignalsValueList() {
            return Collections.unmodifiableList(this.signals_);
        }

        @Override
        public int getSignalsValue(int index) {
            return this.signals_.get(index);
        }

        public Builder setSignalsValue(int index, int value) {
            this.ensureSignalsIsMutable();
            this.signals_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSignalsValue(int value) {
            this.ensureSignalsIsMutable();
            this.signals_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSignalsValue(Iterable<Integer> values) {
            this.ensureSignalsIsMutable();
            for (int value : values) {
                this.signals_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

