/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.lang.java6.CachePoolImpl;
import com.intellij.util.lang.java6.ClassLoadingLocks;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    static final String CLASS_EXTENSION = ".class";
    private static final ThreadLocal<Boolean> ourSkipFindingResource;
    private static final boolean ourClassPathIndexEnabled;
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;

    private static boolean isUrlNeedsProtectionDomain(@NotNull URL url) {
        String name = PathUtilRt.getFileName((String)url.getPath());
        return name.endsWith(".jar") && (name.startsWith("bcprov-") || name.startsWith("bcpkix-"));
    }

    void appendToClassPathForInstrumentation(@NotNull String jar) {
        try {
            URL url = new File(jar).toURI().toURL();
            this.getClassPath().addURL(url);
            this.myURLs.add(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @NotNull
    protected ClassPath getClassPath() {
        return this.myClassPath;
    }

    @NotNull
    public final long[] getLoadingStats() {
        return new long[]{ClassPath.getTotalTime(), ClassPath.getTotalRequests()};
    }

    @NotNull
    public static UrlClassLoader create(List<URL> urls) {
        return UrlClassLoader.build().urls(urls).useCache().allowLock().get();
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        this(UrlClassLoader.build().urlsFromAppClassLoader(parent).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories().allowBootstrapResources(Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"))).useLazyClassloadingCaches(Boolean.parseBoolean(System.getProperty("idea.lazy.classloading.caches", "false"))).autoAssignUrlsWithProtectionDomain());
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(this, f.get(parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        super(builder.myParent);
        this.myURLs = builder.myURLs;
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassLoadingLocks = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new ClassLoadingLocks() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        Set<URL> urlsWithProtectionDomain = builder.myURLsWithProtectionDomain;
        if (urlsWithProtectionDomain == null) {
            urlsWithProtectionDomain = Collections.emptySet();
        }
        return new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition, true, builder.myLazyClassloadingCaches, urlsWithProtectionDomain);
    }

    @Deprecated
    public final void addURL(@NotNull URL url) {
        this.getClassPath().addURL(url);
        this.myURLs.add(url);
    }

    @Override
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz = this._findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Nullable
    protected final Class<?> _findClass(@NotNull String name) {
        Resource resource = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION);
        if (resource == null) {
            return null;
        }
        try {
            return this.defineClass(name, resource);
        }
        catch (IOException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error((Throwable)e);
            return null;
        }
    }

    private Class<?> defineClass(@NotNull String name, @NotNull Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res.getValue(Resource.Attribute.SPEC_TITLE), res.getValue(Resource.Attribute.SPEC_VERSION), res.getValue(Resource.Attribute.SPEC_VENDOR), res.getValue(Resource.Attribute.IMPL_TITLE), res.getValue(Resource.Attribute.IMPL_VERSION), res.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        ProtectionDomain protectionDomain = res.getProtectionDomain();
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        return this._defineClass(name, b);
    }

    protected Class<?> _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    protected Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public URL findResource(String name) {
        if (ourSkipFindingResource.get() != null) {
            return null;
        }
        Resource res = this.findResourceImpl(name);
        return res == null ? null : res.getURL();
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath((String)name, (char)'/', (boolean)false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            ourSkipFindingResource.set(Boolean.TRUE);
            try {
                InputStream stream = super.getResourceAsStream(name);
                if (stream != null) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
            }
            finally {
                ourSkipFindingResource.set(null);
            }
        }
        try {
            Resource res = this.findResourceImpl(name);
            return res == null ? null : res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className) {
        return this.myClassLoadingLocks == null ? this : this.myClassLoadingLocks.getOrCreateLock(className);
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    static {
        boolean capable;
        ourSkipFindingResource = new ThreadLocal();
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        boolean isAtLeastJava7 = !System.getProperty("java.runtime.version", "unknown").startsWith("1.6.");
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.ENGLISH).contains("ibm");
        boolean bl = capable = isAtLeastJava7 && !ibmJvm;
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
    }

    public static final class Builder {
        private List<URL> myURLs = Collections.emptyList();
        private Set<URL> myURLsWithProtectionDomain;
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex;
        private boolean myAcceptUnescaped;
        private boolean myAllowBootstrapResources;
        private boolean myLazyClassloadingCaches;
        @Nullable
        private CachePoolImpl myCachePool;
        @Nullable
        private CachingCondition myCachingCondition;

        Builder() {
        }

        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        @NotNull
        public Builder urls(URL ... urls) {
            this.myURLs = Arrays.asList(urls);
            return this;
        }

        private Builder urlsFromAppClassLoader(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return this.urls(((URLClassLoader)classLoader).getURLs());
            }
            String[] parts = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
            this.myURLs = new ArrayList<URL>(parts.length);
            for (String s : parts) {
                try {
                    this.myURLs.add(new File(s).toURI().toURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }

        @NotNull
        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            return this;
        }

        @NotNull
        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        @NotNull
        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = ourClassPathIndexEnabled;
            return this;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull CachingCondition condition) {
            this.myUseCache = true;
            this.myCachePool = (CachePoolImpl)pool;
            this.myCachingCondition = condition;
            return this;
        }

        @NotNull
        public Builder allowUnescaped() {
            this.myAcceptUnescaped = true;
            return this;
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.myAllowBootstrapResources = allowBootstrapResources;
            return this;
        }

        @NotNull
        public Builder useLazyClassloadingCaches(boolean pleaseBeLazy) {
            this.myLazyClassloadingCaches = pleaseBeLazy;
            return this;
        }

        @NotNull
        public Builder autoAssignUrlsWithProtectionDomain() {
            HashSet<URL> result = new HashSet<URL>();
            for (URL url : this.myURLs) {
                if (!UrlClassLoader.isUrlNeedsProtectionDomain(url)) continue;
                result.add(url);
            }
            this.myURLsWithProtectionDomain = result;
            return this;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this);
        }
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static interface CachePool {
    }
}

