/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.JarLoader;
import com.intellij.util.lang.java6.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SecureJarLoader
extends JarLoader {
    @Nullable
    private ProtectionDomain myProtectionDomain;
    private final Object myProtectionDomainMonitor = new Object();

    SecureJarLoader(@NotNull URL url, @NotNull String filePath, @NotNull ClassPath configuration) throws IOException {
        super(url, filePath, configuration);
    }

    @Override
    @NotNull
    protected Resource instantiateResource(@NotNull URL url, @NotNull ZipEntry entry) throws IOException {
        return new MySecureResource(url, (JarEntry)entry);
    }

    @Override
    @NotNull
    protected ZipFile createZipFile(@NotNull String path) throws IOException {
        return new JarFile(path);
    }

    private final class MySecureResource
    extends JarLoader.MyResource {
        MySecureResource(@NotNull URL url, JarEntry entry) throws IOException {
            super(url, entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            JarFile file = (JarFile)SecureJarLoader.this.getZipFile();
            try {
                Object object;
                InputStream stream = file.getInputStream(this.myEntry);
                try {
                    byte[] result = FileUtilRt.loadBytes((InputStream)stream, (int)((int)this.myEntry.getSize()));
                    object = SecureJarLoader.this.myProtectionDomainMonitor;
                    synchronized (object) {
                        if (SecureJarLoader.this.myProtectionDomain == null) {
                            JarEntry jarEntry = file.getJarEntry(this.myEntry.getName());
                            CodeSource codeSource = new CodeSource(this.myUrl, jarEntry.getCodeSigners());
                            SecureJarLoader.this.myProtectionDomain = new ProtectionDomain(codeSource, new Permissions());
                        }
                    }
                    object = result;
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return object;
            }
            finally {
                SecureJarLoader.this.releaseZipFile(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ProtectionDomain getProtectionDomain() {
            Object object = SecureJarLoader.this.myProtectionDomainMonitor;
            synchronized (object) {
                return SecureJarLoader.this.myProtectionDomain;
            }
        }
    }
}

