/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.UrlClassLoader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;

final class CachePoolImpl
implements UrlClassLoader.CachePool {
    private final Map<URL, ClasspathCache.LoaderData> myLoaderIndexCache = new ConcurrentHashMap<URL, ClasspathCache.LoaderData>();
    private final Map<URL, Attributes> myManifestData = new ConcurrentHashMap<URL, Attributes>();

    CachePoolImpl() {
    }

    void cacheData(@NotNull URL url, @NotNull ClasspathCache.LoaderData data) {
        this.myLoaderIndexCache.put(url, data);
    }

    ClasspathCache.LoaderData getCachedData(@NotNull URL url) {
        return this.myLoaderIndexCache.get(url);
    }

    Attributes getManifestData(@NotNull URL url) {
        return this.myManifestData.get(url);
    }

    void cacheManifestData(@NotNull URL url, @NotNull Attributes manifestAttributes) {
        this.myManifestData.put(url, manifestAttributes);
    }
}

