/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitRunConfigurationImporter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfig", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "TestKind", "intellij.junit"})
public final class JUnitRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = Logger.getInstance(JUnitRunConfigurationImporter.class);

    public boolean canImport(@NotNull String typeName) {
        return Intrinsics.areEqual((Object)"junit", (Object)typeName);
    }

    /*
     * WARNING - void declaration
     */
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfig, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Object object;
        Object v0;
        JUnitConfiguration.Data data;
        block10: {
            if (!(runConfig instanceof JUnitConfiguration)) {
                throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfig.getClass());
            }
            data = ((JUnitConfiguration)runConfig).getPersistentData();
            Iterable $this$firstOrNull$iv = cfg.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void $this$mapTo$iv$iv;
                String it = (String)element$iv;
                boolean bl = false;
                TestKind[] $this$map$iv = TestKind.values();
                boolean $i$f$map = false;
                TestKind[] testKindArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void testKind;
                    void item$iv$iv;
                    void var21_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(testKind.getDslName());
                }
                if (!(((List)destination$iv$iv).contains(it) && cfg.get(it) != null)) continue;
                v0 = element$iv;
                break block10;
            }
            v0 = null;
        }
        String testKindName = v0;
        if (testKindName != null) {
            ObjectUtils.consumeIfCast(cfg.get(testKindName), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$2((Function1)new Function1<String, Unit>(data, testKindName){
                final /* synthetic */ JUnitConfiguration.Data $data;
                final /* synthetic */ String $testKindName;
                {
                    this.$data = $data;
                    this.$testKindName = $testKindName;
                    super(1);
                }

                public final void invoke(String testKindValue) {
                    JUnitConfiguration.Data data = this.$data;
                    TestKind testKind = TestKind.Companion.byDslName(this.$testKindName);
                    data.TEST_OBJECT = switch (testKind == null ? -1 : process.WhenMappings.$EnumSwitchMapping$0[testKind.ordinal()]) {
                        case 1 -> {
                            String var2_2 = "package";
                            JUnitConfiguration.Data var3_8 = this.$data;
                            String var4_14 = var2_2;
                            JUnitConfiguration.Data var8_20 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$1 = false;
                            var3_8.PACKAGE_NAME = testKindValue;
                            data = var8_20;
                            yield var2_2;
                        }
                        case 2 -> {
                            String var2_3 = "directory";
                            JUnitConfiguration.Data var3_9 = this.$data;
                            String it = var2_3;
                            JUnitConfiguration.Data var8_21 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$2 = false;
                            var3_9.setDirName(testKindValue);
                            data = var8_21;
                            yield var2_3;
                        }
                        case 3 -> {
                            String var2_4 = "pattern";
                            JUnitConfiguration.Data var3_10 = this.$data;
                            String it = var2_4;
                            JUnitConfiguration.Data var8_22 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$3 = false;
                            char[] var6_32 = new char[]{','};
                            var3_10.setPatterns(new LinkedHashSet<String>(StringsKt.split$default((CharSequence)testKindValue, (char[])var6_32, (boolean)false, (int)0, (int)6, null)));
                            data = var8_22;
                            yield var2_4;
                        }
                        case 4 -> {
                            String var2_5 = "class";
                            JUnitConfiguration.Data var3_11 = this.$data;
                            String it = var2_5;
                            JUnitConfiguration.Data var8_23 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$4 = false;
                            var3_11.MAIN_CLASS_NAME = testKindValue;
                            data = var8_23;
                            yield var2_5;
                        }
                        case 5 -> {
                            String var2_6 = "method";
                            JUnitConfiguration.Data var3_12 = this.$data;
                            String it = var2_6;
                            JUnitConfiguration.Data var8_24 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$5 = false;
                            String className = StringsKt.substringBefore$default((String)testKindValue, (char)'#', null, (int)2, null);
                            String methodName = StringsKt.substringAfter$default((String)testKindValue, (char)'#', null, (int)2, null);
                            var3_12.MAIN_CLASS_NAME = className;
                            var3_12.METHOD_NAME = methodName;
                            data = var8_24;
                            yield var2_6;
                        }
                        case 6 -> {
                            String var2_7 = "category";
                            JUnitConfiguration.Data var3_13 = this.$data;
                            String it = var2_7;
                            JUnitConfiguration.Data var8_25 = data;
                            boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$6 = false;
                            var3_13.setCategoryName(testKindValue);
                            data = var8_25;
                            yield var2_7;
                        }
                        case -1 -> this.$data.TEST_OBJECT;
                        default -> throw new NoWhenBranchMatchedException();
                    };
                }
            }, arg_0));
        }
        Object repeatValue = cfg.get("repeat");
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfig;
        Object obj = repeatValue;
        if (Intrinsics.areEqual(obj, (Object)"untilStop")) {
            object = "Until Stopped";
        } else if (Intrinsics.areEqual(obj, (Object)"untilFailure")) {
            object = "Until Failure";
        } else if (obj instanceof Number) {
            Object element$iv;
            String string = "N Times";
            element$iv = string;
            JUnitConfiguration jUnitConfiguration2 = jUnitConfiguration;
            boolean bl = false;
            ((JUnitConfiguration)runConfig).setRepeatCount(((Number)repeatValue).intValue());
            jUnitConfiguration = jUnitConfiguration2;
            object = string;
        } else {
            object = ((JUnitConfiguration)runConfig).getRepeatMode();
        }
        jUnitConfiguration.setRepeatMode((String)object);
        ObjectUtils.consumeIfCast(cfg.get("vmParameters"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$4((Function1)new Function1<String, Unit>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(String it) {
                ((JUnitConfiguration)this.$runConfig).setVMParameters(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$5((Function1)new Function1<String, Unit>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(String it) {
                ((JUnitConfiguration)this.$runConfig).setWorkingDirectory(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast(cfg.get("passParentEnvs"), Boolean.TYPE, arg_0 -> JUnitRunConfigurationImporter.process$lambda$6((Function1)new Function1<Boolean, Unit>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(Boolean it) {
                ((JUnitConfiguration)this.$runConfig).setPassParentEnvs(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$7((Function1)new Function1<Map<?, ?>, Unit>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(Map<?, ?> it) {
                JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)this.$runConfig;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                jUnitConfiguration.setEnvs(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$8((Function1)new Function1<String, Unit>(modelsProvider, runConfig){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$modelsProvider = $modelsProvider;
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(String it) {
                Module module = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module != null) {
                    ((JUnitConfiguration)this.$runConfig).setModule(module);
                }
            }
        }, arg_0));
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$9((Function1)new Function1<String, Unit>(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;
            {
                this.$runConfig = $runConfig;
                super(1);
            }

            public final void invoke(String it) {
                try {
                    ((JUnitConfiguration)this.$runConfig).setShortenCommandLine(ShortenCommandLine.valueOf((String)it));
                }
                catch (IllegalArgumentException e) {
                    JUnitRunConfigurationImporter.Companion.getLOG().warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
                }
            }
        }, arg_0));
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class)).getConfigurationFactories()[0];
    }

    private static final void process$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "", "dslName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDslName", "()Ljava/lang/String;", "PACKAGE_NAME", "DIRECTORY", "PATTERN", "CLASS", "METHOD", "CATEGORY", "Companion", "intellij.junit"})
    private static final class TestKind
    extends Enum<TestKind> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String dslName;
        public static final /* enum */ TestKind PACKAGE_NAME;
        public static final /* enum */ TestKind DIRECTORY;
        public static final /* enum */ TestKind PATTERN;
        public static final /* enum */ TestKind CLASS;
        public static final /* enum */ TestKind METHOD;
        public static final /* enum */ TestKind CATEGORY;
        private static final /* synthetic */ TestKind[] $VALUES;

        private TestKind(String dslName) {
            this.dslName = dslName;
        }

        @NotNull
        public final String getDslName() {
            return this.dslName;
        }

        public static TestKind[] values() {
            return (TestKind[])$VALUES.clone();
        }

        public static TestKind valueOf(String value) {
            return Enum.valueOf(TestKind.class, value);
        }

        static {
            PACKAGE_NAME = new TestKind("packageName");
            DIRECTORY = new TestKind("directory");
            PATTERN = new TestKind("pattern");
            CLASS = new TestKind("class");
            METHOD = new TestKind("method");
            CATEGORY = new TestKind("category");
            $VALUES = testKindArray = new TestKind[]{TestKind.PACKAGE_NAME, TestKind.DIRECTORY, TestKind.PATTERN, TestKind.CLASS, TestKind.METHOD, TestKind.CATEGORY};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind$Companion;", "", "()V", "byDslName", "Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "dslName", "", "intellij.junit"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final TestKind byDslName(@NotNull String dslName) {
                TestKind testKind;
                block1: {
                    TestKind[] testKindArray = TestKind.values();
                    int n = testKindArray.length;
                    for (int i = 0; i < n; ++i) {
                        TestKind testKind2;
                        TestKind it = testKind2 = testKindArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDslName(), (Object)dslName)) continue;
                        testKind = testKind2;
                        break block1;
                    }
                    testKind = null;
                }
                return testKind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.junit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

