/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class DisabledConditionUtil {
    private static final String[] DISABLED_ANNO = new String[]{"org.junit.jupiter.api.Disabled"};
    private static final String[] DISABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.DisabledOnJre", "org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.DisabledIfSystemProperty", "org.junit.jupiter.api.condition.DisabledOnOs"};
    private static final String[] SCRIPT_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.DisabledIf", "org.junit.jupiter.api.condition.EnabledIf"};
    private static final String[] ENABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.EnabledOnJre", "org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.EnabledIfSystemProperty", "org.junit.jupiter.api.condition.EnabledOnOs"};

    @Nullable
    public static String getDisabledConditionValue(JUnitConfiguration configuration) {
        PsiClass psiClass;
        JUnitConfiguration.Data data = configuration.getPersistentData();
        if (data == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(configuration);
        boolean isMethodConfiguration = "method".equals(data.TEST_OBJECT);
        boolean isClassConfiguration = "class".equals(data.TEST_OBJECT);
        PsiClass psiClass2 = psiClass = isMethodConfiguration || isClassConfiguration ? JavaExecutionUtil.findMainClass((Project)configuration.getProject(), (String)data.getMainClassName(), (GlobalSearchScope)globalSearchScope) : null;
        if (psiClass == null) {
            return null;
        }
        String disabledCondition = DisabledConditionUtil.getDisabledCondition((PsiElement)psiClass);
        if (disabledCondition != null) {
            return disabledCondition;
        }
        String methodName = data.getMethodName();
        if (methodName != null) {
            JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(psiClass);
            String currentSignature = data.getMethodNameWithSignature();
            for (PsiMethod t : psiClass.findMethodsByName(methodName, true)) {
                if (!filter.value(t) || !Objects.equals(currentSignature, JUnitConfiguration.Data.getMethodPresentation(t))) continue;
                return DisabledConditionUtil.getDisabledCondition((PsiElement)t);
            }
        }
        return null;
    }

    private static boolean isDisabledCondition(String[] anno, PsiElement psiElement) {
        ArrayList<Object> listOwners = new ArrayList<Object>();
        if (psiElement instanceof PsiMethod) {
            listOwners.add((PsiMethod)psiElement);
        }
        if (psiElement instanceof PsiClass) {
            listOwners.add((PsiClass)psiElement);
        }
        return ContainerUtil.exists((Object[])anno, an -> MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)listOwners.get(0)), Collections.singleton(an)));
    }

    public static String getDisabledCondition(PsiElement element) {
        if (DisabledConditionUtil.isDisabledCondition(DISABLED_COND_ANNO, element)) {
            return "org.junit.*Disabled*Condition";
        }
        if (DisabledConditionUtil.isDisabledCondition(ENABLED_COND_ANNO, element)) {
            return "org.junit.*Enabled*Condition";
        }
        if (DisabledConditionUtil.isDisabledCondition(SCRIPT_COND_ANNO, element)) {
            return "org.junit.*DisabledIfCondition";
        }
        if (DisabledConditionUtil.isDisabledCondition(DISABLED_ANNO, element)) {
            return "org.junit.*DisabledCondition";
        }
        return null;
    }
}

