/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ClassesWithAnnotatedMembersSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationUtil {
    public static boolean findAllTestClasses(final @NotNull TestClassFilter testClassFilter, @Nullable Module module, final @NotNull Set<? super PsiClass> found) {
        PsiMethod[] suiteMethods;
        PsiManager manager = testClassFilter.getPsiManager();
        Project project = manager.getProject();
        GlobalSearchScope projectScopeWithoutLibraries = GlobalSearchScope.projectScope((Project)project);
        GlobalSearchScope scope = projectScopeWithoutLibraries.intersectWith(testClassFilter.getScope());
        PsiClass base = testClassFilter.getBase();
        if (base != null) {
            ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass aClass) {
                    if (testClassFilter.isAccepted(aClass)) {
                        found.add(aClass);
                    }
                    return true;
                }
            });
        }
        for (PsiMethod method : suiteMethods = (PsiMethod[])ReadAction.compute(() -> PsiShortNamesCache.getInstance((Project)project).getMethodsByName("suite", scope))) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                if (containingClass instanceof PsiAnonymousClass) {
                    return;
                }
                if (containingClass.hasModifierProperty("abstract")) {
                    return;
                }
                if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                    return;
                }
                if (JUnitUtil.isSuiteMethod((PsiMethod)method) && testClassFilter.isAccepted(containingClass)) {
                    found.add(containingClass);
                }
            });
        }
        HashSet processed = new HashSet();
        boolean hasJunit4 = ConfigurationUtil.addAnnotatedMethodsAnSubclasses(scope, testClassFilter, module, found, processed, "org.junit.Test", manager.getProject());
        return hasJunit4 |= ConfigurationUtil.addAnnotatedMethodsAnSubclasses(scope, testClassFilter, module, found, processed, "org.junit.runner.RunWith", manager.getProject());
    }

    private static boolean addAnnotatedMethodsAnSubclasses(GlobalSearchScope scope, final TestClassFilter testClassFilter, @Nullable Module module, final Set<? super PsiClass> found, final Set<? super PsiClass> processed, String annotation, Project project) {
        final Ref isJUnit4 = new Ref((Object)Boolean.FALSE);
        PsiClass testAnnotation = (PsiClass)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project).findClass(annotation, GlobalSearchScope.allScope((Project)project)));
        if (testAnnotation != null) {
            GlobalSearchScope allScope = module == null ? GlobalSearchScope.allScope((Project)project) : module.getModuleRuntimeScope(true);
            ClassesWithAnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)allScope).forEach(annotated -> {
                boolean success = (Boolean)ReadAction.compute(() -> {
                    if (!processed.add((PsiClass)annotated)) {
                        return false;
                    }
                    VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)annotated);
                    if (file != null && scope.contains(file) && testClassFilter.isAccepted((PsiClass)annotated)) {
                        if (!found.add((PsiClass)annotated)) {
                            return false;
                        }
                        isJUnit4.set((Object)Boolean.TRUE);
                    }
                    return true;
                });
                if (!success) {
                    return true;
                }
                ClassInheritorsSearch.search((PsiClass)annotated, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                    public boolean processInReadAction(PsiClass aClass) {
                        if (testClassFilter.isAccepted(aClass)) {
                            found.add(aClass);
                            processed.add(aClass);
                            isJUnit4.set((Object)Boolean.TRUE);
                        }
                        return true;
                    }
                });
                return true;
            });
        }
        return (Boolean)isJUnit4.get();
    }
}

