/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.graph;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.graph.DirectedGraph;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\rB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/util/graph/DirectedGraph;", "T", "", "edges", "", "Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "(Ljava/util/Set;)V", "getEdges", "()Ljava/util/Set;", "vertices", "getVertices", "toString", "", "Edge", "kotlin.idea"})
public final class DirectedGraph<T> {
    @NotNull
    private final Set<Edge<T>> edges;
    @NotNull
    private final Set<T> vertices;

    public DirectedGraph(@NotNull Set<Edge<T>> edges) {
        this.edges = edges;
        this.vertices = SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.edges), (Function1)vertices.1.INSTANCE));
    }

    @NotNull
    public final Set<Edge<T>> getEdges() {
        return this.edges;
    }

    @NotNull
    public final Set<T> getVertices() {
        return this.vertices;
    }

    @NotNull
    public String toString() {
        return "DirectedGraph(" + this.edges + ", " + this.vertices + ")";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "T", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/util/graph/DirectedGraph$Edge;", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    public static final class Edge<T> {
        private final T from;
        private final T to;

        public Edge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final Edge<T> copy(T from, T to) {
            return new Edge<T>(from, to);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = edge.from;
            }
            if ((n & 2) != 0) {
                object2 = edge.to;
            }
            return edge.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "Edge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual(this.from, edge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, edge.to);
        }
    }
}

