/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics.fileloggers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.AnonymizerUtilsKt;
import org.jetbrains.kotlin.statistics.MetricValueValidationFailed;
import org.jetbrains.kotlin.statistics.fileloggers.IRecordLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IMetricContainer;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0016J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J1\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001fJ1\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010 J1\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010!R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "Lorg/jetbrains/kotlin/statistics/metrics/IStatisticsValuesConsumer;", "forceValuesValidation", "", "(Z)V", "booleanMetrics", "Ljava/util/TreeMap;", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$MetricDescriptor;", "Lorg/jetbrains/kotlin/statistics/metrics/IMetricContainer;", "metricsLock", "Ljava/lang/Object;", "numericalMetrics", "", "stringMetrics", "", "flush", "", "trackingFile", "Lorg/jetbrains/kotlin/statistics/fileloggers/IRecordLogger;", "getMetric", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "getProjectHash", "perProject", "subprojectName", "processProjectName", "report", "value", "weight", "(Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;ZLjava/lang/String;Ljava/lang/Long;)Z", "(Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;JLjava/lang/String;Ljava/lang/Long;)Z", "(Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Z", "Companion", "MetricDescriptor", "kotlin-gradle-statistics"})
@SourceDebugExtension(value={"SMAP\nMetricsContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsContainer.kt\norg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n1#2:181\n8811#3,2:182\n9071#3,4:184\n8811#3,2:188\n9071#3,4:190\n8811#3,2:194\n9071#3,4:196\n*E\n*S KotlinDebug\n*F\n+ 1 MetricsContainer.kt\norg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer\n*L\n44#1,2:182\n44#1,4:184\n46#1,2:188\n46#1,4:190\n48#1,2:194\n48#1,4:196\n*E\n"})
public final class MetricsContainer
implements IStatisticsValuesConsumer {
    @NotNull
    public static final Companion Companion;
    private final boolean forceValuesValidation;
    @NotNull
    private final Object metricsLock;
    @NotNull
    private final TreeMap<MetricDescriptor, IMetricContainer<Long>> numericalMetrics;
    @NotNull
    private final TreeMap<MetricDescriptor, IMetricContainer<Boolean>> booleanMetrics;
    @NotNull
    private final TreeMap<MetricDescriptor, IMetricContainer<String>> stringMetrics;
    @NotNull
    private static final String BUILD_SESSION_SEPARATOR = "BUILD FINISHED";
    @NotNull
    private static final Charset ENCODING;
    @NotNull
    private static final Map<String, StringMetrics> stringMetricsMap;
    @NotNull
    private static final Map<String, BooleanMetrics> booleanMetricsMap;
    @NotNull
    private static final Map<String, NumericalMetrics> numericalMetricsMap;

    public MetricsContainer(boolean forceValuesValidation) {
        this.forceValuesValidation = forceValuesValidation;
        this.metricsLock = new Object();
        this.numericalMetrics = new TreeMap();
        this.booleanMetrics = new TreeMap();
        this.stringMetrics = new TreeMap();
    }

    public /* synthetic */ MetricsContainer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    private final String processProjectName(String subprojectName, boolean perProject) {
        return perProject && subprojectName != null ? AnonymizerUtilsKt.sha256(subprojectName) : null;
    }

    private final String getProjectHash(boolean perProject, String subprojectName) {
        String string2 = subprojectName;
        return string2 == null ? null : this.processProjectName(string2, perProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean report(@NotNull BooleanMetrics metric, boolean value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        String projectHash = this.getProjectHash(metric.getPerProject(), subprojectName);
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            IMetricContainer<Boolean> iMetricContainer = this.booleanMetrics.get(new MetricDescriptor(metric.name(), projectHash));
            if (iMetricContainer == null) {
                IMetricContainer iMetricContainer2;
                IMetricContainer it = iMetricContainer2 = metric.getType().newMetricContainer();
                boolean bl2 = false;
                ((Map)this.booleanMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
                iMetricContainer = iMetricContainer2;
            }
            Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"booleanMetrics[MetricDes\u2026ame, projectHash)] = it }");
            IMetricContainer<Boolean> metricContainer = iMetricContainer;
            metricContainer.addValue(metric.getAnonymization().anonymize(value2), weight);
            Unit unit2 = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean report(@NotNull NumericalMetrics metric, long value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        String projectHash = this.getProjectHash(metric.getPerProject(), subprojectName);
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            IMetricContainer<Long> iMetricContainer = this.numericalMetrics.get(new MetricDescriptor(metric.name(), projectHash));
            if (iMetricContainer == null) {
                IMetricContainer iMetricContainer2;
                IMetricContainer it = iMetricContainer2 = metric.getType().newMetricContainer();
                boolean bl2 = false;
                ((Map)this.numericalMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
                iMetricContainer = iMetricContainer2;
            }
            Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"numericalMetrics[MetricD\u2026ame, projectHash)] = it }");
            IMetricContainer<Long> metricContainer = iMetricContainer;
            metricContainer.addValue(metric.getAnonymization().anonymize(value2), weight);
            Unit unit2 = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean report(@NotNull StringMetrics metric, @NotNull String value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String projectHash = this.getProjectHash(metric.getPerProject(), subprojectName);
        Object object = this.metricsLock;
        synchronized (object) {
            String anonymizedValue;
            IMetricContainer<String> metricContainer;
            block7: {
                block8: {
                    boolean bl = false;
                    IMetricContainer<String> iMetricContainer = this.stringMetrics.get(new MetricDescriptor(metric.name(), projectHash));
                    if (iMetricContainer == null) {
                        IMetricContainer iMetricContainer2;
                        IMetricContainer it = iMetricContainer2 = metric.getType().newMetricContainer();
                        boolean bl2 = false;
                        ((Map)this.stringMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
                        iMetricContainer = iMetricContainer2;
                    }
                    Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"stringMetrics[MetricDesc\u2026ame, projectHash)] = it }");
                    metricContainer = iMetricContainer;
                    anonymizedValue = metric.getAnonymization().anonymize(value2);
                    if (!this.forceValuesValidation || metric.getAnonymization().anonymizeOnIdeSize()) break block7;
                    if (StringsKt.contains$default((CharSequence)anonymizedValue, (CharSequence)"UNEXPECTED-VALUE", (boolean)false, (int)2, null)) break block8;
                    CharSequence charSequence2 = anonymizedValue;
                    if (new Regex(metric.getAnonymization().validationRegexp()).matches(charSequence2)) break block7;
                }
                throw new MetricValueValidationFailed("Metric " + metric.name() + " has value [" + value2 + "], after anonymization [" + anonymizedValue + "]. Validation regex: " + metric.getAnonymization().validationRegexp() + '.');
            }
            metricContainer.addValue(anonymizedValue, weight);
            Unit unit2 = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@Nullable IRecordLogger trackingFile) {
        if (trackingFile == null) {
            return;
        }
        TreeMap allMetrics = new TreeMap();
        Object object = this.metricsLock;
        synchronized (object) {
            boolean $i$a$-synchronized-MetricsContainer$flush$32 = false;
            allMetrics.putAll(this.numericalMetrics);
            allMetrics.putAll(this.booleanMetrics);
            allMetrics.putAll(this.stringMetrics);
            Unit $i$a$-synchronized-MetricsContainer$flush$32 = Unit.INSTANCE;
        }
        for (Map.Entry entry : allMetrics.entrySet()) {
            String suffix2 = ((MetricDescriptor)entry.getKey()).getProjectHash() == null ? "" : '.' + ((MetricDescriptor)entry.getKey()).getProjectHash();
            trackingFile.append(((MetricDescriptor)entry.getKey()).getName() + suffix2 + '=' + ((IMetricContainer)entry.getValue()).toStringRepresentation());
        }
        trackingFile.append(BUILD_SESSION_SEPARATOR);
        object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            this.stringMetrics.clear();
            this.booleanMetrics.clear();
            this.numericalMetrics.clear();
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IMetricContainer<Long> getMetric(@NotNull NumericalMetrics metric) {
        IMetricContainer<Long> iMetricContainer;
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            iMetricContainer = this.numericalMetrics.get(new MetricDescriptor(metric.name(), null));
        }
        return iMetricContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IMetricContainer<String> getMetric(@NotNull StringMetrics metric) {
        IMetricContainer<String> iMetricContainer;
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            iMetricContainer = this.stringMetrics.get(new MetricDescriptor(metric.name(), null));
        }
        return iMetricContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IMetricContainer<Boolean> getMetric(@NotNull BooleanMetrics metric) {
        IMetricContainer<Boolean> iMetricContainer;
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Object object = this.metricsLock;
        synchronized (object) {
            boolean bl = false;
            iMetricContainer = this.booleanMetrics.get(new MetricDescriptor(metric.name(), null));
        }
        return iMetricContainer;
    }

    public MetricsContainer() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Map access$getStringMetricsMap$cp() {
        return stringMetricsMap;
    }

    public static final /* synthetic */ Map access$getBooleanMetricsMap$cp() {
        return booleanMetricsMap;
    }

    public static final /* synthetic */ Map access$getNumericalMetricsMap$cp() {
        return numericalMetricsMap;
    }

    public static final /* synthetic */ TreeMap access$getStringMetrics$p(MetricsContainer $this) {
        return $this.stringMetrics;
    }

    public static final /* synthetic */ Object access$getMetricsLock$p(MetricsContainer $this) {
        return $this.metricsLock;
    }

    public static final /* synthetic */ TreeMap access$getBooleanMetrics$p(MetricsContainer $this) {
        return $this.booleanMetrics;
    }

    public static final /* synthetic */ TreeMap access$getNumericalMetrics$p(MetricsContainer $this) {
        return $this.numericalMetrics;
    }

    static {
        int n;
        Enum p0;
        Map map2;
        Enum element$iv$iv2;
        Enum[] $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        ENCODING = Charsets.UTF_8;
        Enum[] $this$associateBy$iv = StringMetrics.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        StringMetrics[] stringMetricsArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Enum element$iv$iv2 : $this$associateByTo$iv$iv) {
            void var9_9 = element$iv$iv2;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(p0.name(), element$iv$iv2);
        }
        stringMetricsMap = destination$iv$iv;
        $this$associateBy$iv = BooleanMetrics.values();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        int n2 = $this$associateByTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            p0 = element$iv$iv2 = $this$associateByTo$iv$iv[n];
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(p0.name(), element$iv$iv2);
        }
        booleanMetricsMap = destination$iv$iv;
        $this$associateBy$iv = NumericalMetrics.values();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        n2 = $this$associateByTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            p0 = element$iv$iv2 = $this$associateByTo$iv$iv[n];
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(p0.name(), element$iv$iv2);
        }
        numericalMetricsMap = destination$iv$iv;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$MetricDescriptor;", "", "name", "", "projectHash", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getProjectHash", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "kotlin-gradle-statistics"})
    public static final class MetricDescriptor
    implements Comparable<MetricDescriptor> {
        @NotNull
        private final String name;
        @Nullable
        private final String projectHash;

        public MetricDescriptor(@NotNull String name2, @Nullable String projectHash) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.projectHash = projectHash;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getProjectHash() {
            return this.projectHash;
        }

        @Override
        public int compareTo(@NotNull MetricDescriptor other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int compareNames = this.name.compareTo(other.name);
            if (compareNames != 0) {
                n = compareNames;
            } else if (Intrinsics.areEqual((Object)this.projectHash, (Object)other.projectHash)) {
                n = 0;
            } else {
                String string2;
                String string3 = this.projectHash;
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = other.projectHash) == null) {
                    string2 = "";
                }
                n = string3.compareTo(string2);
            }
            return n;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.projectHash;
        }

        @NotNull
        public final MetricDescriptor copy(@NotNull String name2, @Nullable String projectHash) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new MetricDescriptor(name2, projectHash);
        }

        public static /* synthetic */ MetricDescriptor copy$default(MetricDescriptor metricDescriptor, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = metricDescriptor.name;
            }
            if ((n & 2) != 0) {
                string3 = metricDescriptor.projectHash;
            }
            return metricDescriptor.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "MetricDescriptor(name=" + this.name + ", projectHash=" + this.projectHash + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.projectHash == null ? 0 : this.projectHash.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetricDescriptor)) {
                return false;
            }
            MetricDescriptor metricDescriptor = (MetricDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)metricDescriptor.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.projectHash, (Object)metricDescriptor.projectHash);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$Companion;", "", "()V", "BUILD_SESSION_SEPARATOR", "", "ENCODING", "Ljava/nio/charset/Charset;", "getENCODING", "()Ljava/nio/charset/Charset;", "booleanMetricsMap", "", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "numericalMetricsMap", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "stringMetricsMap", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "readFromFile", "", "file", "Ljava/io/File;", "consumer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "", "kotlin-gradle-statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Charset getENCODING() {
            return ENCODING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean readFromFile(@NotNull File file2, @NotNull Function1<? super MetricsContainer, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ};
            FileChannel channel = FileChannel.open(Paths.get(file2.toURI()), openOptionArray);
            if (channel.tryLock() == null) {
                return false;
            }
            InputStream inputStream = Channels.newInputStream(channel);
            try {
                Ref.ObjectRef container = new Ref.ObjectRef();
                container.element = new MetricsContainer(false, 1, null);
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream, this.getENCODING())), (Function1)((Function1)new Function1<String, Unit>(consumer, (Ref.ObjectRef<MetricsContainer>)container){
                    final /* synthetic */ Function1<MetricsContainer, Unit> $consumer;
                    final /* synthetic */ Ref.ObjectRef<MetricsContainer> $container;
                    {
                        this.$consumer = $consumer;
                        this.$container = $container;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull String line) {
                        block16: {
                            Object object;
                            IMetricContainer<T> it;
                            IMetricContainer<T> iMetricContainer;
                            Enum metricType;
                            Ref.ObjectRef<MetricsContainer> objectRef;
                            Enum enum_;
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                if (!Intrinsics.areEqual((Object)"BUILD FINISHED", (Object)line)) break block15;
                                this.$consumer.invoke(this.$container.element);
                                this.$container.element = new MetricsContainer(false, 1, null);
                                break block16;
                            }
                            char[] cArray = new char[]{'='};
                            List lineParts = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                            if (lineParts.size() != 2) break block16;
                            char[] cArray2 = new char[]{'.'};
                            String name2 = (String)StringsKt.split$default((CharSequence)((CharSequence)lineParts.get(0)), (char[])cArray2, (boolean)false, (int)0, (int)6, null).get(0);
                            char[] cArray3 = new char[]{'.'};
                            String subProjectHash = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)((CharSequence)lineParts.get(0)), (char[])cArray3, (boolean)false, (int)0, (int)6, null), (int)1);
                            String representation = (String)lineParts.get(1);
                            StringMetrics stringMetrics = (StringMetrics)((Object)MetricsContainer.access$getStringMetricsMap$cp().get(name2));
                            if (stringMetrics != null) {
                                enum_ = stringMetrics;
                                objectRef = this.$container;
                                metricType = enum_;
                                boolean bl = false;
                                IMetricContainer<T> iMetricContainer2 = ((StringMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer2 != null) {
                                    it = iMetricContainer = iMetricContainer2;
                                    boolean bl2 = false;
                                    object = MetricsContainer.access$getMetricsLock$p((MetricsContainer)objectRef.element);
                                    synchronized (object) {
                                        boolean $i$a$-synchronized-MetricsContainer$Companion$readFromFile$1$1$1$22 = false;
                                        ((Map)MetricsContainer.access$getStringMetrics$p((MetricsContainer)objectRef.element)).put(new MetricDescriptor(name2, subProjectHash), it);
                                        Unit $i$a$-synchronized-MetricsContainer$Companion$readFromFile$1$1$1$22 = Unit.INSTANCE;
                                    }
                                }
                            }
                            BooleanMetrics booleanMetrics = (BooleanMetrics)((Object)MetricsContainer.access$getBooleanMetricsMap$cp().get(name2));
                            if (booleanMetrics != null) {
                                enum_ = booleanMetrics;
                                objectRef = this.$container;
                                metricType = enum_;
                                boolean bl = false;
                                IMetricContainer<T> iMetricContainer3 = ((BooleanMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer3 != null) {
                                    it = iMetricContainer = iMetricContainer3;
                                    boolean bl3 = false;
                                    object = MetricsContainer.access$getMetricsLock$p((MetricsContainer)objectRef.element);
                                    synchronized (object) {
                                        boolean $i$a$-synchronized-MetricsContainer$Companion$readFromFile$1$2$1$22 = false;
                                        ((Map)MetricsContainer.access$getBooleanMetrics$p((MetricsContainer)objectRef.element)).put(new MetricDescriptor(name2, subProjectHash), it);
                                        Unit $i$a$-synchronized-MetricsContainer$Companion$readFromFile$1$2$1$22 = Unit.INSTANCE;
                                    }
                                }
                            }
                            NumericalMetrics numericalMetrics = (NumericalMetrics)((Object)MetricsContainer.access$getNumericalMetricsMap$cp().get(name2));
                            if (numericalMetrics != null) {
                                enum_ = numericalMetrics;
                                objectRef = this.$container;
                                metricType = enum_;
                                boolean bl = false;
                                IMetricContainer<T> iMetricContainer4 = ((NumericalMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer4 != null) {
                                    it = iMetricContainer = iMetricContainer4;
                                    boolean bl4 = false;
                                    object = MetricsContainer.access$getMetricsLock$p((MetricsContainer)objectRef.element);
                                    synchronized (object) {
                                        boolean bl5 = false;
                                        ((Map)MetricsContainer.access$getNumericalMetrics$p((MetricsContainer)objectRef.element)).put(new MetricDescriptor(name2, subProjectHash), it);
                                        Unit unit2 = Unit.INSTANCE;
                                    }
                                }
                            }
                        }
                    }
                }));
            }
            finally {
                channel.close();
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

