/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.printing.JKPrinter;
import org.jetbrains.kotlin.nj2k.tree.JKComment;
import org.jetbrains.kotlin.nj2k.tree.JKDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0007H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000eH\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter;", "", "printer", "Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;", "(Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;)V", "printedTokens", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKComment;", "printLeadingComments", "", "element", "Lorg/jetbrains/kotlin/nj2k/tree/JKFormattingOwner;", "printTrailingComments", "createText", "", "", "hasNoLineBreakAfterSingleLineComment", "", "shouldBeDropped", "kotlin.j2k.new"})
public final class JKCommentPrinter {
    @NotNull
    private final JKPrinter printer;
    @NotNull
    private final Set<JKComment> printedTokens;

    public JKCommentPrinter(@NotNull JKPrinter printer) {
        this.printer = printer;
        this.printedTokens = new LinkedHashSet();
    }

    private final boolean shouldBeDropped(JKComment $this$shouldBeDropped) {
        return StringsKt.startsWith$default((String)$this$shouldBeDropped.getText(), (String)"//noinspection", (boolean)false, (int)2, null);
    }

    private final String createText(JKComment $this$createText) {
        String string2;
        if (!this.printedTokens.contains($this$createText)) {
            ((Collection)this.printedTokens).add($this$createText);
            string2 = !$this$createText.isSingleline() && StringsKt.lastIndexOf$default((CharSequence)$this$createText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) != StringsKt.indexOf$default((CharSequence)$this$createText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) ? StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)$this$createText.getText(), (String)"/*", (String)"/ *", (boolean)false, (int)4, null), (String)"/ *", (String)"/*", (boolean)false, (int)4, null) : $this$createText.getText();
        } else {
            string2 = null;
        }
        return string2;
    }

    private final String createText(List<JKComment> $this$createText) {
        StringBuilder stringBuilder;
        StringBuilder $this$createText_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean needNewLine = false;
        for (JKComment comment2 : $this$createText) {
            String text2;
            Object object;
            if (this.shouldBeDropped(comment2) || this.createText(comment2) == null) continue;
            if (needNewLine) {
                boolean bl2;
                if (comment2.getIndent() != null) {
                    String it;
                    boolean bl3 = false;
                    bl2 = StringUtil.containsLineBreak((CharSequence)it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    Intrinsics.checkNotNullExpressionValue((Object)$this$createText_u24lambda_u241.append('\n'), (String)"append('\\n')");
                }
            }
            if ((object = comment2.getIndent()) == null) {
                object = Character.valueOf(' ');
            }
            $this$createText_u24lambda_u241.append(object);
            $this$createText_u24lambda_u241.append(text2);
            needNewLine = StringsKt.startsWith$default((String)text2, (String)"//", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text2, (char)'\n', (boolean)false, (int)2, null);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final boolean hasNoLineBreakAfterSingleLineComment(String $this$hasNoLineBreakAfterSingleLineComment) {
        return StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (char)'\n', (int)0, (boolean)false, (int)6, null) < StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (String)"//", (int)0, (boolean)false, (int)6, null);
    }

    public final void printLeadingComments(@NotNull JKFormattingOwner element3) {
        boolean addNewLine;
        String text2 = this.createText(element3.getLeadingComments());
        this.printer.print(text2);
        boolean bl = addNewLine = element3.getHasLeadingLineBreak() || this.hasNoLineBreakAfterSingleLineComment(text2);
        if (addNewLine) {
            this.printer.println();
        }
    }

    public final void printTrailingComments(@NotNull JKFormattingOwner element3) {
        boolean addNewLine;
        String text2 = this.createText(element3.getTrailingComments());
        this.printer.print(text2);
        boolean bl = element3.getHasTrailingLineBreak() || element3 instanceof JKDeclaration && !((Collection)element3.getTrailingComments()).isEmpty() || this.hasNoLineBreakAfterSingleLineComment(text2) ? true : (addNewLine = false);
        if (addNewLine) {
            this.printer.println();
        }
    }
}

