/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.externalCodeProcessing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.AccessorToPropertyJavaExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.AccessorToPropertyKotlinExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKExternalConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKFieldData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKFieldDataFromJava;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKMemberData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.JKMethodData;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.PropertyRenamedJavaExternalUsageConversion;
import org.jetbrains.kotlin.nj2k.externalCodeProcessing.PropertyRenamedKotlinExternalUsageConversion;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0002J(\u0010\t\u001a\u00020\n*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J(\u0010\t\u001a\u00020\n*\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003H\u0002J\u000e\u0010\u0015\u001a\u00020\u0016*\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0017\u001a\u00020\u0016*\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer;", "", "usages", "", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer$JKMemberInfoWithUsages;", "(Ljava/util/List;)V", "conversions", "", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKExternalConversion;", "fix", "", "addAnnotationIfThereAreNoJvmOnes", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKFieldDataFromJava;", "javaUsages", "Lcom/intellij/psi/PsiElement;", "kotlinUsages", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMethodData;", "isConstProperty", "", "isSimpleProperty", "Companion", "JKMemberInfoWithUsages", "kotlin.j2k.new"})
public final class ExternalUsagesFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JKMemberInfoWithUsages> usages;
    @NotNull
    private final List<JKExternalConversion> conversions;
    @NotNull
    private static final FqName JVM_STATIC_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");
    @NotNull
    private static final List<FqName> USED_JVM_ANNOTATIONS;

    public ExternalUsagesFixer(@NotNull List<JKMemberInfoWithUsages> usages2) {
        this.usages = usages2;
        this.conversions = new ArrayList();
    }

    public final void fix() {
        Iterable $this$forEach$iv = this.usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JKMemberInfoWithUsages it = (JKMemberInfoWithUsages)element$iv;
            boolean bl = false;
            this.fix(it);
        }
        CollectionsKt.sort(this.conversions);
        $this$forEach$iv = this.conversions;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JKExternalConversion p0 = (JKExternalConversion)element$iv;
            boolean bl = false;
            p0.apply();
        }
    }

    private final void fix(JKMemberInfoWithUsages $this$fix) {
        JKMemberData jKMemberData = $this$fix.getMember();
        if (jKMemberData instanceof JKFieldDataFromJava) {
            this.fix((JKFieldDataFromJava)$this$fix.getMember(), $this$fix.getJavaUsages(), $this$fix.getKotlinUsages());
        } else if (jKMemberData instanceof JKMethodData) {
            this.fix((JKMethodData)$this$fix.getMember(), $this$fix.getJavaUsages(), $this$fix.getKotlinUsages());
        }
    }

    private final void fix(JKFieldDataFromJava $this$fix, List<? extends PsiElement> javaUsages, List<? extends KtElement> kotlinUsages) {
        JKFieldDataFromJava $this$fix_u24lambda_u241 = $this$fix;
        boolean bl = false;
        KtNamedDeclaration ktNamedDeclaration = $this$fix_u24lambda_u241.getKotlinElement();
        if (ktNamedDeclaration != null) {
            KtNamedDeclaration ktProperty = ktNamedDeclaration;
            if (!((Collection)javaUsages).isEmpty() && this.isSimpleProperty(ktProperty)) {
                this.addAnnotationIfThereAreNoJvmOnes(ktProperty, JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME);
            } else if (!((Collection)javaUsages).isEmpty() && $this$fix_u24lambda_u241.isStatic() && !ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                this.addAnnotationIfThereAreNoJvmOnes(ktProperty, JVM_STATIC_FQ_NAME);
            }
        }
        if ($this$fix.getWasRenamed()) {
            PsiElement usage;
            Iterable $this$forEach$iv = javaUsages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                usage = (PsiElement)element$iv;
                boolean bl2 = false;
                ((Collection)this.conversions).add(new PropertyRenamedJavaExternalUsageConversion($this$fix.getName(), usage));
            }
            $this$forEach$iv = kotlinUsages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                usage = (KtElement)element$iv;
                boolean bl3 = false;
                ((Collection)this.conversions).add(new PropertyRenamedKotlinExternalUsageConversion($this$fix.getName(), (KtElement)usage));
            }
        }
    }

    private final void fix(JKMethodData $this$fix, List<? extends PsiElement> javaUsages, List<? extends KtElement> kotlinUsages) {
        JKFieldData jKFieldData = $this$fix.getUsedAsAccessorOfProperty();
        JKMemberData member2 = jKFieldData != null ? (JKMemberData)jKFieldData : (JKMemberData)$this$fix;
        KtNamedDeclaration element3 = member2.getKotlinElement();
        if (!((Collection)javaUsages).isEmpty() && this.isSimpleProperty(element3)) {
            KtNamedDeclaration ktNamedDeclaration = element3;
            if (ktNamedDeclaration != null) {
                this.addAnnotationIfThereAreNoJvmOnes(ktNamedDeclaration, JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME);
            }
        } else if (!((Collection)javaUsages).isEmpty() && $this$fix.isStatic() && !this.isConstProperty(element3)) {
            KtNamedDeclaration ktNamedDeclaration = element3;
            if (ktNamedDeclaration != null) {
                this.addAnnotationIfThereAreNoJvmOnes(ktNamedDeclaration, JVM_STATIC_FQ_NAME);
            }
        }
        if (this.isSimpleProperty(element3)) {
            PsiElement usage;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            AccessorKind accessorKind = StringsKt.startsWith$default((String)((PsiMethod)$this$fix.getJavaElement()).getName(), (String)"set", (boolean)false, (int)2, null) ? AccessorKind.SETTER : AccessorKind.GETTER;
            KtNamedDeclaration ktNamedDeclaration = element3;
            boolean bl = ktNamedDeclaration != null ? ModifierListModifactorKt.hasJvmFieldAnnotation((KtAnnotated)ktNamedDeclaration) : false;
            if (bl) {
                $this$forEach$iv = javaUsages;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    usage = (PsiElement)element$iv;
                    boolean bl2 = false;
                    ((Collection)this.conversions).add(new AccessorToPropertyJavaExternalConversion(member2.getName(), accessorKind, usage));
                }
            }
            $this$forEach$iv = kotlinUsages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                usage = (KtElement)element$iv;
                boolean bl3 = false;
                ((Collection)this.conversions).add(new AccessorToPropertyKotlinExternalConversion(member2.getName(), accessorKind, usage));
            }
        }
    }

    private final boolean isConstProperty(KtNamedDeclaration $this$isConstProperty) {
        return $this$isConstProperty instanceof KtProperty && $this$isConstProperty.hasModifier(KtTokens.CONST_KEYWORD);
    }

    private final boolean isSimpleProperty(KtNamedDeclaration $this$isSimpleProperty) {
        KtNamedDeclaration ktNamedDeclaration = $this$isSimpleProperty;
        return (ktNamedDeclaration != null ? KotlinPsiUtils.isConstructorDeclaredProperty(ktNamedDeclaration) : false) || $this$isSimpleProperty instanceof KtProperty && ((KtProperty)$this$isSimpleProperty).getGetter() == null && ((KtProperty)$this$isSimpleProperty).getSetter() == null && !$this$isSimpleProperty.hasModifier(KtTokens.CONST_KEYWORD);
    }

    private final void addAnnotationIfThereAreNoJvmOnes(KtNamedDeclaration $this$addAnnotationIfThereAreNoJvmOnes, FqName fqName2) {
        boolean bl;
        block8: {
            Iterable $this$any$iv = $this$addAnnotationIfThereAreNoJvmOnes.getAnnotationEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block7: {
                        KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = USED_JVM_ANNOTATIONS;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                FqName jvmAnnotation = (FqName)element$iv2;
                                boolean bl4 = false;
                                KtTypeReference ktTypeReference = entry.getTypeReference();
                                boolean bl5 = ktTypeReference != null ? ktTypeReference.textMatches((CharSequence)jvmAnnotation.asString()) : false;
                                if (!bl5) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        $this$addAnnotationIfThereAreNoJvmOnes.addAnnotationEntry(new KtPsiFactory((KtElement)$this$addAnnotationIfThereAreNoJvmOnes, false, 2, null).createAnnotationEntry("@" + fqName2.asString()));
    }

    static {
        Object[] objectArray = new FqName[]{JVM_STATIC_FQ_NAME, JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME};
        USED_JVM_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer$JKMemberInfoWithUsages;", "", "member", "Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;", "javaUsages", "", "Lcom/intellij/psi/PsiElement;", "kotlinUsages", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;Ljava/util/List;Ljava/util/List;)V", "getJavaUsages", "()Ljava/util/List;", "getKotlinUsages", "getMember", "()Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/JKMemberData;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.j2k.new"})
    public static final class JKMemberInfoWithUsages {
        @NotNull
        private final JKMemberData member;
        @NotNull
        private final List<PsiElement> javaUsages;
        @NotNull
        private final List<KtElement> kotlinUsages;

        public JKMemberInfoWithUsages(@NotNull JKMemberData member2, @NotNull List<? extends PsiElement> javaUsages, @NotNull List<? extends KtElement> kotlinUsages) {
            this.member = member2;
            this.javaUsages = javaUsages;
            this.kotlinUsages = kotlinUsages;
        }

        @NotNull
        public final JKMemberData getMember() {
            return this.member;
        }

        @NotNull
        public final List<PsiElement> getJavaUsages() {
            return this.javaUsages;
        }

        @NotNull
        public final List<KtElement> getKotlinUsages() {
            return this.kotlinUsages;
        }

        @NotNull
        public final JKMemberData component1() {
            return this.member;
        }

        @NotNull
        public final List<PsiElement> component2() {
            return this.javaUsages;
        }

        @NotNull
        public final List<KtElement> component3() {
            return this.kotlinUsages;
        }

        @NotNull
        public final JKMemberInfoWithUsages copy(@NotNull JKMemberData member2, @NotNull List<? extends PsiElement> javaUsages, @NotNull List<? extends KtElement> kotlinUsages) {
            return new JKMemberInfoWithUsages(member2, javaUsages, kotlinUsages);
        }

        public static /* synthetic */ JKMemberInfoWithUsages copy$default(JKMemberInfoWithUsages jKMemberInfoWithUsages, JKMemberData jKMemberData, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                jKMemberData = jKMemberInfoWithUsages.member;
            }
            if ((n & 2) != 0) {
                list2 = jKMemberInfoWithUsages.javaUsages;
            }
            if ((n & 4) != 0) {
                list3 = jKMemberInfoWithUsages.kotlinUsages;
            }
            return jKMemberInfoWithUsages.copy(jKMemberData, list2, list3);
        }

        @NotNull
        public String toString() {
            return "JKMemberInfoWithUsages(member=" + this.member + ", javaUsages=" + this.javaUsages + ", kotlinUsages=" + this.kotlinUsages + ")";
        }

        public int hashCode() {
            int result2 = this.member.hashCode();
            result2 = result2 * 31 + ((Object)this.javaUsages).hashCode();
            result2 = result2 * 31 + ((Object)this.kotlinUsages).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JKMemberInfoWithUsages)) {
                return false;
            }
            JKMemberInfoWithUsages jKMemberInfoWithUsages = (JKMemberInfoWithUsages)other;
            if (!Intrinsics.areEqual((Object)this.member, (Object)jKMemberInfoWithUsages.member)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.javaUsages, jKMemberInfoWithUsages.javaUsages)) {
                return false;
            }
            return Intrinsics.areEqual(this.kotlinUsages, jKMemberInfoWithUsages.kotlinUsages);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/nj2k/externalCodeProcessing/ExternalUsagesFixer$Companion;", "", "()V", "JVM_STATIC_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "USED_JVM_ANNOTATIONS", "", "getUSED_JVM_ANNOTATIONS", "()Ljava/util/List;", "kotlin.j2k.new"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FqName> getUSED_JVM_ANNOTATIONS() {
            return USED_JVM_ANNOTATIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

