/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversion;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversionKt;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentImpl;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0011\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u0012\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\t*\u00020\nH\u0002J\u0014\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\nH\u0002J\u0014\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u001a\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001d\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001e\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u001f\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/LiteralConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "cannotConvertLiteralMessage", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKLiteralExpression;", "createTodoCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKCallExpressionImpl;", "message", "addTrimIndentCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKQualifiedExpression;", "cleanFloatAndDoubleLiterals", "cleanIntAndLongLiterals", "convertBinaryLiteral", "isLongLiteral", "", "convertCharLiteral", "convertHexLiteral", "convertLiteral", "", "convertOctalLiteral", "toDoubleLiteral", "toFloatLiteral", "toIntLiteral", "toLongLiteral", "toRawStringLiteral", "toStringLiteral", "kotlin.j2k.new"})
public final class LiteralConversion
extends RecursiveApplicableConversionBase {
    public LiteralConversion(@NotNull NewJ2kConverterContext context2) {
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        JKTreeElement jKTreeElement;
        if (!(element3 instanceof JKLiteralExpression)) {
            return this.recurse(element3);
        }
        try {
            JKLiteralExpression $this$applyToElement_u24lambda_u240 = (JKLiteralExpression)element3;
            boolean bl = false;
            this.convertLiteral($this$applyToElement_u24lambda_u240);
            jKTreeElement = $this$applyToElement_u24lambda_u240.getType() == JKLiteralExpression.LiteralType.TEXT_BLOCK ? (JKExpression)this.addTrimIndentCall($this$applyToElement_u24lambda_u240) : (JKExpression)$this$applyToElement_u24lambda_u240;
        }
        catch (NumberFormatException numberFormatException) {
            jKTreeElement = this.createTodoCall(this.cannotConvertLiteralMessage((JKLiteralExpression)element3));
        }
        return jKTreeElement;
    }

    private final JKQualifiedExpression addTrimIndentCall(JKLiteralExpression $this$addTrimIndentCall) {
        JKTreeElement jKTreeElement;
        JKTreeElement $this$copyTreeAndDetach$iv = $this$addTrimIndentCall;
        boolean $i$f$copyTreeAndDetach = false;
        JKTreeElement $this$copyTree$iv$iv = $this$copyTreeAndDetach$iv;
        boolean $i$f$copyTree = false;
        JKFormattingOwner jKFormattingOwner = FormattingKt.withFormattingFrom((JKFormattingOwner)$this$copyTree$iv$iv.copy(), (JKFormattingOwner)$this$copyTree$iv$iv);
        if (jKFormattingOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression");
        }
        JKTreeElement it$iv = jKTreeElement = (JKTreeElement)((JKLiteralExpression)jKFormattingOwner);
        boolean bl = false;
        if (it$iv.getParent() != null) {
            JKElement jKElement = it$iv.getParent();
            Intrinsics.checkNotNull((Object)jKElement);
            it$iv.detach(jKElement);
        }
        return (JKQualifiedExpression)FormattingKt.withFormattingFrom((JKFormattingOwner)new JKQualifiedExpression((JKExpression)jKTreeElement, new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin.text.trimIndent"), null, null, this.getTypeFactory().getTypes().getString(), 6, null), null, 4, null), (JKFormattingOwner)$this$addTrimIndentCall);
    }

    private final JKCallExpressionImpl createTodoCall(@NonNls String message2) {
        JKMethodSymbol todoMethodSymbol = this.getSymbolProvider().provideMethodSymbol("kotlin.TODO");
        JKArgumentImpl todoMessageArgument = new JKArgumentImpl(new JKLiteralExpression("\"" + message2 + "\"", JKLiteralExpression.LiteralType.STRING, null, 4, null));
        JKArgument[] jKArgumentArray = new JKArgument[]{todoMessageArgument};
        return new JKCallExpressionImpl(todoMethodSymbol, new JKArgumentList(jKArgumentArray), null, null, 12, null);
    }

    private final String cannotConvertLiteralMessage(JKLiteralExpression element3) {
        String string2 = element3.getType().toString().toLowerCase(Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        String literalType = string2;
        String literalValue = element3.getLiteral();
        return "Could not convert " + literalType + " literal '" + literalValue + "' to Kotlin";
    }

    private final void convertLiteral(JKLiteralExpression $this$convertLiteral) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertLiteral.getType().ordinal()]) {
            case 1: {
                string2 = this.toDoubleLiteral($this$convertLiteral);
                break;
            }
            case 2: {
                string2 = this.toFloatLiteral($this$convertLiteral);
                break;
            }
            case 3: {
                string2 = this.toLongLiteral($this$convertLiteral);
                break;
            }
            case 4: {
                string2 = this.toIntLiteral($this$convertLiteral);
                break;
            }
            case 5: {
                string2 = this.convertCharLiteral($this$convertLiteral);
                break;
            }
            case 6: {
                string2 = this.toStringLiteral($this$convertLiteral);
                break;
            }
            case 7: {
                string2 = this.toRawStringLiteral($this$convertLiteral);
                break;
            }
            default: {
                return;
            }
        }
        $this$convertLiteral.setLiteral(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final String toDoubleLiteral(JKLiteralExpression $this$toDoubleLiteral) {
        void var2_2;
        String text2 = this.cleanFloatAndDoubleLiterals($this$toDoubleLiteral.getLiteral());
        boolean bl = false;
        text2 = !StringsKt.contains$default((CharSequence)text2, (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)text2, (CharSequence)"e", (boolean)true) ? text2 + "." : text2;
        boolean bl2 = false;
        return StringsKt.endsWith$default((String)text2, (String)".", (boolean)false, (int)2, null) ? text2 + "0" : var2_2;
    }

    private final String toFloatLiteral(JKLiteralExpression $this$toFloatLiteral) {
        String text2 = this.cleanFloatAndDoubleLiterals($this$toFloatLiteral.getLiteral());
        boolean bl = false;
        return !StringsKt.endsWith$default((String)text2, (String)"f", (boolean)false, (int)2, null) ? text2 + "f" : text2;
    }

    private final String toStringLiteral(JKLiteralExpression $this$toStringLiteral) {
        CharSequence charSequence2 = LiteralConversionKt.access$replaceOctalEscapes($this$toStringLiteral.getLiteral(), "%s\\u%04x");
        Regex regex = new Regex("\\$([A-Za-z]+|\\{)");
        String string2 = "\\\\$0";
        return StringsKt.replace$default((String)regex.replace(charSequence2, string2), (String)"\\f", (String)"\\u000c", (boolean)false, (int)4, null);
    }

    private final String toRawStringLiteral(JKLiteralExpression $this$toRawStringLiteral) {
        CharSequence charSequence2 = $this$toRawStringLiteral.getLiteral();
        Regex regex = new Regex("([^\\\\])\\\\\n\\s*");
        Object object = "$1";
        $this$toRawStringLiteral.setLiteral(regex.replace(charSequence2, (String)object));
        while (StringsKt.contains$default((CharSequence)$this$toRawStringLiteral.getLiteral(), (CharSequence)"\\n", (boolean)false, (int)2, null)) {
            charSequence2 = $this$toRawStringLiteral.getLiteral();
            regex = new Regex("\\n(\\s*)(.*)(\\\\n)");
            object = "\n$1$2\n$1";
            $this$toRawStringLiteral.setLiteral(regex.replace(charSequence2, (String)object));
        }
        Map $this$forEach$iv = LiteralConversionKt.access$getRawStringSpecialCharReplacements$p();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String old = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            $this$toRawStringLiteral.setLiteral(StringsKt.replace$default((String)$this$toRawStringLiteral.getLiteral(), (String)old, (String)string2, (boolean)false, (int)4, null));
        }
        charSequence2 = StringsKt.replace$default((String)LiteralConversionKt.access$replaceOctalEscapes($this$toRawStringLiteral.getLiteral(), "%s${'\\u%04x'}"), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
        Regex regex2 = new Regex("\\n(\\s*)(.*)\"\"\"\\Z");
        object = "\n$1$2\n$1\"\"\"";
        return regex2.replace(charSequence2, (String)object);
    }

    private final String convertCharLiteral(JKLiteralExpression $this$convertCharLiteral) {
        CharSequence charSequence2 = $this$convertCharLiteral.getLiteral();
        Regex regex = new Regex("\\\\([0-3]?[0-7]{1,2})");
        Function1 function1 = convertCharLiteral.1.INSTANCE;
        return regex.replace(charSequence2, function1);
    }

    private final String toIntLiteral(JKLiteralExpression $this$toIntLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toIntLiteral.getLiteral()), false), false), false);
    }

    private final String toLongLiteral(JKLiteralExpression $this$toLongLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toLongLiteral.getLiteral()), true), true), true) + "L";
    }

    private final String convertHexLiteral(String $this$convertHexLiteral, boolean isLongLiteral) {
        Object object;
        if (!StringsKt.startsWith((String)$this$convertHexLiteral, (String)"0x", (boolean)true)) {
            return $this$convertHexLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertHexLiteral, (int)2), 16);
        if (isLongLiteral && value2.bitLength() > 63) {
            String string2 = Long.toString(value2.longValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            String string3 = string2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string3;
        } else if (!isLongLiteral && value2.bitLength() > 31) {
            String string4 = Integer.toString(value2.intValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
            String string5 = string4.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            object = "-0x" + string5;
        } else {
            object = $this$convertHexLiteral;
        }
        return object;
    }

    private final String convertBinaryLiteral(String $this$convertBinaryLiteral, boolean isLongLiteral) {
        String string2;
        if (!StringsKt.startsWith((String)$this$convertBinaryLiteral, (String)"0b", (boolean)true)) {
            return $this$convertBinaryLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertBinaryLiteral, (int)2), 2);
        if (isLongLiteral) {
            String string3 = Long.toString(value2.longValue(), CharsKt.checkRadix((int)10));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        } else {
            string2 = String.valueOf(value2.intValue());
        }
        return string2;
    }

    private final String convertOctalLiteral(String $this$convertOctalLiteral, boolean isLongLiteral) {
        String string2;
        if (!StringsKt.startsWith$default((String)$this$convertOctalLiteral, (String)"0", (boolean)false, (int)2, null) || $this$convertOctalLiteral.length() == 1 || Character.toLowerCase($this$convertOctalLiteral.charAt(1)) == 'x') {
            return $this$convertOctalLiteral;
        }
        BigInteger value2 = new BigInteger(StringsKt.drop((String)$this$convertOctalLiteral, (int)1), 8);
        if (isLongLiteral) {
            String string3 = Long.toString(value2.longValue(), CharsKt.checkRadix((int)10));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        } else {
            String string4 = Integer.toString(value2.intValue(), CharsKt.checkRadix((int)10));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
        }
        return string2;
    }

    private final String cleanFloatAndDoubleLiterals(String $this$cleanFloatAndDoubleLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)$this$cleanFloatAndDoubleLiterals, (String)"L", (String)"", (boolean)true), (String)"d", (String)"", (boolean)true), (String)".e", (String)"e", (boolean)true), (String)".f", (String)"", (boolean)true), (String)"f", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String cleanIntAndLongLiterals(String $this$cleanIntAndLongLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)$this$cleanIntAndLongLiterals, (String)"l", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JKLiteralExpression.LiteralType.values().length];
            try {
                nArray[JKLiteralExpression.LiteralType.DOUBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.CHAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.TEXT_BLOCK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

