/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.TypeVisitorKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.ArrayType;
import org.jetbrains.kotlin.j2k.ast.ClassType;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.ErrorType;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.InProjectionType;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.NullType;
import org.jetbrains.kotlin.j2k.ast.Nullability;
import org.jetbrains.kotlin.j2k.ast.OutProjectionType;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.ReferenceElement;
import org.jetbrains.kotlin.j2k.ast.StarProjectionType;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.UnitType;
import org.jetbrains.kotlin.j2k.ast.VarArgType;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/j2k/TypeVisitor;", "Lcom/intellij/psi/PsiTypeVisitor;", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "topLevelType", "Lcom/intellij/psi/PsiType;", "topLevelTypeMutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "inAnnotationType", "", "(Lorg/jetbrains/kotlin/j2k/Converter;Lcom/intellij/psi/PsiType;Lorg/jetbrains/kotlin/j2k/ast/Mutability;Z)V", "typeConverter", "Lorg/jetbrains/kotlin/j2k/TypeConverter;", "constructReferenceElement", "Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;", "classType", "Lcom/intellij/psi/PsiClassType;", "mutability", "convertTypeArgs", "", "createTypeArgsForRawTypeUsage", "visitArrayType", "arrayType", "Lcom/intellij/psi/PsiArrayType;", "visitClassType", "visitEllipsisType", "ellipsisType", "Lcom/intellij/psi/PsiEllipsisType;", "visitPrimitiveType", "primitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "visitType", "Lorg/jetbrains/kotlin/j2k/ast/ErrorType;", "type", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "kotlin.j2k.old"})
public final class TypeVisitor
extends PsiTypeVisitor<Type> {
    @NotNull
    private final Converter converter;
    @NotNull
    private final PsiType topLevelType;
    @NotNull
    private final Mutability topLevelTypeMutability;
    private final boolean inAnnotationType;
    @NotNull
    private final TypeConverter typeConverter;

    public TypeVisitor(@NotNull Converter converter, @NotNull PsiType topLevelType, @NotNull Mutability topLevelTypeMutability, boolean inAnnotationType) {
        this.converter = converter;
        this.topLevelType = topLevelType;
        this.topLevelTypeMutability = topLevelTypeMutability;
        this.inAnnotationType = inAnnotationType;
        this.typeConverter = this.converter.getTypeConverter();
    }

    @NotNull
    public ErrorType visitType(@NotNull PsiType type2) {
        return new ErrorType();
    }

    @NotNull
    public Type visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        String name2 = primitiveType.getCanonicalText();
        return Intrinsics.areEqual((Object)name2, (Object)"void") ? (Type)new UnitType() : (TypeVisitorKt.access$getPRIMITIVE_TYPES_NAMES$p().contains(name2) ? (Type)new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, StringUtil.capitalize((String)name2), false, false, null, 14, null)) : (Intrinsics.areEqual((Object)name2, (Object)"null") ? (Type)new NullType() : (Type)new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, name2, false, false, null, 14, null))));
    }

    @NotNull
    public Type visitArrayType(@NotNull PsiArrayType arrayType) {
        return new ArrayType(TypeConverter.convertType$default(this.typeConverter, arrayType.getComponentType(), null, null, this.inAnnotationType, 6, null), Nullability.Default, this.converter.getSettings());
    }

    @NotNull
    public Type visitClassType(@NotNull PsiClassType classType) {
        Mutability mutability = classType == this.topLevelType ? this.topLevelTypeMutability : Mutability.Default;
        ReferenceElement refElement2 = this.constructReferenceElement(classType, mutability);
        return new ClassType(refElement2, Nullability.Default, this.converter.getSettings());
    }

    private final ReferenceElement constructReferenceElement(PsiClassType classType, Mutability mutability) {
        List<Type> typeArgs = this.convertTypeArgs(classType);
        PsiClass psiClass = classType.resolve();
        if (psiClass != null) {
            String javaClassName = psiClass.getQualifiedName();
            Identifier identifier2 = UtilsKt.convertToKotlinAnalogIdentifier(this.converter, javaClassName, mutability);
            if (identifier2 != null) {
                Identifier it = identifier2;
                boolean bl = false;
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(it, typeArgs));
            }
            if (this.inAnnotationType && Intrinsics.areEqual((Object)javaClassName, (Object)"java.lang.Class")) {
                FqName fqName2 = new FqName("kotlin.reflect.KClass");
                Identifier identifier3 = Identifier.Companion.withNoPrototype$default(Identifier.Companion, fqName2.shortName().getIdentifier(), false, false, CollectionsKt.listOf((Object)fqName2), 6, null);
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(identifier3, typeArgs));
            }
        }
        if (classType instanceof PsiClassReferenceType) {
            return this.converter.convertCodeReferenceElement(((PsiClassReferenceType)classType).getReference(), false, typeArgs);
        }
        String string2 = classType.getClassName();
        if (string2 == null) {
            string2 = "";
        }
        return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string2, false, false, null, 14, null), typeArgs));
    }

    private final List<Type> convertTypeArgs(PsiClassType classType) {
        return classType.getParameterCount() == 0 ? this.createTypeArgsForRawTypeUsage(classType, Mutability.Default) : this.typeConverter.convertTypes(classType.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Type> createTypeArgsForRawTypeUsage(PsiClassType classType, Mutability mutability) {
        if (classType instanceof PsiClassReferenceType) {
            PsiClass targetClass;
            PsiElement psiElement2 = ((PsiClassReferenceType)classType).getReference().resolve();
            PsiClass psiClass = targetClass = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
            if (targetClass != null) {
                void $this$mapTo$iv$iv;
                PsiTypeParameter[] $this$map$iv = targetClass.getTypeParameters();
                boolean $i$f$map = false;
                PsiTypeParameter[] psiTypeParameterArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void item$iv$iv;
                    void var12_12 = item$iv$iv = $this$mapTo$iv$iv[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((StarProjectionType)ElementKt.assignNoPrototype((Element)new StarProjectionType()));
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Type visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        return wildcardType.isExtends() ? (Type)new OutProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getExtendsBound(), null, null, false, 14, null)) : (wildcardType.isSuper() ? (Type)new InProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getSuperBound(), null, null, false, 14, null)) : (Type)new StarProjectionType());
    }

    @NotNull
    public Type visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        return new VarArgType(TypeConverter.convertType$default(this.typeConverter, ellipsisType.getComponentType(), null, null, this.inAnnotationType, 6, null));
    }
}

