/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.ClassKind;
import org.jetbrains.kotlin.j2k.ConstructorConverter;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.OverloadReducer;
import org.jetbrains.kotlin.j2k.PropertyInfo;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ReferenceSearcherKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Class;
import org.jetbrains.kotlin.j2k.ast.ClassBody;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.Member;
import org.jetbrains.kotlin.j2k.ast.PrimaryConstructor;
import org.jetbrains.kotlin.j2k.ast.PrimaryConstructorSignature;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.SecondaryConstructor;
import org.jetbrains.kotlin.j2k.usageProcessing.AccessorToPropertyProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.MemberIntoObjectProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.ToObjectWithOnlyMethodsProcessing;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ8\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/j2k/ClassBodyConverter;", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "classKind", "Lorg/jetbrains/kotlin/j2k/ClassKind;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "(Lcom/intellij/psi/PsiClass;Lorg/jetbrains/kotlin/j2k/ClassKind;Lorg/jetbrains/kotlin/j2k/Converter;)V", "fieldsToDrop", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiField;", "convertBody", "Lorg/jetbrains/kotlin/j2k/ast/ClassBody;", "convertMember", "Lorg/jetbrains/kotlin/j2k/ast/Member;", "member", "Lcom/intellij/psi/PsiMember;", "constructorConverter", "Lorg/jetbrains/kotlin/j2k/ConstructorConverter;", "overloadReducer", "Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "memberToPropertyInfo", "", "Lorg/jetbrains/kotlin/j2k/PropertyInfo;", "shouldGenerateCompanionObject", "", "convertedMembers", "kotlin.j2k.old"})
public final class ClassBodyConverter {
    @NotNull
    private final PsiClass psiClass;
    @NotNull
    private final ClassKind classKind;
    @NotNull
    private final Converter converter;
    @NotNull
    private final HashSet<PsiField> fieldsToDrop;

    public ClassBodyConverter(@NotNull PsiClass psiClass, @NotNull ClassKind classKind, @NotNull Converter converter) {
        this.psiClass = psiClass;
        this.classKind = classKind;
        this.converter = converter;
        this.fieldsToDrop = new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassBody convertBody() {
        PsiElement[] $this$filterTo$iv$iv;
        Object propertyInfo;
        Map<PsiMember, PropertyInfo> memberToPropertyInfo = this.converter.getPropertyDetectionCache().get(this.psiClass);
        for (Map.Entry<PsiMember, PropertyInfo> entry : memberToPropertyInfo.entrySet()) {
            PsiMember member2 = entry.getKey();
            propertyInfo = entry.getValue();
            if (!(member2 instanceof PsiMethod)) continue;
            if (Intrinsics.areEqual((Object)member2, (Object)((PropertyInfo)propertyInfo).getGetMethod())) {
                this.converter.addUsageProcessing(new AccessorToPropertyProcessing((PsiMethod)member2, AccessorKind.GETTER, ((PropertyInfo)propertyInfo).getName()));
                continue;
            }
            this.converter.addUsageProcessing(new AccessorToPropertyProcessing((PsiMethod)member2, AccessorKind.SETTER, ((PropertyInfo)propertyInfo).getName()));
        }
        PsiMethod[] $this$filter$iv = this.psiClass.getMethods();
        boolean $i$f$filter = false;
        propertyInfo = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$filterTo = 0;
        int n = $this$filterTo$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!memberToPropertyInfo.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ReferenceSearcher referenceSearcher = this.converter.getReferenceSearcher();
        boolean bl = this.classKind.isOpen();
        Collection collection = (List)destination$iv$iv;
        OverloadReducer overloadReducer = new OverloadReducer(collection, bl, referenceSearcher);
        ConstructorConverter constructorConverter2 = this.psiClass.getName() != null && !this.classKind.isObject() ? new ConstructorConverter(this.psiClass, this.converter, (Function1<? super PsiField, PropertyInfo>)((Function1)new Function1<PsiField, PropertyInfo>(memberToPropertyInfo){
            final /* synthetic */ Map<PsiMember, PropertyInfo> $memberToPropertyInfo;
            {
                this.$memberToPropertyInfo = $memberToPropertyInfo;
                super(1);
            }

            @NotNull
            public final PropertyInfo invoke(@NotNull PsiField field2) {
                PropertyInfo propertyInfo = this.$memberToPropertyInfo.get(field2);
                Intrinsics.checkNotNull((Object)propertyInfo);
                return propertyInfo;
            }
        }), overloadReducer) : null;
        LinkedHashMap<PsiElement, Member> convertedMembers = new LinkedHashMap<PsiElement, Member>();
        for (PsiElement element3 : this.psiClass.getChildren()) {
            Member converted;
            if (!(element3 instanceof PsiMember) || element3 instanceof PsiAnnotationMethod || this.classKind.isObject() && UtilsKt.isConstructor((PsiMember)element3) || element3 instanceof PsiMethod && overloadReducer.shouldDropMethod((PsiMethod)element3) || (converted = this.convertMember((PsiMember)element3, constructorConverter2, overloadReducer, memberToPropertyInfo)) == null) continue;
            convertedMembers.put(element3, converted);
        }
        Iterable $this$forEach$iv = this.fieldsToDrop;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiField it = (PsiField)element$iv;
            boolean bl2 = false;
            convertedMembers.remove(it);
        }
        LBrace lBrace = (LBrace)ElementKt.assignPrototype$default(new LBrace(), this.psiClass.getLBrace(), null, 2, null);
        RBrace rBrace = (RBrace)ElementKt.assignPrototype$default(new RBrace(), this.psiClass.getRBrace(), null, 2, null);
        if (this.classKind.isObject()) {
            boolean bl3;
            Set psiMembers;
            block21: {
                psiMembers = convertedMembers.keySet();
                Iterable $this$all$iv = psiMembers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    Iterator bl2 = $this$all$iv.iterator();
                    while (bl2.hasNext()) {
                        Object element$iv = bl2.next();
                        PsiMember it = (PsiMember)element$iv;
                        boolean bl4 = false;
                        if (it instanceof PsiMethod) continue;
                        bl3 = false;
                        break block21;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                this.converter.addUsageProcessing(new ToObjectWithOnlyMethodsProcessing(this.psiClass));
            } else {
                for (PsiMember psiMember : psiMembers) {
                    if (psiMember.hasModifierProperty("private")) continue;
                    this.converter.addUsageProcessing(new MemberIntoObjectProcessing(psiMember, "INSTANCE"));
                }
            }
            return new ClassBody(null, null, null, CollectionsKt.toList((Iterable)convertedMembers.values()), CollectionsKt.emptyList(), lBrace, rBrace, this.classKind);
        }
        boolean useCompanionObject = this.shouldGenerateCompanionObject((Map<PsiMember, ? extends Member>)convertedMembers);
        ArrayList<Member> members2 = new ArrayList<Member>();
        ArrayList<Member> companionObjectMembers = new ArrayList<Member>();
        PrimaryConstructorSignature primaryConstructorSignature = null;
        PrimaryConstructor primaryConstructor = null;
        for (Map.Entry bl4 : ((Map)convertedMembers).entrySet()) {
            PsiMember psiMember = (PsiMember)bl4.getKey();
            Member member3 = (Member)bl4.getValue();
            if (member3 instanceof PrimaryConstructor) {
                boolean bl5;
                primaryConstructor = (PrimaryConstructor)member3;
                boolean bl6 = bl5 = primaryConstructorSignature == null;
                if (_Assertions.ENABLED && !bl5) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                primaryConstructorSignature = primaryConstructor.createSignature(this.converter);
                members2.add(primaryConstructor.getInitializer());
                continue;
            }
            if (useCompanionObject && !(member3 instanceof Class) && !(psiMember instanceof PsiEnumConstant) && psiMember.hasModifierProperty("static")) {
                companionObjectMembers.add(member3);
                if (psiMember.hasModifierProperty("private")) continue;
                this.converter.addUsageProcessing(new MemberIntoObjectProcessing(psiMember, SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.getIdentifier()));
                continue;
            }
            members2.add(member3);
        }
        if (primaryConstructor != null && primaryConstructorSignature != null && this.classKind != ClassKind.ANONYMOUS_OBJECT && primaryConstructorSignature.getAnnotations().isEmpty() && primaryConstructorSignature.getAccessModifier() == null && primaryConstructorSignature.getParameterList().getParameters().isEmpty()) {
            boolean bl7;
            block22: {
                Iterable $this$none$iv = members2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl7 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Member it = (Member)element$iv;
                        boolean bl8 = false;
                        if (!(it instanceof SecondaryConstructor)) continue;
                        bl7 = false;
                        break block22;
                    }
                    bl7 = true;
                }
            }
            if (bl7) {
                primaryConstructorSignature = null;
            }
        }
        ConstructorConverter constructorConverter3 = constructorConverter2;
        return new ClassBody(primaryConstructor, primaryConstructorSignature, constructorConverter3 != null ? constructorConverter3.getBaseClassParams() : null, (List<? extends Member>)members2, (List<? extends Member>)companionObjectMembers, lBrace, rBrace, this.classKind);
    }

    private final Member convertMember(PsiMember member2, ConstructorConverter constructorConverter2, OverloadReducer overloadReducer, Map<PsiMember, PropertyInfo> memberToPropertyInfo) {
        PsiMember psiMember = member2;
        if (psiMember instanceof PsiMethod) {
            PropertyInfo propertyInfo = memberToPropertyInfo.get(member2);
            if (propertyInfo != null) {
                PropertyInfo propertyInfo2 = propertyInfo;
                boolean bl = false;
                if (propertyInfo2.getField() != null) {
                    return null;
                }
                return Intrinsics.areEqual((Object)member2, (Object)propertyInfo2.getGetMethod()) || propertyInfo2.getGetMethod() == null ? this.converter.convertProperty(propertyInfo2, this.classKind) : null;
            }
            return this.converter.convertMethod((PsiMethod)member2, (Set<PsiField>)this.fieldsToDrop, constructorConverter2, overloadReducer, this.classKind);
        }
        if (psiMember instanceof PsiField) {
            PropertyInfo propertyInfo = memberToPropertyInfo.get(member2);
            Intrinsics.checkNotNull((Object)propertyInfo);
            PropertyInfo propertyInfo3 = propertyInfo;
            return this.converter.convertProperty(propertyInfo3, this.classKind);
        }
        if (psiMember instanceof PsiClass) {
            return this.converter.convertClass((PsiClass)member2);
        }
        if (psiMember instanceof PsiClassInitializer) {
            return this.converter.convertInitializer((PsiClassInitializer)member2);
        }
        throw new IllegalArgumentException("Unknown member: " + member2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldGenerateCompanionObject(Map<PsiMember, ? extends Member> convertedMembers) {
        boolean bl;
        block17: {
            boolean bl2;
            List nestedClasses;
            List companionObjectMembers;
            block15: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterTo$iv$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv2 = convertedMembers.keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv2;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    PsiMember it = (PsiMember)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!UtilsKt.isConstructor(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List members2 = (List)destination$iv$iv;
                Iterable $this$filter$iv3 = members2;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv3;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    PsiMember it = (PsiMember)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!(it instanceof PsiClass) && !(it instanceof PsiEnumConstant) && it.hasModifierProperty("static"))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                companionObjectMembers = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv = members2;
                boolean $i$f$filterIsInstance = false;
                destination$iv$iv2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiClass)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv3;
                boolean $i$f$filter3 = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiClass it = (PsiClass)element$iv$iv;
                    boolean bl5 = false;
                    if (!it.hasModifierProperty("static")) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                nestedClasses = (List)destination$iv$iv3;
                Iterable $this$all$iv = companionObjectMembers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiMember it = (PsiMember)element$iv;
                        boolean bl6 = false;
                        if (it instanceof PsiMethod && it.hasModifierProperty("private")) continue;
                        bl2 = false;
                        break block15;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                Iterable $this$any$iv = nestedClasses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl7;
                        block16: {
                            PsiClass nestedClass = (PsiClass)element$iv;
                            boolean bl8 = false;
                            Iterable $this$any$iv2 = companionObjectMembers;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    PsiMember it = (PsiMember)element$iv2;
                                    boolean bl9 = false;
                                    ReferenceSearcher referenceSearcher = this.converter.getReferenceSearcher();
                                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                                    boolean bl10 = !ReferenceSearcherKt.findMethodCalls(referenceSearcher, (PsiMethod)it, (PsiElement)nestedClass).isEmpty();
                                    if (!bl10) continue;
                                    bl7 = true;
                                    break block16;
                                }
                                bl7 = false;
                            }
                        }
                        if (!bl7) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

