/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.psi.fileTypes.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.idea.vfilefinder.FqNameKeyDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinJavaScriptMetaFileIndexKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinPartialPackageNamesIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00020\u0010H\u0002R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinPartialPackageNamesIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/Name;", "()V", "KEY", "Lcom/intellij/util/indexing/ID;", "getKEY", "()Lcom/intellij/util/indexing/ID;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getKeyDescriptor", "Lorg/jetbrains/kotlin/idea/vfilefinder/FqNameKeyDescriptor;", "getName", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "traceKeyHashToVirtualFileMapping", "toPackageFqName", "NullableNameExternalizer", "kotlin.base.indices"})
public final class KotlinPartialPackageNamesIndex
extends FileBasedIndexExtension<FqName, Name> {
    @NotNull
    public static final KotlinPartialPackageNamesIndex INSTANCE = new KotlinPartialPackageNamesIndex();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ID<FqName, Name> KEY;

    private KotlinPartialPackageNamesIndex() {
    }

    @NotNull
    public final ID<FqName, Name> getKEY() {
        return KEY;
    }

    @NotNull
    public ID<FqName, Name> getName() {
        return KEY;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FqNameKeyDescriptor getKeyDescriptor() {
        return FqNameKeyDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<Name> getValueExternalizer() {
        return NullableNameExternalizer.INSTANCE;
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{(FileType)JavaClassFileType.INSTANCE, (FileType)KotlinFileType.INSTANCE, KotlinJavaScriptMetaFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 4;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    private final FqName toPackageFqName(FileContent $this$toPackageFqName) {
        Object object;
        FileType fileType = $this$toPackageFqName.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE)) {
            PsiFile $this$safeAs$iv = $this$toPackageFqName.getPsiFile();
            boolean $i$f$safeAs = false;
            PsiFile psiFile2 = $this$safeAs$iv;
            if (!(psiFile2 instanceof KtFile)) {
                psiFile2 = null;
            }
            KtFile ktFile = (KtFile)psiFile2;
            object = ktFile != null ? ktFile.getPackageFqName() : null;
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
            ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = ClsKotlinBinaryClassCache.Companion.getInstance().getKotlinBinaryClassHeaderData($this$toPackageFqName.getFile(), $this$toPackageFqName.getContent());
            object = kotlinBinaryClassHeaderData != null ? kotlinBinaryClassHeaderData.getPackageNameWithFallback() : null;
        } else {
            object = Intrinsics.areEqual((Object)fileType, (Object)KotlinJavaScriptMetaFileType.INSTANCE) ? KotlinJavaScriptMetaFileIndexKt.fqNameFromJsMetadata($this$toPackageFqName) : null;
        }
        return object;
    }

    @NotNull
    public DataIndexer<FqName, Name, FileContent> getIndexer() {
        return KotlinPartialPackageNamesIndex::getIndexer$lambda$2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getIndexer$lambda$2(FileContent fileContent) {
        Map map2;
        try {
            void $this$associateByTo$iv$iv;
            FqName fqName2 = INSTANCE.toPackageFqName(fileContent);
            if (fqName2 == null) {
                return MapsKt.emptyMap();
            }
            FqName packageFqName = fqName2;
            Sequence $this$associateBy$iv = SequencesKt.filterNot((Sequence)SequencesKt.generateSequence((Object)packageFqName, (Function1)getIndexer.1.1.INSTANCE), (Function1)getIndexer.1.2.INSTANCE);
            boolean $i$f$associateBy = false;
            Sequence sequence2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                FqName fqName3 = (FqName)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                FqName it = (FqName)element$iv$iv;
                FqName fqName4 = it.parent();
                boolean bl2 = false;
                Name name2 = it.shortName();
                map3.put(fqName4, name2);
            }
            map2 = MapsKt.plus((Map)destination$iv$iv, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)packageFqName, null)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Error `(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")` while indexing file " + fileContent.getFileName() + " using " + INSTANCE.getName() + " index. Probably the file is broken.");
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinPartialPackageNamesIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        KEY = ID.create((String)KotlinPartialPackageNamesIndex.class.getCanonicalName());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinPartialPackageNamesIndex$NullableNameExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/name/Name;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "kotlin.base.indices"})
    private static final class NullableNameExternalizer
    implements DataExternalizer<Name> {
        @NotNull
        public static final NullableNameExternalizer INSTANCE = new NullableNameExternalizer();

        private NullableNameExternalizer() {
        }

        public void save(@NotNull DataOutput out, @Nullable Name value2) {
            out.writeBoolean(value2 == null);
            if (value2 != null) {
                IOUtil.writeUTF((DataOutput)out, (String)value2.asString());
            }
        }

        @Nullable
        public Name read(@NotNull DataInput input) {
            return input.readBoolean() ? null : Name.guessByFirstCharacter((String)IOUtil.readUTF((DataInput)input));
        }
    }
}

