/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H$\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0014J\u001f\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!H\u0084\bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinMetadataVersionIndexBase;", "T", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "classOfIndex", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "createBinaryVersion", "versionArray", "", "extraBoolean", "", "([ILjava/lang/Boolean;)Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "dependsOnFileContent", "getExtraBoolean", "version", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)Z", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getName", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "isExtraBooleanNeeded", "tryBlock", "", "inputData", "Lcom/intellij/util/indexing/FileContent;", "body", "Lkotlin/Function0;", "kotlin.project-configuration"})
public abstract class KotlinMetadataVersionIndexBase<T, V extends BinaryVersion>
extends ScalarIndexExtension<V> {
    @NotNull
    private final Class<T> classOfIndex;
    @NotNull
    private final Logger log;

    public KotlinMetadataVersionIndexBase(@NotNull Class<T> classOfIndex) {
        this.classOfIndex = classOfIndex;
        this.log = Logger.getInstance(this.classOfIndex);
    }

    @NotNull
    public ID<V, Void> getName() {
        return ID.create((String)this.classOfIndex.getCanonicalName());
    }

    @NotNull
    public KeyDescriptor<V> getKeyDescriptor() {
        return new KeyDescriptor<V>(this){
            final /* synthetic */ KotlinMetadataVersionIndexBase<T, V> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEqual(@NotNull V val1, @NotNull V val2) {
                return Intrinsics.areEqual(val1, val2);
            }

            public int getHashCode(@NotNull V value2) {
                return value2.hashCode();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public V read(@NotNull DataInput input) {
                void $this$mapTo$iv$iv;
                int size = DataInputOutputUtil.readINT((DataInput)input);
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(DataInputOutputUtil.readINT((DataInput)input));
                }
                int[] versionArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                Boolean extraBoolean = this.this$0.isExtraBooleanNeeded() ? Boolean.valueOf(DataInputOutputUtil.readINT((DataInput)input) == 1) : null;
                return this.this$0.createBinaryVersion(versionArray, extraBoolean);
            }

            public void save(@NotNull DataOutput output, @NotNull V value2) {
                int[] array2 = value2.toArray();
                DataInputOutputUtil.writeINT((DataOutput)output, (int)array2.length);
                for (int number2 : array2) {
                    DataInputOutputUtil.writeINT((DataOutput)output, (int)number2);
                }
                if (this.this$0.isExtraBooleanNeeded()) {
                    DataInputOutputUtil.writeINT((DataOutput)output, (int)(this.this$0.getExtraBoolean(value2) ? 1 : 0));
                }
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    protected abstract V createBinaryVersion(@NotNull int[] var1, @Nullable Boolean var2);

    protected boolean isExtraBooleanNeeded() {
        return false;
    }

    protected boolean getExtraBoolean(@NotNull V version2) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    protected final void tryBlock(@NotNull FileContent inputData, @NotNull Function0<Unit> body2) {
        boolean $i$f$tryBlock = false;
        try {
            body2.invoke();
        }
        catch (Throwable e) {
            this.log.warn("Could not index ABI version for file " + inputData.getFile() + ": " + e.getMessage());
        }
    }
}

