/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.versions.KotlinMetadataVersionIndexBase;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R*\u0010\u0004\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinJsMetadataVersionIndex;", "Lorg/jetbrains/kotlin/idea/versions/KotlinMetadataVersionIndexBase;", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "()V", "INDEXER", "Lcom/intellij/util/indexing/DataIndexer;", "kotlin.jvm.PlatformType", "Ljava/lang/Void;", "Lcom/intellij/util/indexing/FileContent;", "createBinaryVersion", "versionArray", "", "extraBoolean", "", "([ILjava/lang/Boolean;)Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "getIndexer", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getVersion", "", "kotlin.project-configuration"})
public final class KotlinJsMetadataVersionIndex
extends KotlinMetadataVersionIndexBase<KotlinJsMetadataVersionIndex, JsMetadataVersion> {
    @NotNull
    public static final KotlinJsMetadataVersionIndex INSTANCE = new KotlinJsMetadataVersionIndex();
    @NotNull
    private static final DataIndexer<JsMetadataVersion, Void, FileContent> INDEXER = KotlinJsMetadataVersionIndex::INDEXER$lambda$3;

    private KotlinJsMetadataVersionIndex() {
        super(KotlinJsMetadataVersionIndex.class);
    }

    @Override
    @NotNull
    protected JsMetadataVersion createBinaryVersion(@NotNull int[] versionArray, @Nullable Boolean extraBoolean) {
        return new JsMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @NotNull
    public DataIndexer<JsMetadataVersion, Void, FileContent> getIndexer() {
        return INDEXER;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter;
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JS");
        if (fileType == null) {
            inputFilter = KotlinJsMetadataVersionIndex::getInputFilter$lambda$0;
        } else {
            FileType[] fileTypeArray = new FileType[]{fileType};
            inputFilter = (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(fileTypeArray);
        }
        return inputFilter;
    }

    public int getVersion() {
        return 3;
    }

    private static final boolean getInputFilter$lambda$0(VirtualFile file2) {
        return Intrinsics.areEqual((Object)"js", (Object)file2.getExtension());
    }

    private static final Map INDEXER$lambda$3(FileContent inputData) {
        HashMap result2 = new HashMap();
        KotlinMetadataVersionIndexBase this_$iv = INSTANCE;
        boolean $i$f$tryBlock = false;
        try {
            boolean bl = false;
            ArrayList metadataList = new ArrayList();
            KotlinJavascriptMetadataUtils.parseMetadata((CharSequence)inputData.getContentAsText(), (List)metadataList);
            for (KotlinJavascriptMetadata metadata : metadataList) {
                JsMetadataVersion jsMetadataVersion;
                JsMetadataVersion it = jsMetadataVersion = metadata.getVersion();
                boolean bl2 = false;
                Object object = it.isCompatible() ? jsMetadataVersion : null;
                if (object == null) {
                    object = JsMetadataVersion.INVALID_VERSION;
                }
                JsMetadataVersion version2 = object;
                ((Map)result2).put(version2, null);
            }
        }
        catch (Throwable e$iv) {
            KotlinMetadataVersionIndexBase.access$getLog(this_$iv).warn("Could not index ABI version for file " + inputData.getFile() + ": " + e$iv.getMessage());
        }
        return result2;
    }
}

