/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/util/PsiPrecedences;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PRECEDENCE_OF_ATOMIC_EXPRESSION", "", "PRECEDENCE_OF_POSTFIX_EXPRESSION", "PRECEDENCE_OF_PREFIX_EXPRESSION", "precedence", "", "Lcom/intellij/psi/tree/IElementType;", "getPrecedence", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isTighter", "", "subject", "tighterThan", "kotlin.base.code-insight"})
public final class PsiPrecedences {
    @NotNull
    public static final PsiPrecedences INSTANCE = new PsiPrecedences();
    @NotNull
    private static final Logger LOG = Logger.getInstance(PsiPrecedences.class);
    @NotNull
    private static final Map<IElementType, Integer> precedence;
    private static final int PRECEDENCE_OF_ATOMIC_EXPRESSION;
    private static final int PRECEDENCE_OF_PREFIX_EXPRESSION;
    private static final int PRECEDENCE_OF_POSTFIX_EXPRESSION;

    private PsiPrecedences() {
    }

    public final int getPrecedence(@NotNull KtExpression expression2) {
        int n;
        KtExpression ktExpression = expression2;
        if ((ktExpression instanceof KtAnnotatedExpression ? true : ktExpression instanceof KtLabeledExpression) ? true : ktExpression instanceof KtPrefixExpression) {
            n = PRECEDENCE_OF_PREFIX_EXPRESSION;
        } else if (ktExpression instanceof KtPostfixExpression) {
            n = PRECEDENCE_OF_POSTFIX_EXPRESSION;
        } else if (ktExpression instanceof KtOperationExpression) {
            IElementType operation2 = ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
            Integer precedenceNumber = precedence.get(operation2);
            if (precedenceNumber == null) {
                LOG.error("No precedence for operation: " + operation2);
                n = precedence.size();
            } else {
                n = precedenceNumber;
            }
        } else {
            n = PRECEDENCE_OF_ATOMIC_EXPRESSION;
        }
        return n;
    }

    public final boolean isTighter(int subject, int tighterThan) {
        return subject < tighterThan;
    }

    static {
        HashMap builder2 = new HashMap();
        KotlinExpressionParsing.Precedence[] precedenceArray = KotlinExpressionParsing.Precedence.values();
        int n = precedenceArray.length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            KotlinExpressionParsing.Precedence record = precedenceArray[j];
            for (IElementType elementType : record.getOperations().getTypes()) {
                Integer n2 = i2;
                ((Map)builder2).put(elementType, n2);
            }
        }
        precedence = builder2;
        PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;
        PRECEDENCE_OF_PREFIX_EXPRESSION = KotlinExpressionParsing.Precedence.PREFIX.ordinal();
        PRECEDENCE_OF_POSTFIX_EXPRESSION = KotlinExpressionParsing.Precedence.POSTFIX.ordinal();
    }
}

