/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "kotlin.base.fe10.analysis"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $this$fuzzyReturnType) {
        KotlinType kotlinType = $this$fuzzyReturnType.getReturnType();
        return kotlinType != null ? FuzzyTypeUtils.toFuzzyType(kotlinType, $this$fuzzyReturnType.getTypeParameters()) : null;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $this$fuzzyExtensionReceiverType) {
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$fuzzyExtensionReceiverType.getExtensionReceiverParameter();
        return receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? FuzzyTypeUtils.toFuzzyType((KotlinType)receiverParameterDescriptor, $this$fuzzyExtensionReceiverType.getTypeParameters()) : null;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $this$makeNotNullable) {
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable((KotlinType)$this$makeNotNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNotNullable.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $this$makeNullable) {
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable((KotlinType)$this$makeNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNullable.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $this$nullability) {
        return TypeUtilsKt.nullability((KotlinType)$this$nullability.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $this$isAlmostEverything) {
        if ($this$isAlmostEverything.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $this$isAlmostEverything.getType().getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter2 = typeParameterDescriptor;
        if (!$this$isAlmostEverything.getFreeParameters().contains(typeParameter2)) {
            return false;
        }
        KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull((List)typeParameter2.getUpperBounds());
        return kotlinType != null ? TypeUtilsKt.isAnyOrNullableAny((KotlinType)kotlinType) : false;
    }

    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $this$presentationType) {
        if ($this$presentationType.getFreeParameters().isEmpty()) {
            return $this$presentationType.getType();
        }
        HashMap map2 = new HashMap();
        for (Pair pair : CollectionsKt.zip((Iterable)$this$presentationType.getType().getArguments(), (Iterable)$this$presentationType.getType().getConstructor().getParameters())) {
            TypeParameterDescriptor equalToFreeParameter;
            Object v0;
            TypeParameterDescriptor typeParameter2;
            block3: {
                TypeProjection argument2 = (TypeProjection)pair.component1();
                typeParameter2 = (TypeParameterDescriptor)pair.component2();
                if (argument2.getProjectionKind() != Variance.INVARIANT) continue;
                Iterable $this$firstOrNull$iv = $this$presentationType.getFreeParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!StrictEqualityTypeChecker.INSTANCE.strictEqualTypes((UnwrappedType)it.getDefaultType(), argument2.getType().unwrap())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((TypeParameterDescriptor)v0 == null) continue;
            ((Map)map2).put(equalToFreeParameter.getTypeConstructor(), TypeUtilsKt.createProjection((KotlinType)((KotlinType)typeParameter2.getDefaultType()), (Variance)Variance.INVARIANT, null));
        }
        TypeSubstitutor substitutor3 = TypeSubstitutor.create((Map)map2);
        KotlinType kotlinType = substitutor3.substitute($this$presentationType.getType(), Variance.INVARIANT);
        Intrinsics.checkNotNull((Object)kotlinType);
        return kotlinType;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $this$toFuzzyType, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        return new FuzzyType($this$toFuzzyType, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $this$hasConflictWith, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = freeParameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection substituted2;
                    TypeProjection substituted1;
                    TypeParameterDescriptor parameter2 = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    SimpleType type2 = parameter2.getDefaultType();
                    boolean bl3 = $this$hasConflictWith.get((KotlinType)type2) == null ? false : (other.get((KotlinType)type2) == null ? false : !StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(substituted1.getType().unwrap(), substituted2.getType().unwrap()) || substituted1.getProjectionKind() != substituted2.getProjectionKind());
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $this$combineIfNoConflicts, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        if (FuzzyTypeUtils.hasConflictWith($this$combineIfNoConflicts.getSubstitution(), other.getSubstitution(), freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor((TypeSubstitution)$this$combineIfNoConflicts.getSubstitution(), (TypeSubstitution)other.getSubstitution());
    }
}

