/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testng;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindMatcher;
import org.jetbrains.kotlin.idea.extensions.KotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.testng.TestNgKotlinTestFrameworkProvider;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinTestNgConfigurationProducer
extends TestNGConfigurationProducer {
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(TestNGConfigurationProducer.class);
    }

    protected boolean isConfiguredByElement(@NotNull TestNGConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull PsiElement element3) {
        KotlinTestFrameworkProvider.JavaEntity javaEntity = TestNgKotlinTestFrameworkProvider.INSTANCE.getJavaEntity(element3);
        if (javaEntity == null || !this.hasDetectedTestFramework(javaEntity.getTestClass())) {
            return false;
        }
        return configuration2.isConfiguredByElement((PsiElement)(javaEntity.getMethod() != null ? javaEntity.getMethod() : javaEntity.getTestClass()));
    }

    protected boolean setupConfigurationFromContext(@NotNull TestNGConfiguration configuration2, ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Project project = context2.getProject();
        PsiElement leaf = location2.getPsiElement();
        if (!RootKindMatcher.matches(leaf, RootKindFilter.projectAndLibrarySources)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        KtFile ktFile = (KtFile)leaf.getContainingFile();
        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)ktFile))) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaTestEntity testEntity = TestNgKotlinTestFrameworkProvider.INSTANCE.getJavaTestEntity(leaf, true);
        if (testEntity == null) {
            return false;
        }
        return this.configure(configuration2, location2, context2, project, testEntity.getTestClass(), testEntity.getTestMethod());
    }

    public void onFirstRun(final ConfigurationFromContext configuration2, @NotNull ConfigurationContext context2, @NotNull Runnable startRunnable) {
        KotlinTestFrameworkProvider.JavaTestEntity testEntity = TestNgKotlinTestFrameworkProvider.INSTANCE.getJavaTestEntity(configuration2.getSourceElement(), true);
        if (testEntity == null) {
            super.onFirstRun(configuration2, context2, startRunnable);
            return;
        }
        PsiMethod lightElement = testEntity.getTestMethod() != null ? testEntity.getTestMethod() : testEntity.getTestClass();
        ConfigurationFromContext delegate = new ConfigurationFromContext((PsiNamedElement)lightElement){
            final /* synthetic */ PsiNamedElement val$lightElement;
            {
                this.val$lightElement = psiNamedElement;
            }

            @NotNull
            public RunnerAndConfigurationSettings getConfigurationSettings() {
                return configuration2.getConfigurationSettings();
            }

            public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
                configuration2.setConfigurationSettings(configurationSettings);
            }

            @NotNull
            public PsiElement getSourceElement() {
                return this.val$lightElement;
            }
        };
        new AbstractInClassConfigurationProducer<TestNGConfiguration>(){

            @NotNull
            public ConfigurationFactory getConfigurationFactory() {
                return TestNGConfigurationType.getInstance();
            }
        }.onFirstRun(delegate, context2, startRunnable);
    }

    private boolean configure(TestNGConfiguration configuration2, Location location2, ConfigurationContext context2, Project project, @Nullable PsiClass delegate, @Nullable PsiMethod method) {
        if (delegate == null) {
            return false;
        }
        this.setupConfigurationModule(context2, (ModuleBasedConfiguration)configuration2);
        Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        configuration2.setClassConfiguration(delegate);
        if (method != null) {
            configuration2.setMethodConfiguration(PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
        }
        configuration2.restoreOriginalModule(originalModule);
        configuration2.setName(configuration2.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location2);
        return true;
    }
}

