/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration.framework;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinTestFramework;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0004J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0004J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0004J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001dH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0012\u0010\n\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinTestFramework;", "Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinTestFramework;", "()V", "disabledTestAnnotation", "", "getDisabledTestAnnotation", "()Ljava/lang/String;", "isSlow", "", "()Z", "markerClassFqn", "getMarkerClassFqn", "checkNameMatch", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqNames", "", "shortName", "isAnnotated", "element", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "fqName", "isIgnoredMethod", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isTestClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isTestMethod", "qualifiedName", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "responsibleFor", "kotlin.base.code-insight"})
public abstract class AbstractKotlinTestFramework
implements KotlinTestFramework {
    @NotNull
    public abstract String getMarkerClassFqn();

    @NotNull
    public abstract String getDisabledTestAnnotation();

    @Override
    public boolean isSlow() {
        return false;
    }

    @Override
    public boolean responsibleFor(@NotNull KtNamedDeclaration declaration2) {
        boolean bl;
        PsiClass markerPsiClass = JavaPsiFacade.getInstance((Project)declaration2.getProject()).findClass(this.getMarkerClassFqn(), declaration2.getResolveScope());
        if (markerPsiClass == null) {
            return false;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            bl = this.isTestClass((KtClassOrObject)declaration2);
        } else {
            if (ktNamedDeclaration instanceof KtNamedFunction) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
                if (ktClassOrObject == null) {
                    return false;
                }
                KtClassOrObject containingClass = ktClassOrObject;
                return this.isTestClass(containingClass) && this.isTestMethod((KtNamedFunction)declaration2);
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isTestClass(@NotNull KtClassOrObject declaration2) {
        boolean bl;
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)declaration2))) {
            bl = false;
        } else if (declaration2.isAnnotation()) {
            bl = false;
        } else if (!((Collection)declaration2.getAnnotations()).isEmpty()) {
            bl = true;
        } else {
            KtSuperTypeListEntry it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block14: {
                $this$any$iv = declaration2.getSuperTypeListEntries();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KtSuperTypeListEntry)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KtSuperTypeCallEntry)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                bl = true;
            } else {
                boolean bl4;
                block15: {
                    $this$any$iv = declaration2.getDeclarations();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KtDeclaration)element$iv;
                            boolean bl5 = false;
                            if (!(it instanceof KtNamedFunction && KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                            bl4 = true;
                            break block15;
                        }
                        bl4 = false;
                    }
                }
                bl = bl4;
            }
        }
        return bl;
    }

    @Override
    public boolean isTestMethod(@NotNull KtNamedFunction declaration2) {
        boolean bl;
        if (declaration2.isTopLevel()) {
            bl = false;
        } else if (declaration2.isLocal()) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = false;
        } else if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)declaration2))) {
            bl = false;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
            bl = !(ktClassOrObject != null ? KtPsiUtilKt.isObjectLiteral((KtClassOrObject)ktClassOrObject) : false);
        }
        return bl;
    }

    @Override
    public boolean isIgnoredMethod(@NotNull KtNamedFunction declaration2) {
        return this.isAnnotated((KtAnnotated)declaration2, "kotlin.test.Ignore") || this.isAnnotated((KtAnnotated)declaration2, this.getDisabledTestAnnotation());
    }

    @Override
    @Nullable
    public String qualifiedName(@NotNull KtNamedDeclaration declaration2) {
        String string2;
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            FqName fqName2 = ((KtClassOrObject)declaration2).getFqName();
            string2 = fqName2 != null ? fqName2.asString() : null;
        } else {
            KtClassOrObject ktClassOrObject;
            string2 = ktNamedDeclaration instanceof KtNamedFunction ? ((ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null) : null;
        }
        return string2;
    }

    protected final boolean checkNameMatch(@NotNull KtFile file2, @NotNull Set<String> fqNames, @NotNull String shortName) {
        for (KtImportDirective importDirective2 : file2.getImportDirectives()) {
            Object object;
            if (!importDirective2.isValidImport() || (object = importDirective2.getImportedFqName()) == null || (object = object.asString()) == null) continue;
            Object importedFqName = object;
            if (!importDirective2.isAllUnder()) {
                if (Intrinsics.areEqual((Object)importDirective2.getAliasName(), (Object)shortName) && fqNames.contains(importedFqName)) {
                    return true;
                }
                if (!fqNames.contains(importedFqName) || !StringsKt.endsWith$default((String)importedFqName, (String)("." + shortName), (boolean)false, (int)2, null)) continue;
                return true;
            }
            if (!fqNames.contains((String)importedFqName + "." + shortName)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull String fqName2) {
        return this.isAnnotated(element3, SetsKt.setOf((Object)fqName2));
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull Set<String> fqNames) {
        List annotationEntries = element3.getAnnotationEntries();
        if (annotationEntries.isEmpty()) {
            return false;
        }
        KtFile file2 = element3.getContainingKtFile();
        for (KtAnnotationEntry annotationEntry2 : annotationEntries) {
            Name shortName;
            if (annotationEntry2.getShortName() == null || !this.checkNameMatch(file2, fqNames, shortName.asString())) continue;
            return true;
        }
        return false;
    }
}

