/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsInObjectsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinJvmNameAnnotationIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinOverridableInternalMembersShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasByExpansionShortNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001a\u0010\u0014\u001a\u00020\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013\u001a&\u0010\u0017\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013\u001a0\u0010\u001a\u001a\u00020\r*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\r0!H\u0002\u001a,\u0010#\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f*\u00020$2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001a\u0010%\u001a\u00020&\"\b\b\u0000\u0010\u000e*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u000e0\u0011\u001a\u0016\u0010'\u001a\u0004\u0018\u00010\"*\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u000e\u0010+\u001a\u0004\u0018\u00010\u0002*\u00020,H\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"STRING_TEMPLATE_EMPTY_ARRAY", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "[Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "STRING_TEMPLATE_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "modifierList", "Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;", "getModifierList", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;)Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "indexExtensionInObject", "", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinCallableStubBase;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "indexInternals", "indexJvmNameAnnotation", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "indexTopLevelExtension", "indexTypeAliasExpansion", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "index", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "containingTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "occurrence", "Lkotlin/Function1;", "", "indexExtension", "Lorg/jetbrains/kotlin/idea/stubindex/KotlinExtensionsByReceiverTypeIndex;", "isDeclaredInObject", "", "stringFromAnnotation", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "stringTemplateExpression", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "kotlin.core"})
public final class IndexUtilsKt {
    @NotNull
    private static final KtStringTemplateExpression[] STRING_TEMPLATE_EMPTY_ARRAY;
    @NotNull
    private static final TokenSet STRING_TEMPLATE_TYPES;

    public static final <TDeclaration extends KtCallableDeclaration> void indexTopLevelExtension(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        IndexUtilsKt.indexExtension(KotlinTopLevelExtensionsByReceiverTypeIndex.INSTANCE, stub, sink);
    }

    public static final <TDeclaration extends KtCallableDeclaration> void indexExtensionInObject(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        IndexUtilsKt.indexExtension(KotlinExtensionsInObjectsByReceiverTypeIndex.INSTANCE, stub, sink);
    }

    private static final <TDeclaration extends KtCallableDeclaration> void indexExtension(KotlinExtensionsByReceiverTypeIndex $this$indexExtension, KotlinCallableStubBase<TDeclaration> stub, IndexSink sink) {
        block2: {
            if (!stub.isExtension()) {
                return;
            }
            KtCallableDeclaration declaration2 = (KtCallableDeclaration)stub.getPsi();
            String string2 = declaration2.getName();
            if (string2 == null) {
                return;
            }
            String callableName = string2;
            KtTypeReference ktTypeReference = declaration2.getReceiverTypeReference();
            Intrinsics.checkNotNull((Object)ktTypeReference);
            KtTypeReference containingTypeReference = ktTypeReference;
            KtTypeElement ktTypeElement = containingTypeReference.getTypeElement();
            if (ktTypeElement == null) break block2;
            IndexUtilsKt.index(ktTypeElement, (KtTypeParameterListOwner)declaration2, containingTypeReference, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(sink, $this$indexExtension, callableName){
                final /* synthetic */ IndexSink $sink;
                final /* synthetic */ KotlinExtensionsByReceiverTypeIndex $this_indexExtension;
                final /* synthetic */ String $callableName;
                {
                    this.$sink = $sink;
                    this.$this_indexExtension = $receiver;
                    this.$callableName = $callableName;
                    super(1);
                }

                public final void invoke(@NotNull String typeName) {
                    this.$sink.occurrence(this.$this_indexExtension.getKey(), (Object)this.$this_indexExtension.buildKey(typeName, this.$callableName));
                }
            }));
        }
    }

    public static final void indexTypeAliasExpansion(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        KtTypeAlias declaration2 = (KtTypeAlias)stub.getPsi();
        KtTypeReference ktTypeReference = declaration2.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference2.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement = ktTypeElement;
        IndexUtilsKt.index(typeElement, (KtTypeParameterListOwner)declaration2, typeReference2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(sink){
            final /* synthetic */ IndexSink $sink;
            {
                this.$sink = $sink;
                super(1);
            }

            public final void invoke(@NotNull String typeName) {
                this.$sink.occurrence(KotlinTypeAliasByExpansionShortNameIndex.INSTANCE.getKEY(), (Object)typeName);
            }
        }));
    }

    private static final void index(KtTypeElement $this$index, KtTypeParameterListOwner declaration2, KtTypeReference containingTypeReference, Function1<? super String, Unit> occurrence) {
        IndexUtilsKt.index$indexWithVisited($this$index, declaration2, containingTypeReference, new LinkedHashSet(), occurrence);
    }

    public static final void indexInternals(@NotNull KotlinCallableStubBase<?> stub, @NotNull IndexSink sink) {
        String string2 = stub.getName();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        KotlinModifierListStub kotlinModifierListStub = IndexUtilsKt.getModifierList((KotlinStubWithFqName)stub);
        if (kotlinModifierListStub == null) {
            return;
        }
        KotlinModifierListStub modifierListStub = kotlinModifierListStub;
        if (!modifierListStub.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return;
        }
        if (stub.isTopLevel()) {
            return;
        }
        if (modifierListStub.hasModifier(KtTokens.OPEN_KEYWORD) || modifierListStub.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            sink.occurrence(KotlinOverridableInternalMembersShortNameIndex.INSTANCE.getKey(), (Object)name2);
        }
    }

    private static final KtStringTemplateExpression stringTemplateExpression(ValueArgument $this$stringTemplateExpression) {
        KtExpression ktExpression;
        if ($this$stringTemplateExpression instanceof StubBasedPsiElement && (ktExpression = ((StubBasedPsiElement)$this$stringTemplateExpression).getStub()) != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            Object[] constantExpressions = (KtStringTemplateExpression[])it.getChildrenByType(STRING_TEMPLATE_TYPES, (PsiElement[])STRING_TEMPLATE_EMPTY_ARRAY);
            return (KtStringTemplateExpression)ArraysKt.firstOrNull((Object[])constantExpressions);
        }
        ktExpression = $this$stringTemplateExpression.getArgumentExpression();
        return ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String stringFromAnnotation(JvmFileClassUtil $this$stringFromAnnotation, KtAnnotationEntry annotation) {
        KtStringTemplateEntry ktStringTemplateEntry;
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)annotation.getValueArguments());
        if (valueArgument == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry2 = IndexUtilsKt.stringTemplateExpression(valueArgument);
        KtStringTemplateEntry ktStringTemplateEntry3 = ktStringTemplateEntry = ktStringTemplateEntry2;
        KtStringTemplateEntry ktStringTemplateEntry4 = ktStringTemplateEntry3;
        if (ktStringTemplateEntry3 == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry5 = ktStringTemplateEntry4.getEntries();
        ktStringTemplateEntry4 = ktStringTemplateEntry5;
        if (ktStringTemplateEntry5 == null) return null;
        KtStringTemplateEntry ktStringTemplateEntry6 = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])ktStringTemplateEntry4);
        ktStringTemplateEntry4 = ktStringTemplateEntry6;
        if (ktStringTemplateEntry6 == null) return null;
        KtStringTemplateEntry $this$safeAs$iv = ktStringTemplateEntry4;
        boolean $i$f$safeAs = false;
        KtStringTemplateEntry ktStringTemplateEntry7 = $this$safeAs$iv;
        if (!(ktStringTemplateEntry7 instanceof KtLiteralStringTemplateEntry)) {
            ktStringTemplateEntry7 = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry7;
        ktStringTemplateEntry4 = ktLiteralStringTemplateEntry;
        if (ktLiteralStringTemplateEntry == null) return null;
        String string2 = ktStringTemplateEntry4.getText();
        return string2;
    }

    public static final void indexJvmNameAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        String string2;
        if (!Intrinsics.areEqual((Object)stub.getShortName(), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT())) {
            return;
        }
        String string3 = IndexUtilsKt.stringFromAnnotation(JvmFileClassUtil.INSTANCE, (KtAnnotationEntry)stub.getPsi());
        if (string3 == null) {
            return;
        }
        String jvmName = string3;
        StubElement grandParentStub = stub.getParentStub().getParentStub();
        if (grandParentStub instanceof KotlinFileStub) {
            string2 = ((KtFile)((KotlinFileStub)grandParentStub).getPsi()).getName();
        } else if (grandParentStub instanceof NamedStub) {
            string2 = ((NamedStub)grandParentStub).getName();
            if (string2 == null) {
                string2 = "";
            }
        } else if (grandParentStub instanceof KotlinPropertyAccessorStub) {
            StubElement $this$safeAs$iv = ((KotlinPropertyAccessorStub)grandParentStub).getParentStub();
            boolean $i$f$safeAs = false;
            StubElement stubElement = $this$safeAs$iv;
            if (!(stubElement instanceof KotlinPropertyStub)) {
                stubElement = null;
            }
            if ((string2 = (KotlinPropertyStub)stubElement) == null || (string2 = string2.getName()) == null) {
                string2 = "";
            }
        } else {
            return;
        }
        String annotatedElementName = string2;
        if (!Intrinsics.areEqual((Object)annotatedElementName, (Object)jvmName)) {
            sink.occurrence(KotlinJvmNameAnnotationIndex.INSTANCE.getKey(), (Object)jvmName);
        }
    }

    private static final KotlinModifierListStub getModifierList(KotlinStubWithFqName<?> $this$modifierList) {
        return (KotlinModifierListStub)$this$modifierList.findChildStubByType((IStubElementType)KtStubElementTypes.MODIFIER_LIST);
    }

    public static final <TDeclaration extends KtCallableDeclaration> boolean isDeclaredInObject(@NotNull KotlinCallableStubBase<TDeclaration> $this$isDeclaredInObject) {
        if ($this$isDeclaredInObject.isTopLevel()) {
            return false;
        }
        StubElement stubElement = $this$isDeclaredInObject.getParentStub();
        PsiElement containingDeclaration2 = stubElement != null && (stubElement = stubElement.getParentStub()) != null ? stubElement.getPsi() : null;
        return containingDeclaration2 instanceof KtObjectDeclaration && !((KtObjectDeclaration)containingDeclaration2).isObjectLiteral();
    }

    private static final void index$indexWithVisited(KtTypeElement $this$index_u24indexWithVisited, KtTypeParameterListOwner declaration2, KtTypeReference containingTypeReference, Set<KtTypeElement> visited, Function1<? super String, Unit> occurrence) {
        if (visited.contains($this$index_u24indexWithVisited)) {
            return;
        }
        visited.add($this$index_u24indexWithVisited);
        KtTypeElement ktTypeElement = $this$index_u24indexWithVisited;
        if (ktTypeElement instanceof KtUserType) {
            Object v1;
            Object it;
            String referenceName;
            block20: {
                String string2 = ((KtUserType)$this$index_u24indexWithVisited).getReferencedName();
                if (string2 == null) {
                    return;
                }
                referenceName = string2;
                Iterable $this$firstOrNull$iv = declaration2.getTypeParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (KtTypeParameter)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)referenceName)) continue;
                    v1 = element$iv;
                    break block20;
                }
                v1 = null;
            }
            KtTypeParameter typeParameter2 = v1;
            if (typeParameter2 != null) {
                KtTypeReference bound2 = typeParameter2.getExtendsBound();
                if (bound2 != null) {
                    KtTypeElement ktTypeElement2 = bound2.getTypeElement();
                    if (ktTypeElement2 != null) {
                        IndexUtilsKt.index$indexWithVisited(ktTypeElement2, declaration2, containingTypeReference, visited, occurrence);
                    }
                } else {
                    occurrence.invoke((Object)"Any");
                }
                return;
            }
            occurrence.invoke((Object)referenceName);
            Iterable $this$forEach$iv = KotlinPsiHeuristics.unwrapImportAlias((KtUserType)$this$index_u24indexWithVisited, referenceName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                occurrence.invoke(it);
            }
        } else if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement3 = ((KtNullableType)$this$index_u24indexWithVisited).getInnerType();
            if (ktTypeElement3 != null) {
                IndexUtilsKt.index$indexWithVisited(ktTypeElement3, declaration2, containingTypeReference, visited, occurrence);
            }
        } else if (ktTypeElement instanceof KtFunctionType) {
            int arity = ((KtFunctionType)$this$index_u24indexWithVisited).getParameters().size() + (((KtFunctionType)$this$index_u24indexWithVisited).getReceiverTypeReference() != null ? 1 : 0);
            KtModifierList ktModifierList = containingTypeReference.getModifierList();
            String suspendPrefix = (ktModifierList != null ? ktModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD) : false) ? "Suspend" : "";
            occurrence.invoke((Object)(suspendPrefix + "Function" + arity));
        } else if (ktTypeElement instanceof KtDynamicType) {
            occurrence.invoke((Object)"Any");
        } else if (ktTypeElement instanceof KtIntersectionType) {
            KtTypeReference ktTypeReference = ((KtIntersectionType)$this$index_u24indexWithVisited).getLeftTypeRef();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTypeElement()) != null) {
                IndexUtilsKt.index$indexWithVisited((KtTypeElement)ktTypeReference, declaration2, containingTypeReference, visited, occurrence);
            }
        } else {
            throw new IllegalStateException(("Unsupported type: " + $this$index_u24indexWithVisited).toString());
        }
    }

    static {
        boolean $i$f$emptyArray = false;
        STRING_TEMPLATE_EMPTY_ARRAY = new KtStringTemplateExpression[0];
        IElementType[] iElementTypeArray = new IElementType[]{(IElementType)KtStubElementTypes.STRING_TEMPLATE};
        STRING_TEMPLATE_TYPES = TokenSet.create((IElementType[])iElementTypeArray);
    }
}

