/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import java.awt.Color;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceDereferenceUsage;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsageCellRenderer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u00020\n*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsageCellRenderer;", "Lcom/intellij/slicer/SliceUsageCellRendererBase;", "()V", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "containerSuffix", "", "sliceUsage", "Lcom/intellij/slicer/SliceUsage;", "customizeCellRendererFor", "", "renderPropertyOrAccessor", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessorSuffix", "TruncatedValueParametersHandler", "kotlin.idea"})
public final class KotlinSliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    @NotNull
    public static final KotlinSliceUsageCellRenderer INSTANCE = new KotlinSliceUsageCellRenderer();
    @NotNull
    private static final DescriptorRenderer descriptorRenderer = DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.withOptions((Function1)descriptorRenderer.1.INSTANCE);

    private KotlinSliceUsageCellRenderer() {
    }

    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        block5: {
            if (!(sliceUsage instanceof KotlinSliceUsage)) {
                return;
            }
            boolean isDereference = sliceUsage instanceof KotlinSliceDereferenceUsage;
            TextChunk[] textChunkArray = sliceUsage.getText();
            int n = textChunkArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                TextChunk textChunk = textChunkArray[j];
                SimpleTextAttributes attributes2 = textChunk.getSimpleAttributesIgnoreBackground();
                if (isDereference) {
                    attributes2 = attributes2.derive(attributes2.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes2.getBgColor(), attributes2.getWaveColor());
                }
                if (attributes2.getFontStyle() == 1) {
                    attributes2 = attributes2.derive(attributes2.getStyle() | 0x10, null, null, null);
                }
                this.append(textChunk.getText(), attributes2);
                if (i2 != 0) continue;
                this.append(FontUtil.spaceAndThinSpace());
            }
            for (KotlinSliceAnalysisMode.Behaviour behaviour : CollectionsKt.reversed((Iterable)((KotlinSliceUsage)sliceUsage).getMode().getBehaviourStack())) {
                this.append(behaviour.getSlicePresentationPrefix(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            String string2 = this.containerSuffix(sliceUsage);
            if (string2 == null) break block5;
            String it = string2;
            boolean bl = false;
            INSTANCE.append(" ");
            INSTANCE.append(it, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public final String containerSuffix(@NotNull SliceUsage sliceUsage) {
        DeclarationDescriptor declarationDescriptor;
        StringBuilder stringBuilder;
        Object v2;
        KtDeclaration declaration2;
        PsiElement element3;
        block10: {
            PsiElement psiElement2 = sliceUsage.getElement();
            if (psiElement2 == null) {
                return null;
            }
            element3 = psiElement2;
            declaration2 = null;
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                boolean bl2 = it instanceof KtClass || it instanceof KtObjectDeclaration && !((KtObjectDeclaration)it).isObjectLiteral() || it instanceof KtNamedFunction && !((KtNamedFunction)it).isLocal() || it instanceof KtProperty && !((KtProperty)it).isLocal() || it instanceof KtPropertyAccessor || it instanceof KtConstructor;
                if (!bl2) continue;
                v2 = element$iv;
                break block10;
            }
            v2 = null;
        }
        Object var5_12 = v2;
        KtDeclaration ktDeclaration = var5_12 instanceof KtDeclaration ? (KtDeclaration)var5_12 : null;
        if (ktDeclaration == null) {
            return null;
        }
        declaration2 = ktDeclaration;
        if (declaration2 instanceof KtPrimaryConstructor && element3 instanceof KtParameter && ((KtParameter)element3).hasValOrVar()) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)declaration2);
            Intrinsics.checkNotNull((Object)ktClassOrObject);
            declaration2 = ktClassOrObject;
        }
        StringBuilder $this$containerSuffix_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object[] $i$f$firstOrNull = new Object[]{""};
        $this$containerSuffix_u24lambda_u242.append(KotlinBundle.message("slicer.text.in", $i$f$firstOrNull));
        $this$containerSuffix_u24lambda_u242.append(" ");
        DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default(declaration2, null, 1, null);
        if (!(DescriptorUtilsKt.isExtension((DeclarationDescriptor)descriptor2) || descriptor2 instanceof ConstructorDescriptor || DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)descriptor2))) {
            ClassifierDescriptor containingClassifier;
            Iterator iterator = descriptor2.getContainingDeclaration();
            ClassifierDescriptor classifierDescriptor = containingClassifier = iterator instanceof ClassifierDescriptor ? (ClassifierDescriptor)iterator : null;
            if (containingClassifier != null) {
                $this$containerSuffix_u24lambda_u242.append(descriptorRenderer.render((DeclarationDescriptor)containingClassifier));
                $this$containerSuffix_u24lambda_u242.append(".");
            }
        }
        if ((declarationDescriptor = descriptor2) instanceof PropertyDescriptor) {
            KotlinSliceUsageCellRenderer.renderPropertyOrAccessor$default(INSTANCE, $this$containerSuffix_u24lambda_u242, (PropertyDescriptor)descriptor2, null, 2, null);
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property2 = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            INSTANCE.renderPropertyOrAccessor($this$containerSuffix_u24lambda_u242, property2, descriptor2 instanceof PropertyGetterDescriptor ? ".get" : ".set");
        } else {
            $this$containerSuffix_u24lambda_u242.append(descriptorRenderer.render(descriptor2));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void renderPropertyOrAccessor(StringBuilder $this$renderPropertyOrAccessor, PropertyDescriptor propertyDescriptor, String accessorSuffix) {
        KotlinType receiverType2;
        $this$renderPropertyOrAccessor.append(RenderingUtilsKt.render((Name)propertyDescriptor.getName()));
        $this$renderPropertyOrAccessor.append(accessorSuffix);
        ReceiverParameterDescriptor receiverParameterDescriptor = propertyDescriptor.getExtensionReceiverParameter();
        Object object = receiverType2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        if (receiverType2 != null) {
            $this$renderPropertyOrAccessor.append(" on ");
            $this$renderPropertyOrAccessor.append(descriptorRenderer.renderType(receiverType2));
        }
    }

    static /* synthetic */ void renderPropertyOrAccessor$default(KotlinSliceUsageCellRenderer kotlinSliceUsageCellRenderer, StringBuilder stringBuilder, PropertyDescriptor propertyDescriptor, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        kotlinSliceUsageCellRenderer.renderPropertyOrAccessor(stringBuilder, propertyDescriptor, string2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J,\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u001c\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsageCellRenderer$TruncatedValueParametersHandler;", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;", "maxParameters", "", "(I)V", "truncateLength", "appendAfterValueParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterIndex", "parameterCount", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendAfterValueParameters", "appendBeforeValueParameter", "appendBeforeValueParameters", "kotlin.idea"})
    private static final class TruncatedValueParametersHandler
    implements DescriptorRenderer.ValueParametersHandler {
        private final int maxParameters;
        private int truncateLength;

        public TruncatedValueParametersHandler(int maxParameters) {
            this.maxParameters = maxParameters;
            this.truncateLength = -1;
        }

        public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder2) {
            builder2.append("(");
        }

        public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder2) {
            if (parameterCount > this.maxParameters) {
                builder2.setLength(this.truncateLength);
                builder2.append(",\u2026");
            }
            builder2.append(")");
        }

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter2, int parameterIndex2, int parameterCount, @NotNull StringBuilder builder2) {
        }

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter2, int parameterIndex2, int parameterCount, @NotNull StringBuilder builder2) {
            if (parameterIndex2 < parameterCount - 1) {
                if (parameterIndex2 == this.maxParameters - 1) {
                    this.truncateLength = builder2.length();
                } else {
                    builder2.append(", ");
                }
            }
        }
    }
}

