/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Color;
import java.awt.Container;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexVerifierActionKt;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinReferenceIndexBundle;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "kotlin.compiler-reference-index"})
public final class KotlinCompilerReferenceIndexVerifierAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinCompilerReferenceIndexVerifierAction() {
        super(KotlinReferenceIndexBundle.INSTANCE.lazyMessage("action.KotlinCompilerReferenceIndexVerifierAction.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            boolean bl = false;
            KotlinCompilerReferenceIndexVerifierActionKt.access$showProjectNotFound();
            return;
        }
        Project project2 = project;
        PsiElement psiElement2 = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        if (psiElement2 == null) {
            boolean bl = false;
            KotlinCompilerReferenceIndexVerifierActionKt.access$showPsiElementNotFound(project2);
            return;
        }
        PsiElement element3 = psiElement2;
        SmartPsiElementPointer pointToElement = PsiUtilsKt.createSmartPointer((PsiElement)element3);
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$2(pointToElement)).finishOnUiThread(ModalityState.current(), arg_0 -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$3((Function1)new Function1<Companion.CompilerReferenceData, Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Companion.CompilerReferenceData context2) {
                void constraints$iv;
                Color bgcolor$iv;
                LayoutBuilder builder$iv;
                if (context2 == null) {
                    return;
                }
                String string2 = KotlinReferenceIndexBundle.INSTANCE.message("dialog.title.compiler.index.status", new Object[0]);
                LCFlags[] lCFlagsArray = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$invoke_u24lambda_u240 = builder$iv = LayoutImplKt.createLayoutBuilder();
                boolean bl = false;
                KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField((RowBuilder)$this$invoke_u24lambda_u240, "Element class:", context2.getElementText());
                $this$invoke_u24lambda_u240.titledRow("PsiSearchHelper#getCodeUsageScope", (Function1)new Function1<Row, Unit>(context2){
                    final /* synthetic */ Companion.CompilerReferenceData $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$titledRow) {
                        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$titledRow), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this.$context){
                            final /* synthetic */ Companion.CompilerReferenceData $context;
                            {
                                this.$context = $context;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                KotlinCompilerReferenceIndexVerifierActionKt.access$immutableScrollableTextArea($this$row, this.$context.getCodeUsageScopeText());
                            }
                        }), (int)3, null);
                    }
                });
                $this$invoke_u24lambda_u240.titledRow("Use Scope vs. Code Usage Scope", (Function1)new Function1<Row, Unit>(context2){
                    final /* synthetic */ Companion.CompilerReferenceData $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$titledRow) {
                        KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField((RowBuilder)$this$titledRow, "Number of Kotlin files:", this.$context.getNumberOfKotlinFilesInUseScope() + "/" + this.$context.getNumberOfKotlinFilesInCodeUsageScope());
                        KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField((RowBuilder)$this$titledRow, "Number of Java files:", this.$context.getNumberOfJavaFilesInUseScope() + "/" + this.$context.getNumberOfJavaFilesInCodeUsageScope());
                    }
                });
                DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
                Color color = bgcolor$iv = Registry.getColor((String)"ui.kotlin.ui.dsl.deprecated.panel.color", null);
                if (color != null) {
                    Color it$iv = color;
                    boolean bl2 = false;
                    panel$iv.setBackground(it$iv);
                }
                builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
                LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
                DialogPanel dialogPanel = panel$iv;
                ComponentsKt.dialog$default((String)string2, (JComponent)((JComponent)dialogPanel), (boolean)true, null, (boolean)false, (Project)this.$project, null, null, null, null, null, (int)2008, null).show();
            }
        }, arg_0)).coalesceBy(objectArray).inSmartMode(project2).expireWhen(() -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$4(pointToElement, project2)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Companion.CompilerReferenceData actionPerformed$lambda$2(SmartPsiElementPointer $pointToElement) {
        PsiElement psiElement2 = $pointToElement.getElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement3 = psiElement2;
        SearchScope codeUsageScope = KotlinScopeUtils.codeUsageScope(psiElement3);
        SearchScope useScope = KotlinScopeUtils.useScope(psiElement3);
        String string2 = Reflection.getOrCreateKotlinClass(psiElement3.getClass()).getSimpleName();
        PsiElement $this$safeAs$iv = psiElement3;
        boolean $i$f$safeAs = false;
        PsiElement psiElement4 = $this$safeAs$iv;
        if (!(psiElement4 instanceof PsiNamedElement)) {
            psiElement4 = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement4;
        return new Companion.CompilerReferenceData(string2 + ":" + (psiNamedElement != null ? psiNamedElement.getName() : null), SearchUtilKt.toHumanReadableString(codeUsageScope), KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(codeUsageScope, (FileType)KotlinFileType.INSTANCE), KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(codeUsageScope, (FileType)JavaFileType.INSTANCE), KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(useScope, (FileType)KotlinFileType.INSTANCE), KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(useScope, (FileType)JavaFileType.INSTANCE));
    }

    private static final void actionPerformed$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean actionPerformed$lambda$4(SmartPsiElementPointer $pointToElement, Project $project) {
        return $pointToElement.getElement() == null || $project.isDisposed();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion;", "", "()V", "countOfFileType", "", "Lcom/intellij/psi/search/SearchScope;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "CompilerReferenceData", "kotlin.compiler-reference-index"})
    public static final class Companion {
        private Companion() {
        }

        private final String countOfFileType(SearchScope $this$countOfFileType, FileType fileType) {
            Object object;
            block5: {
                block4: {
                    SearchScope $this$safeAs$iv = $this$countOfFileType;
                    boolean $i$f$safeAs = false;
                    SearchScope searchScope2 = $this$safeAs$iv;
                    if (!(searchScope2 instanceof GlobalSearchScope)) {
                        searchScope2 = null;
                    }
                    if ((object = (GlobalSearchScope)searchScope2) == null) break block4;
                    GlobalSearchScope it = object;
                    boolean bl = false;
                    String string2 = String.valueOf(FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)it).size());
                    object = string2;
                    if (string2 != null) break block5;
                }
                object = "Non global scope";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion$CompilerReferenceData;", "", "elementText", "", "codeUsageScopeText", "numberOfKotlinFilesInCodeUsageScope", "numberOfJavaFilesInCodeUsageScope", "numberOfKotlinFilesInUseScope", "numberOfJavaFilesInUseScope", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCodeUsageScopeText", "()Ljava/lang/String;", "getElementText", "getNumberOfJavaFilesInCodeUsageScope", "getNumberOfJavaFilesInUseScope", "getNumberOfKotlinFilesInCodeUsageScope", "getNumberOfKotlinFilesInUseScope", "kotlin.compiler-reference-index"})
        private static final class CompilerReferenceData {
            @NotNull
            private final String elementText;
            @NotNull
            private final String codeUsageScopeText;
            @NotNull
            private final String numberOfKotlinFilesInCodeUsageScope;
            @NotNull
            private final String numberOfJavaFilesInCodeUsageScope;
            @NotNull
            private final String numberOfKotlinFilesInUseScope;
            @NotNull
            private final String numberOfJavaFilesInUseScope;

            public CompilerReferenceData(@NotNull String elementText, @NotNull String codeUsageScopeText, @NotNull String numberOfKotlinFilesInCodeUsageScope, @NotNull String numberOfJavaFilesInCodeUsageScope, @NotNull String numberOfKotlinFilesInUseScope, @NotNull String numberOfJavaFilesInUseScope) {
                this.elementText = elementText;
                this.codeUsageScopeText = codeUsageScopeText;
                this.numberOfKotlinFilesInCodeUsageScope = numberOfKotlinFilesInCodeUsageScope;
                this.numberOfJavaFilesInCodeUsageScope = numberOfJavaFilesInCodeUsageScope;
                this.numberOfKotlinFilesInUseScope = numberOfKotlinFilesInUseScope;
                this.numberOfJavaFilesInUseScope = numberOfJavaFilesInUseScope;
            }

            @NotNull
            public final String getElementText() {
                return this.elementText;
            }

            @NotNull
            public final String getCodeUsageScopeText() {
                return this.codeUsageScopeText;
            }

            @NotNull
            public final String getNumberOfKotlinFilesInCodeUsageScope() {
                return this.numberOfKotlinFilesInCodeUsageScope;
            }

            @NotNull
            public final String getNumberOfJavaFilesInCodeUsageScope() {
                return this.numberOfJavaFilesInCodeUsageScope;
            }

            @NotNull
            public final String getNumberOfKotlinFilesInUseScope() {
                return this.numberOfKotlinFilesInUseScope;
            }

            @NotNull
            public final String getNumberOfJavaFilesInUseScope() {
                return this.numberOfJavaFilesInUseScope;
            }
        }
    }
}

