/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0007\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u000b*\u00020\u0010\u001a\u0012\u0010\u0012\u001a\u00020\u000b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010\u001a\f\u0010\u0015\u001a\u00020\r*\u00020\u0016H\u0007\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0010H\u0007\u001a!\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001a0\u0007H\u0082\b\u001a.\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010$\u001a\u0004\u0018\u00010%\u001a\n\u0010&\u001a\u00020\u0003*\u00020'\u001a\u0015\u0010(\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010)\u001a\u00020\rH\u0087\u0002\u001a\f\u0010*\u001a\u00020\r*\u00020\u000eH\u0007\u001a\n\u0010+\u001a\u00020!*\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"parenthesisRegex", "Lkotlin/text/Regex;", "findScriptsWithUsages", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtFile;", "isOnlyKotlinSearch", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "codeUsageScopeRestrictedToKotlinSources", "Lcom/intellij/psi/PsiElement;", "codeUsageScopeRestrictedToProject", "effectiveSearchScope", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "element", "fileScope", "Lcom/intellij/psi/PsiFile;", "getKotlinFqName", "Lorg/jetbrains/kotlin/name/FqName;", "ifNotEmpty", "", "", "action", "isCheapEnoughToSearchConsideringOperators", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "Lcom/intellij/psi/search/PsiSearchHelper;", "name", "", "scope", "fileToIgnoreOccurrencesIn", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isImportUsage", "Lcom/intellij/psi/PsiReference;", "minus", "otherScope", "projectScope", "toHumanReadableString", "kotlin.base.analysis"})
public final class SearchUtilKt {
    @NotNull
    private static final Regex parenthesisRegex = new Regex("( *\\( *)|( *\\) *)|( *, *(?![^\\[]*]))");

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.minus' instead", replaceWith=@ReplaceWith(expression="this.minus", imports={"org.jetbrains.kotlin.idea.base.util.minus"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final SearchScope minus(@NotNull SearchScope $this$minus, @NotNull GlobalSearchScope otherScope) {
        return KotlinScopeUtils.and($this$minus, (SearchScope)KotlinScopeUtils.not(otherScope));
    }

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.allScope' instead", replaceWith=@ReplaceWith(expression="this.allScope()", imports={"org.jetbrains.kotlin.idea.base.util.allScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        return GlobalSearchScope.allScope((Project)$this$allScope);
    }

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.projectScope' instead", replaceWith=@ReplaceWith(expression="this.projectScope()", imports={"org.jetbrains.kotlin.idea.base.util.projectScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        return GlobalSearchScope.projectScope((Project)$this$projectScope);
    }

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.moduleScope' instead", replaceWith=@ReplaceWith(expression="this.moduleScope()", imports={"org.jetbrains.kotlin.idea.base.util.moduleScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope fileScope(@NotNull PsiFile $this$fileScope) {
        return GlobalSearchScope.fileScope((PsiFile)$this$fileScope);
    }

    private static final void ifNotEmpty(CharSequence $this$ifNotEmpty, Function1<? super CharSequence, Unit> action2) {
        block0: {
            CharSequence charSequence2;
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0 = charSequence2 = $this$ifNotEmpty;
            boolean bl = false;
            CharSequence charSequence3 = !StringsKt.isBlank((CharSequence)p0) ? charSequence2 : null;
            if (charSequence3 == null) break block0;
            action2.invoke((Object)charSequence3);
        }
    }

    @NotNull
    public static final String toHumanReadableString(@NotNull SearchScope $this$toHumanReadableString) {
        StringBuilder stringBuilder;
        StringBuilder $this$toHumanReadableString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String scopeText = $this$toHumanReadableString.toString();
        int currentIndent = 0;
        int lastIndex = 0;
        for (MatchResult parenthesis : Regex.findAll$default((Regex)parenthesisRegex, (CharSequence)scopeText, (int)0, (int)2, null)) {
            CharSequence charSequence2;
            CharSequence subSequence;
            CharSequence $this$ifNotEmpty$iv = subSequence = scopeText.subSequence(lastIndex, parenthesis.getRange().getFirst());
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0$iv = charSequence2 = $this$ifNotEmpty$iv;
            boolean bl2 = false;
            if ((!StringsKt.isBlank((CharSequence)p0$iv) ? charSequence2 : null) != null) {
                CharSequence it;
                it = it;
                boolean bl3 = false;
                $this$toHumanReadableString_u24lambda_u241.append(StringsKt.repeat((CharSequence)" ", (int)currentIndent));
                StringBuilder stringBuilder2 = $this$toHumanReadableString_u24lambda_u241.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            }
            String value2 = parenthesis.getValue();
            if (StringsKt.contains$default((CharSequence)value2, (CharSequence)"(", (boolean)false, (int)2, null)) {
                currentIndent += 2;
            } else if (StringsKt.contains$default((CharSequence)value2, (CharSequence)")", (boolean)false, (int)2, null)) {
                currentIndent -= 2;
            }
            lastIndex = parenthesis.getRange().getLast() + 1;
        }
        if (((CharSequence)$this$toHumanReadableString_u24lambda_u241).length() == 0) {
            $this$toHumanReadableString_u24lambda_u241.append(scopeText);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public static final SearchScope effectiveSearchScope(@NotNull ReferencesSearch.SearchParameters $this$effectiveSearchScope, @NotNull PsiElement element3) {
        if (Intrinsics.areEqual((Object)element3, (Object)$this$effectiveSearchScope.getElementToSearch())) {
            return $this$effectiveSearchScope.getEffectiveSearchScope();
        }
        if ($this$effectiveSearchScope.isIgnoreAccessScope()) {
            return $this$effectiveSearchScope.getScopeDeterminedByUser();
        }
        SearchScope accessScope = KotlinScopeUtils.useScope(element3);
        return $this$effectiveSearchScope.getScopeDeterminedByUser().intersectWith(accessScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnlyKotlinSearch(@NotNull SearchScope searchScope2) {
        if (!(searchScope2 instanceof LocalSearchScope)) return false;
        PsiElement[] $this$all$iv = ((LocalSearchScope)searchScope2).getScope();
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            PsiElement element$iv;
            PsiElement it = element$iv = $this$all$iv[n];
            boolean bl = false;
            if (!(it.getContainingFile() instanceof KtFile)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToProject(@NotNull PsiElement $this$codeUsageScopeRestrictedToProject) {
        return KotlinScopeUtils.projectScope($this$codeUsageScopeRestrictedToProject.getProject()).intersectWith(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToProject));
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToKotlinSources(@NotNull PsiElement $this$codeUsageScopeRestrictedToKotlinSources) {
        return KotlinScopeUtils.restrictToKotlinSources(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToKotlinSources));
    }

    @NotNull
    public static final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators(@NotNull PsiSearchHelper $this$isCheapEnoughToSearchConsideringOperators, @NotNull String name2, @NotNull GlobalSearchScope scope2, @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        if (OperatorConventions.isConventionName((Name)Name.identifier((String)name2))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        return $this$isCheapEnoughToSearchConsideringOperators.isCheapEnoughToSearch(name2, scope2, fileToIgnoreOccurrencesIn, progress);
    }

    public static final boolean findScriptsWithUsages(@NotNull KtNamedDeclaration declaration2, @NotNull Function1<? super KtFile, Boolean> processor2) {
        String string2;
        Project project = declaration2.getProject();
        SearchScope searchScope2 = KotlinScopeUtils.useScope((PsiElement)declaration2);
        GlobalSearchScope globalSearchScope = searchScope2 instanceof GlobalSearchScope ? (GlobalSearchScope)searchScope2 : null;
        if (globalSearchScope == null) {
            return true;
        }
        GlobalSearchScope scope2 = globalSearchScope;
        String it = string2 = declaration2.getName();
        boolean bl = false;
        String string3 = it;
        String string4 = (string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false) ? string2 : null;
        if (string4 == null) {
            return true;
        }
        String name2 = string4;
        Processor collector2 = arg_0 -> SearchUtilKt.findScriptsWithUsages$lambda$5(project, processor2, arg_0);
        return FileBasedIndex.getInstance().getFilesWithKey(IdIndex.NAME, SetsKt.setOf((Object)new IdIndexEntry(name2, true)), collector2, scope2);
    }

    public static final boolean isImportUsage(@NotNull PsiReference $this$isImportUsage) {
        PsiElement $this$getNonStrictParentOfType$iv = $this$isImportUsage.getElement();
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false) != null;
    }

    @Deprecated(message="Use org.jetbrains.kotlin.idea.base.psi.kotlinFqName", replaceWith=@ReplaceWith(expression="kotlinFqName", imports={"org.jetbrains.kotlin.idea.base.psi.kotlinFqName"}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final FqName getKotlinFqName(@NotNull PsiElement $this$getKotlinFqName) {
        return JavaPsiUtils.getKotlinFqName($this$getKotlinFqName);
    }

    private static final boolean findScriptsWithUsages$lambda$5(Project $project, Function1 $processor, VirtualFile file2) {
        Object object;
        block3: {
            block2: {
                KtFile ktFile;
                PsiFile psiFile2 = PsiManager.getInstance((Project)$project).findFile(file2);
                object = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (object == null) break block2;
                KtFile it = ktFile = object;
                boolean bl = false;
                object = KotlinSearchUsagesSupport.Companion.scriptDefinitionExists((PsiFile)it) ? ktFile : null;
                if (object != null) break block3;
            }
            return true;
        }
        KtFile ktFile = object;
        return (Boolean)$processor.invoke((Object)ktFile);
    }
}

