/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.KotlinIndexersKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/search/KotlinFilterLexer;", "Lcom/intellij/psi/impl/cache/impl/BaseFilterLexer;", "occurrenceConsumer", "Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;", "(Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;)V", "prevTokenEnd", "", "prevTokenStart", "prevTokens", "Ljava/util/ArrayDeque;", "Lcom/intellij/psi/tree/IElementType;", "advance", "", "isMultiDeclarationPosition", "", "Companion", "kotlin.base.analysis"})
public final class KotlinFilterLexer
extends BaseFilterLexer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OccurrenceConsumer occurrenceConsumer;
    @NotNull
    private final ArrayDeque<IElementType> prevTokens;
    private int prevTokenStart;
    private int prevTokenEnd;
    @Deprecated
    @NotNull
    private static final TokenSet CODE_TOKENS;
    @Deprecated
    @NotNull
    private static final TokenSet COMMENT_TOKENS;
    @Deprecated
    private static final int MAX_PREV_TOKENS = 2;

    public KotlinFilterLexer(@NotNull OccurrenceConsumer occurrenceConsumer) {
        super((Lexer)new KotlinLexer(), occurrenceConsumer);
        this.occurrenceConsumer = occurrenceConsumer;
        this.prevTokens = new ArrayDeque(2);
        this.prevTokenStart = -1;
        this.prevTokenEnd = -1;
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            IElementType prevPrev;
            if (Intrinsics.areEqual((Object)this.prevTokens.peekFirst(), (Object)KtTokens.IDENTIFIER) && (Intrinsics.areEqual((Object)(prevPrev = (IElementType)CollectionsKt.elementAtOrNull((Iterable)this.prevTokens, (int)1)), (Object)KtTokens.COMMA) || Intrinsics.areEqual((Object)prevPrev, (Object)KtTokens.LPAR))) {
                this.occurrenceConsumer.addOccurrence(this.getBufferSequence(), null, this.prevTokenStart, this.prevTokenEnd, 32);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LPAR)) {
            if (this.isMultiDeclarationPosition()) {
                this.addOccurrenceInToken(1);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IDENTIFIER)) {
            if (StringsKt.startsWith$default((String)this.myDelegate.getTokenText(), (String)"`", (boolean)false, (int)2, null)) {
                this.scanWordsInToken(1, false, false);
            } else {
                IElementType prevToken;
                this.addOccurrenceInToken(1);
                if (!(!Intrinsics.areEqual((Object)this.myDelegate.getTokenText(), (Object)"TODO") || Intrinsics.areEqual((Object)(prevToken = this.prevTokens.peekFirst()), (Object)KtTokens.FUN_KEYWORD) || Intrinsics.areEqual((Object)prevToken, (Object)KtTokens.VAR_KEYWORD) || Intrinsics.areEqual((Object)prevToken, (Object)KtTokens.VAL_KEYWORD) || Intrinsics.areEqual((Object)prevToken, (Object)KtTokens.CLASS_KEYWORD))) {
                    this.advanceTodoItemCountsInToken();
                }
            }
        } else if (CODE_TOKENS.contains(iElementType)) {
            this.addOccurrenceInToken(1);
        } else if (KtTokens.STRINGS.contains(iElementType)) {
            this.scanWordsInToken(12, false, true);
        } else if (COMMENT_TOKENS.contains(iElementType)) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        }
        if (!Intrinsics.areEqual((Object)tokenType, (Object)TokenType.WHITE_SPACE) && !COMMENT_TOKENS.contains(tokenType)) {
            if (this.prevTokens.size() == 2) {
                this.prevTokens.removeLast();
            }
            this.prevTokens.addFirst(tokenType);
            this.prevTokenStart = this.getTokenStart();
            this.prevTokenEnd = this.getTokenEnd();
        }
        this.myDelegate.advance();
    }

    private final boolean isMultiDeclarationPosition() {
        IElementType first2 = this.prevTokens.peekFirst();
        if (Intrinsics.areEqual((Object)first2, (Object)KtTokens.VAL_KEYWORD) || Intrinsics.areEqual((Object)first2, (Object)KtTokens.VAR_KEYWORD)) {
            return true;
        }
        return Intrinsics.areEqual((Object)first2, (Object)KtTokens.LPAR) && Intrinsics.areEqual((Object)CollectionsKt.elementAtOrNull((Iterable)this.prevTokens, (int)1), (Object)KtTokens.FOR_KEYWORD);
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        Collection $this$toTypedArray$iv = (Collection)KotlinIndexersKt.access$getALL_SEARCHABLE_OPERATIONS$p();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KtToken[] ktTokenArray = thisCollection$iv.toArray(new KtToken[0]);
        tokenSetArray[0] = TokenSet.create((IElementType[])((IElementType[])Arrays.copyOf(ktTokenArray, ktTokenArray.length)));
        ktTokenArray = new IElementType[]{(IElementType)KtTokens.IDENTIFIER};
        tokenSetArray[1] = TokenSet.create((IElementType[])ktTokenArray);
        CODE_TOKENS = TokenSet.orSet((TokenSet[])tokenSetArray);
        tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.COMMENTS;
        ktTokenArray = new IElementType[]{(IElementType)KDocTokens.KDOC};
        tokenSetArray[1] = TokenSet.create((IElementType[])ktTokenArray);
        COMMENT_TOKENS = TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/search/KotlinFilterLexer$Companion;", "", "()V", "CODE_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "COMMENT_TOKENS", "MAX_PREV_TOKENS", "", "kotlin.base.analysis"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

