/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionSourceAsContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.idea.script.ScriptDefinitionMarkerFileType;
import org.jetbrains.kotlin.idea.script.ScriptTemplatesFromDependenciesProvider;
import org.jetbrains.kotlin.idea.script.ScriptTemplatesFromDependenciesProviderKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J4\u0010\u001c\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u000fH\u0017J\b\u0010%\u001a\u00020\u001bH\u0002J\b\u0010&\u001a\u00020\u001bH\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00118\u0016X\u0097D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/script/ScriptTemplatesFromDependenciesProvider;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionSourceAsContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_definitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "definitions", "Lkotlin/sequences/Sequence;", "getDefinitions", "()Lkotlin/sequences/Sequence;", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "forceStartUpdate", "", "id", "", "getId$annotations", "()V", "getId", "()Ljava/lang/String;", "inProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "oldTemplates", "Lorg/jetbrains/kotlin/idea/script/ScriptTemplatesFromDependenciesProvider$TemplatesWithCp;", "asyncRunUpdateScriptTemplates", "", "getTemplateClassPath", "Lkotlin/Pair;", "", "Ljava/nio/file/Path;", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isReady", "loadScriptDefinitions", "onEarlyEnd", "TemplatesWithCp", "kotlin.idea"})
public final class ScriptTemplatesFromDependenciesProvider
implements ScriptDefinitionSourceAsContributor {
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @Nullable
    private volatile List<? extends ScriptDefinition> _definitions;
    @NotNull
    private final ReentrantLock definitionsLock;
    @Nullable
    private TemplatesWithCp oldTemplates;
    @NotNull
    private final AtomicBoolean inProgress;
    private volatile boolean forceStartUpdate;

    public ScriptTemplatesFromDependenciesProvider(@NotNull Project project) {
        this.project = project;
        this.id = "ScriptTemplatesFromDependenciesProvider";
        KotlinPluginDisposable disposable = KotlinPluginDisposable.Companion.getInstance(this.project);
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)disposable);
        connection.subscribe(FileTypeIndex.INDEX_CHANGE_TOPIC, arg_0 -> ScriptTemplatesFromDependenciesProvider._init_$lambda$2(this, arg_0));
        this.definitionsLock = new ReentrantLock();
        this.inProgress = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Deprecated(message="migrating to new configuration refinement: drop usages")
    public static /* synthetic */ void getId$annotations() {
    }

    @Override
    @Deprecated(message="migrating to new configuration refinement: drop usages")
    public boolean isReady() {
        return this._definitions != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Sequence<ScriptDefinition> getDefinitions() {
        Lock lock = this.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            List<? extends ScriptDefinition> list2 = this._definitions;
            if (list2 != null) {
                List<? extends ScriptDefinition> it = list2;
                boolean bl2 = false;
                Sequence sequence2 = CollectionsKt.asSequence((Iterable)it);
                return sequence2;
            }
            Object var2_3 = null;
        }
        finally {
            lock.unlock();
        }
        this.forceStartUpdate = false;
        this.asyncRunUpdateScriptTemplates();
        return SequencesKt.emptySequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void asyncRunUpdateScriptTemplates() {
        Lock lock = this.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.forceStartUpdate && this._definitions != null) {
                return;
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (this.inProgress.compareAndSet(false, true)) {
            this.loadScriptDefinitions();
        }
    }

    private final void loadScriptDefinitions() {
        if (this.project.isDefault() || this.project.isDisposed()) {
            this.onEarlyEnd();
            return;
        }
        if (ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().isDebugEnabled()) {
            ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().debug("async script definitions update started");
        }
        Project project = this.project;
        String string2 = KotlinBundle.message("kotlin.script.lookup.definitions", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(this, project, string2){
            final /* synthetic */ ScriptTemplatesFromDependenciesProvider this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                KotlinPluginDisposable pluginDisposable = KotlinPluginDisposable.Companion.getInstance(this.getProject());
                Pair pair = (Pair)ReadAction.nonBlocking(() -> loadScriptDefinitions.task.1.run$lambda$0(this, this.this$0, indicator)).expireWith((Disposable)pluginDisposable).wrapProgress(indicator).executeSynchronously();
                if (pair == null) {
                    ScriptTemplatesFromDependenciesProvider.access$onEarlyEnd(this.this$0);
                    return;
                }
                Pair pair2 = pair;
                Collection templates2 = (Collection)pair2.component1();
                Collection classpath2 = (Collection)pair2.component2();
                try {
                    boolean bl;
                    indicator.checkCanceled();
                    if (pluginDisposable.getDisposed() || !ScriptTemplatesFromDependenciesProvider.access$getInProgress$p(this.this$0).get() || templates2.isEmpty()) {
                        ScriptTemplatesFromDependenciesProvider.access$onEarlyEnd(this.this$0);
                        return;
                    }
                    TemplatesWithCp newTemplates = new TemplatesWithCp(CollectionsKt.toList((Iterable)templates2), CollectionsKt.toList((Iterable)classpath2));
                    if (!ScriptTemplatesFromDependenciesProvider.access$getInProgress$p(this.this$0).get() || Intrinsics.areEqual((Object)newTemplates, (Object)ScriptTemplatesFromDependenciesProvider.access$getOldTemplates$p(this.this$0))) {
                        ScriptTemplatesFromDependenciesProvider.access$onEarlyEnd(this.this$0);
                        return;
                    }
                    if (ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().isDebugEnabled()) {
                        ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().debug("script templates found: " + newTemplates);
                    }
                    ScriptTemplatesFromDependenciesProvider.access$setOldTemplates$p(this.this$0, newTemplates);
                    ScriptingHostConfiguration[] scriptingHostConfigurationArray = new ScriptingHostConfiguration[]{JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()};
                    ScriptingHostConfiguration hostConfiguration2 = new ScriptingHostConfiguration(scriptingHostConfigurationArray, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>(this){
                        final /* synthetic */ loadScriptDefinitions.task.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull ScriptingHostConfiguration.Builder $this$$receiver) {
                            $this$$receiver.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment($this$$receiver), new Function0<Map<String, ? extends File>>(this.this$0){
                                final /* synthetic */ loadScriptDefinitions.task.1 this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                @NotNull
                                public final Map<String, File> invoke() {
                                    File file2;
                                    String string2 = "projectRoot";
                                    String string3 = this.this$0.getProject().getBasePath();
                                    if (string3 == null) {
                                        string3 = this.this$0.getProject().getBaseDir().getCanonicalPath();
                                    }
                                    if (string3 != null) {
                                        String p0 = string3;
                                        String string4 = string2;
                                        boolean bl = false;
                                        file2 = new File(p0);
                                        string2 = string4;
                                    } else {
                                        file2 = null;
                                    }
                                    return MapsKt.mapOf((Pair)TuplesKt.to((Object)string2, file2));
                                }
                            });
                        }
                    }));
                    List newDefinitions = ScriptDefinitionsManagerKt.loadDefinitionsFromTemplatesByPaths$default(newTemplates.getTemplates(), newTemplates.getClasspath(), hostConfiguration2, null, null, 24, null);
                    indicator.checkCanceled();
                    if (ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().isDebugEnabled()) {
                        ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().debug("script definitions found: " + CollectionsKt.joinToString$default((Iterable)newDefinitions, null, null, null, (int)0, null, null, (int)63, null));
                    }
                    Lock lock = ScriptTemplatesFromDependenciesProvider.access$getDefinitionsLock$p(this.this$0);
                    ScriptTemplatesFromDependenciesProvider scriptTemplatesFromDependenciesProvider = this.this$0;
                    lock.lock();
                    try {
                        boolean bl2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)newDefinitions, (Object)ScriptTemplatesFromDependenciesProvider.access$get_definitions$p(scriptTemplatesFromDependenciesProvider))) {
                            ScriptTemplatesFromDependenciesProvider.access$set_definitions$p(scriptTemplatesFromDependenciesProvider, newDefinitions);
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    finally {
                        lock.unlock();
                    }
                    boolean needReload = bl;
                    if (needReload) {
                        ScriptDefinitionsManager.Companion.getInstance(this.getProject()).reloadDefinitionsBy(this.this$0);
                    }
                }
                finally {
                    ScriptTemplatesFromDependenciesProvider.access$getInProgress$p(this.this$0).set(false);
                }
            }

            private static final Pair run$lambda$0(loadScriptDefinitions.task.1 this$0, ScriptTemplatesFromDependenciesProvider this$1, ProgressIndicator $indicator) {
                Collection files2 = FileTypeIndex.getFiles((FileType)((FileType)ScriptDefinitionMarkerFileType.INSTANCE), (GlobalSearchScope)KotlinScopeUtils.allScope(this$0.getProject()));
                return this$1.getTemplateClassPath(files2, $indicator);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEarlyEnd() {
        Lock lock = this.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            this._definitions = CollectionsKt.emptyList();
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.inProgress.set(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Collection<String>, Collection<Path>> getTemplateClassPath(@NotNull Collection<? extends VirtualFile> files2, @NotNull ProgressIndicator indicator) {
        Map rootDirToTemplates = new HashMap();
        for (VirtualFile virtualFile : files2) {
            Object object;
            VirtualFile virtualFile2 = virtualFile.getParent();
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null || (virtualFile2 = virtualFile2.getParent()) == null || (virtualFile2 = virtualFile2.getParent()) == null || (virtualFile2 = virtualFile2.getParent()) == null) continue;
            VirtualFile dir = virtualFile2;
            Map $this$getOrPut$iv = rootDirToTemplates;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(dir);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(dir, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(virtualFile);
        }
        LinkedHashSet<String> templates2 = new LinkedHashSet<String>();
        LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
        Map $this$forEach$iv = rootDirToTemplates;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List orderEntriesForFile;
            void $this$filterTo$iv$iv;
            List $this$filter$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            VirtualFile root = (VirtualFile)entry.getKey();
            List templateFiles = (List)entry.getValue();
            if (ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().isDebugEnabled()) {
                ScriptTemplatesFromDependenciesProviderKt.access$getLogger$p().debug("root matching SCRIPT_DEFINITION_MARKERS_PATH found: " + root.getPath());
            }
            Iterable iterable = ProjectFileIndex.getInstance((Project)this.project).getOrderEntriesForFile(root);
            boolean $i$f$filter = false;
            void var16_22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OrderEntry it = (OrderEntry)element$iv$iv;
                boolean bl2 = false;
                indicator.checkCanceled();
                boolean bl3 = it instanceof ModuleSourceOrderEntry ? (ModuleRootManager.getInstance((Module)((ModuleSourceOrderEntry)it).getOwnerModule()).getFileIndex().isInTestSourceContent(root) ? false : ArraysKt.contains((Object[])it.getFiles(OrderRootType.SOURCES), (Object)root)) : it instanceof LibraryOrSdkOrderEntry && ArraysKt.contains((Object[])((LibraryOrSdkOrderEntry)it).getRootFiles(OrderRootType.CLASSES), (Object)root);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = $this$filter$iv = (List)destination$iv$iv;
            boolean bl4 = false;
            if ((!((Collection)it).isEmpty() ? $this$filter$iv : null) == null) continue;
            orderEntriesForFile = orderEntriesForFile;
            for (VirtualFile virtualFile : templateFiles) {
                templates2.add(StringsKt.removeSuffix((String)virtualFile.getName(), (CharSequence)".classname"));
            }
            for (OrderEntry orderEntry : orderEntriesForFile) {
                for (VirtualFile virtualFile : OrderEnumerator.orderEntries((Module)orderEntry.getOwnerModule()).withoutSdk().getClassesRoots()) {
                    Path p0;
                    indicator.checkCanceled();
                    VirtualFile localVirtualFile = VfsUtil.getLocalFile((VirtualFile)virtualFile);
                    if (localVirtualFile.getFileSystem().getNioPath(localVirtualFile) == null) continue;
                    boolean bl5 = false;
                    linkedHashSet.add(p0);
                }
            }
        }
        return TuplesKt.to(templates2, linkedHashSet);
    }

    private static final void _init_$lambda$2(ScriptTemplatesFromDependenciesProvider this$0, FileType fileType) {
        if (Intrinsics.areEqual((Object)fileType, (Object)((Object)ScriptDefinitionMarkerFileType.INSTANCE)) && this$0.project.isInitialized()) {
            this$0.forceStartUpdate = true;
            this$0.asyncRunUpdateScriptTemplates();
        }
    }

    public static final /* synthetic */ void access$onEarlyEnd(ScriptTemplatesFromDependenciesProvider $this) {
        $this.onEarlyEnd();
    }

    public static final /* synthetic */ AtomicBoolean access$getInProgress$p(ScriptTemplatesFromDependenciesProvider $this) {
        return $this.inProgress;
    }

    public static final /* synthetic */ TemplatesWithCp access$getOldTemplates$p(ScriptTemplatesFromDependenciesProvider $this) {
        return $this.oldTemplates;
    }

    public static final /* synthetic */ void access$setOldTemplates$p(ScriptTemplatesFromDependenciesProvider $this, TemplatesWithCp templatesWithCp) {
        $this.oldTemplates = templatesWithCp;
    }

    public static final /* synthetic */ ReentrantLock access$getDefinitionsLock$p(ScriptTemplatesFromDependenciesProvider $this) {
        return $this.definitionsLock;
    }

    public static final /* synthetic */ List access$get_definitions$p(ScriptTemplatesFromDependenciesProvider $this) {
        return $this._definitions;
    }

    public static final /* synthetic */ void access$set_definitions$p(ScriptTemplatesFromDependenciesProvider $this, List list2) {
        $this._definitions = list2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/script/ScriptTemplatesFromDependenciesProvider$TemplatesWithCp;", "", "templates", "", "", "classpath", "Ljava/nio/file/Path;", "(Ljava/util/List;Ljava/util/List;)V", "getClasspath", "()Ljava/util/List;", "getTemplates", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class TemplatesWithCp {
        @NotNull
        private final List<String> templates;
        @NotNull
        private final List<Path> classpath;

        public TemplatesWithCp(@NotNull List<String> templates2, @NotNull List<? extends Path> classpath2) {
            this.templates = templates2;
            this.classpath = classpath2;
        }

        @NotNull
        public final List<String> getTemplates() {
            return this.templates;
        }

        @NotNull
        public final List<Path> getClasspath() {
            return this.classpath;
        }

        @NotNull
        public final List<String> component1() {
            return this.templates;
        }

        @NotNull
        public final List<Path> component2() {
            return this.classpath;
        }

        @NotNull
        public final TemplatesWithCp copy(@NotNull List<String> templates2, @NotNull List<? extends Path> classpath2) {
            return new TemplatesWithCp(templates2, classpath2);
        }

        public static /* synthetic */ TemplatesWithCp copy$default(TemplatesWithCp templatesWithCp, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = templatesWithCp.templates;
            }
            if ((n & 2) != 0) {
                list3 = templatesWithCp.classpath;
            }
            return templatesWithCp.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "TemplatesWithCp(templates=" + this.templates + ", classpath=" + this.classpath + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.templates).hashCode();
            result2 = result2 * 31 + ((Object)this.classpath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TemplatesWithCp)) {
                return false;
            }
            TemplatesWithCp templatesWithCp = (TemplatesWithCp)other;
            if (!Intrinsics.areEqual(this.templates, templatesWithCp.templates)) {
                return false;
            }
            return Intrinsics.areEqual(this.classpath, templatesWithCp.classpath);
        }
    }
}

