/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.ClearScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.StopScratchAction;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.ui.ModulesComboBoxAction;
import org.jetbrains.kotlin.idea.scratch.ui.SmallBorderCheckboxAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "actionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getActionsToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "moduleChooserAction", "Lorg/jetbrains/kotlin/idea/scratch/ui/ModulesComboBoxAction;", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createUpdateToolbarHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "setupTopPanelUpdateHandlers", "", "updateToolbar", "IsInteractiveCheckboxAction", "IsMakeBeforeRunAction", "IsReplCheckboxAction", "kotlin.jvm"})
public final class ScratchTopPanel {
    @NotNull
    private final ScratchFile scratchFile;
    @NotNull
    private final ModulesComboBoxAction moduleChooserAction;
    @NotNull
    private final ActionToolbar actionsToolbar;

    public ScratchTopPanel(@NotNull ScratchFile scratchFile) {
        DefaultActionGroup defaultActionGroup;
        this.scratchFile = scratchFile;
        this.moduleChooserAction = new ModulesComboBoxAction(this.scratchFile);
        this.setupTopPanelUpdateHandlers();
        DefaultActionGroup $this$_init__u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u240.add((AnAction)new RunScratchAction());
        $this$_init__u24lambda_u240.add((AnAction)new StopScratchAction());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)new ClearScratchAction());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)this.moduleChooserAction);
        $this$_init__u24lambda_u240.add((AnAction)new IsMakeBeforeRunAction());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)new IsInteractiveCheckboxAction());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)new IsReplCheckboxAction());
        DefaultActionGroup toolbarGroup = defaultActionGroup;
        this.actionsToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarGroup, true);
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    @NotNull
    public final ActionToolbar getActionsToolbar() {
        return this.actionsToolbar;
    }

    private final void setupTopPanelUpdateHandlers() {
        block1: {
            this.scratchFile.addModuleListener((Function2<? super PsiFile, ? super Module, Unit>)((Function2)new Function2<PsiFile, Module, Unit>(this){
                final /* synthetic */ ScratchTopPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull PsiFile psiFile2, @Nullable Module module2) {
                    ScratchTopPanel.access$updateToolbar(this.this$0);
                }
            }));
            ScratchOutputHandlerAdapter toolbarHandler = this.createUpdateToolbarHandler();
            SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
            if (sequentialScratchExecutor != null) {
                sequentialScratchExecutor.addOutputHandler(toolbarHandler);
            }
            ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
            if (scratchExecutor == null) break block1;
            scratchExecutor.addOutputHandler(toolbarHandler);
        }
    }

    private final ScratchOutputHandlerAdapter createUpdateToolbarHandler() {
        return new ScratchOutputHandlerAdapter(this){
            final /* synthetic */ ScratchTopPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStart(@NotNull ScratchFile file2) {
                ScratchTopPanel.access$updateToolbar(this.this$0);
            }

            public void onFinish(@NotNull ScratchFile file2) {
                ScratchTopPanel.access$updateToolbar(this.this$0);
            }
        };
    }

    private final void updateToolbar() {
        ApplicationManager.getApplication().invokeLater(() -> ScratchTopPanel.updateToolbar$lambda$1(this));
    }

    private static final void updateToolbar$lambda$1(ScratchTopPanel this$0) {
        this$0.actionsToolbar.updateActionsImmediately();
    }

    public static final /* synthetic */ void access$updateToolbar(ScratchTopPanel $this) {
        $this.updateToolbar();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel$IsMakeBeforeRunAction;", "Lorg/jetbrains/kotlin/idea/scratch/ui/SmallBorderCheckboxAction;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isMakeBeforeRun", "update", "kotlin.jvm"})
    private final class IsMakeBeforeRunAction
    extends SmallBorderCheckboxAction {
        public IsMakeBeforeRunAction() {
            super(KotlinJvmBundle.message("scratch.make.before.run.checkbox", new Object[0]), null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        public void update(@NotNull AnActionEvent e) {
            String string2;
            super.update(e);
            e.getPresentation().setVisible(ScratchTopPanel.this.getScratchFile().getModule() != null);
            Presentation presentation = e.getPresentation();
            Module module2 = ScratchTopPanel.this.getScratchFile().getModule();
            if (module2 != null) {
                void selectedModule;
                Module module3 = module2;
                Presentation presentation2 = presentation;
                boolean bl = false;
                Object[] objectArray = new Object[]{selectedModule.getName()};
                string2 = KotlinJvmBundle.message("scratch.make.before.run.checkbox.description", objectArray);
                presentation = presentation2;
            } else {
                string2 = null;
            }
            presentation.setDescription(string2);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ScratchTopPanel.this.getScratchFile().getOptions().isMakeBeforeRun();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isMakeBeforeRun) {
            ScratchTopPanel.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(isMakeBeforeRun){
                final /* synthetic */ boolean $isMakeBeforeRun;
                {
                    this.$isMakeBeforeRun = $isMakeBeforeRun;
                    super(1);
                }

                @NotNull
                public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                    return ScratchFileOptions.copy$default($this$saveOptions, false, this.$isMakeBeforeRun, false, 5, null);
                }
            }));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel$IsInteractiveCheckboxAction;", "Lorg/jetbrains/kotlin/idea/scratch/ui/SmallBorderCheckboxAction;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isInteractiveMode", "kotlin.jvm"})
    private final class IsInteractiveCheckboxAction
    extends SmallBorderCheckboxAction {
        public IsInteractiveCheckboxAction() {
            Object[] objectArray = new Object[]{2};
            super(KotlinJvmBundle.message("scratch.is.interactive.checkbox", new Object[0]), KotlinJvmBundle.message("scratch.is.interactive.checkbox.description", objectArray));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ScratchTopPanel.this.getScratchFile().getOptions().isInteractiveMode();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isInteractiveMode) {
            ScratchTopPanel.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(isInteractiveMode){
                final /* synthetic */ boolean $isInteractiveMode;
                {
                    this.$isInteractiveMode = $isInteractiveMode;
                    super(1);
                }

                @NotNull
                public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                    return ScratchFileOptions.copy$default($this$saveOptions, false, false, this.$isInteractiveMode, 3, null);
                }
            }));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel$IsReplCheckboxAction;", "Lorg/jetbrains/kotlin/idea/scratch/ui/SmallBorderCheckboxAction;", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isRepl", "kotlin.jvm"})
    private final class IsReplCheckboxAction
    extends SmallBorderCheckboxAction {
        public IsReplCheckboxAction() {
            super(KotlinJvmBundle.message("scratch.is.repl.checkbox", new Object[0]), KotlinJvmBundle.message("scratch.is.repl.checkbox.description", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ScratchTopPanel.this.getScratchFile().getOptions().isRepl();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isRepl) {
            block1: {
                ScratchTopPanel.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(isRepl){
                    final /* synthetic */ boolean $isRepl;
                    {
                        this.$isRepl = $isRepl;
                        super(1);
                    }

                    @NotNull
                    public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                        return ScratchFileOptions.copy$default($this$saveOptions, this.$isRepl, false, false, 6, null);
                    }
                }));
                if (isRepl) break block1;
                SequentialScratchExecutor sequentialScratchExecutor = ScratchTopPanel.this.getScratchFile().getReplScratchExecutor();
                if (sequentialScratchExecutor != null) {
                    sequentialScratchExecutor.stop();
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

