/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.PreviewEditorScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.idea.scratch.ui.LayoutDependantOutputHandler;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorSyncHighlighterKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001;B\u001f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020+H\u0014J\b\u0010-\u001a\u00020\u001bH\u0014J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010/\u001a\u00020\u001f2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101H\u0014J\u001e\u00103\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000205\u0018\u0001042\u0006\u00106\u001a\u000205H\u0016J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001bH\u0007J\u001e\u00109\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000205\u0018\u0001042\u0006\u0010:\u001a\u000205H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorLinesTranslator;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "sourceTextEditor", "previewTextEditor", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "commonPreviewOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/ui/LayoutDependantOutputHandler;", "inlayScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "previewEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditorScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewEditorScratchOutputHandler;", "previewOutputManager", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "scratchTopPanel", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "sourceEditor", "toolWindowHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "canNavigateTo", "", "navigatable", "Lcom/intellij/pom/Navigatable;", "clearOutputHandlers", "", "configureSyncScrollForSourceAndPreview", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createViewActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "dispose", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getShowEditorAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getShowEditorAndPreviewAction", "isShowActionsInTabs", "navigateTo", "onLayoutChange", "oldValue", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "newValue", "previewLineToSourceLines", "Lkotlin/Pair;", "", "previewLine", "setPreviewEnabled", "isPreviewEnabled", "sourceLineToPreviewLines", "sourceLine", "Companion", "kotlin.jvm"})
public final class KtScratchFileEditorWithPreview
extends TextEditorWithPreview
implements TextEditor,
ScratchEditorLinesTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchFile scratchFile;
    @NotNull
    private final EditorEx sourceEditor;
    @NotNull
    private final EditorEx previewEditor;
    @NotNull
    private final PreviewOutputBlocksManager previewOutputManager;
    @NotNull
    private final ScratchOutputHandler toolWindowHandler;
    @NotNull
    private final InlayScratchOutputHandler inlayScratchOutputHandler;
    @NotNull
    private final PreviewEditorScratchOutputHandler previewEditorScratchOutputHandler;
    @NotNull
    private final LayoutDependantOutputHandler commonPreviewOutputHandler;
    @NotNull
    private final ScratchTopPanel scratchTopPanel;

    private KtScratchFileEditorWithPreview(ScratchFile scratchFile, TextEditor sourceTextEditor, TextEditor previewTextEditor) {
        super(sourceTextEditor, (FileEditor)previewTextEditor);
        this.scratchFile = scratchFile;
        Editor editor2 = sourceTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.sourceEditor = (EditorEx)editor2;
        Editor editor3 = previewTextEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        this.previewEditor = (EditorEx)editor3;
        this.previewOutputManager = new PreviewOutputBlocksManager((Editor)this.previewEditor);
        this.toolWindowHandler = ToolWindowScratchOutputHandlerKt.requestToolWindowHandler();
        this.inlayScratchOutputHandler = new InlayScratchOutputHandler(sourceTextEditor, this.toolWindowHandler);
        Intrinsics.checkNotNull((Object)previewTextEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        this.previewEditorScratchOutputHandler = new PreviewEditorScratchOutputHandler(this.previewOutputManager, this.toolWindowHandler, (Disposable)previewTextEditor);
        this.commonPreviewOutputHandler = new LayoutDependantOutputHandler(this.inlayScratchOutputHandler, this.previewEditorScratchOutputHandler, (Function0<? extends TextEditorWithPreview.Layout>)((Function0)new Function0<TextEditorWithPreview.Layout>((Object)this){

            public final TextEditorWithPreview.Layout invoke() {
                return ((KtScratchFileEditorWithPreview)this.receiver).getLayout();
            }
        }));
        this.scratchTopPanel = new ScratchTopPanel(this.scratchFile);
        KtScratchFileEditorProviderKt.access$setParentScratchEditorWithPreview(sourceTextEditor, this);
        KtScratchFileEditorProviderKt.access$setParentScratchEditorWithPreview(previewTextEditor, this);
        ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            scratchExecutor.addOutputHandler(this.commonPreviewOutputHandler);
        }
        SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            sequentialScratchExecutor.addOutputHandler(this.commonPreviewOutputHandler);
        }
        this.configureSyncScrollForSourceAndPreview();
        ScratchEditorSyncHighlighterKt.configureSyncHighlighting(this.sourceEditor, this.previewEditor, this);
        ScratchFileAutoRunner.Companion.addListener(this.scratchFile.getProject(), sourceTextEditor);
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.scratchFile.getFile();
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> previewLineToSourceLines(int previewLine) {
        ScratchExpression scratchExpression = this.scratchFile.getExpressionAtLine(previewLine);
        if (scratchExpression == null) {
            return null;
        }
        ScratchExpression expressionUnderCaret = scratchExpression;
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlock(expressionUnderCaret);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock outputBlock = scratchOutputBlock;
        return TuplesKt.to((Object)outputBlock.getLineStart(), (Object)outputBlock.getLineEnd());
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> sourceLineToPreviewLines(int sourceLine) {
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlockAtLine(sourceLine);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock block2 = scratchOutputBlock;
        if (!KtScratchFileEditorProviderKt.access$linesInformationIsCorrect(block2.getSourceExpression())) {
            return null;
        }
        return TuplesKt.to((Object)block2.getSourceExpression().getLineStart(), (Object)block2.getSourceExpression().getLineEnd());
    }

    private final void configureSyncScrollForSourceAndPreview() {
        BaseSyncScrollable scrollable2 = new BaseSyncScrollable(this){
            final /* synthetic */ KtScratchFileEditorWithPreview this$0;
            {
                this.this$0 = $receiver;
            }

            protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper2) {
                if (!helper2.process(0, 0)) {
                    return;
                }
                List<Pair<Integer, Integer>> alignments = KtScratchFileEditorWithPreview.access$getPreviewOutputManager$p(this.this$0).computeSourceToPreviewAlignments();
                for (Pair<Integer, Integer> pair : alignments) {
                    int fromPreview;
                    int fromSource = ((Number)pair.component1()).intValue();
                    if (!helper2.process(fromSource, fromPreview = ((Number)pair.component2()).intValue())) {
                        return;
                    }
                    if (helper2.process(fromSource, fromPreview)) continue;
                    return;
                }
                helper2.process(KtScratchFileEditorWithPreview.access$getSourceEditor$p(this.this$0).getDocument().getLineCount(), KtScratchFileEditorWithPreview.access$getPreviewEditor$p(this.this$0).getDocument().getLineCount());
            }

            public boolean isSyncScrollEnabled() {
                return true;
            }
        };
        Object[] objectArray = new EditorEx[]{this.sourceEditor, this.previewEditor};
        SyncScrollSupport.TwosideSyncScrollSupport scrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(CollectionsKt.listOf((Object[])objectArray), (SyncScrollSupport.SyncScrollable)scrollable2);
        VisibleAreaListener listener2 = arg_0 -> KtScratchFileEditorWithPreview.configureSyncScrollForSourceAndPreview$lambda$0(scrollSupport, arg_0);
        this.sourceEditor.getScrollingModel().addVisibleAreaListener(listener2);
        this.previewEditor.getScrollingModel().addVisibleAreaListener(listener2);
    }

    public void dispose() {
        SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            sequentialScratchExecutor.stop();
        }
        ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            scratchExecutor.stop();
        }
        ToolWindowScratchOutputHandlerKt.releaseToolWindowHandler(this.toolWindowHandler);
        super.dispose();
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        this.myEditor.navigateTo(navigatable);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return this.myEditor.canNavigateTo(navigatable);
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor.getEditor();
    }

    @NotNull
    protected ActionToolbar createToolbar() {
        return this.scratchTopPanel.getActionsToolbar();
    }

    public final void clearOutputHandlers() {
        this.commonPreviewOutputHandler.clear(this.scratchFile);
    }

    protected boolean isShowActionsInTabs() {
        return false;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        AnAction[] anActionArray = new AnAction[]{(AnAction)this.getShowEditorAction(), (AnAction)this.getShowEditorAndPreviewAction()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        ToggleAction toggleAction;
        ToggleAction $this$getShowEditorAction_u24lambda_u241 = toggleAction = super.getShowEditorAction();
        boolean bl = false;
        $this$getShowEditorAction_u24lambda_u241.getTemplatePresentation().setText(KotlinJvmBundle.message("scratch.inlay.output.mode.title", new Object[0]));
        $this$getShowEditorAction_u24lambda_u241.getTemplatePresentation().setDescription(KotlinJvmBundle.message("scratch.inlay.output.mode.description", new Object[0]));
        return toggleAction;
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        ToggleAction toggleAction;
        ToggleAction $this$getShowEditorAndPreviewAction_u24lambda_u242 = toggleAction = super.getShowEditorAndPreviewAction();
        boolean bl = false;
        $this$getShowEditorAndPreviewAction_u24lambda_u242.getTemplatePresentation().setText(KotlinJvmBundle.message("scratch.side.panel.output.mode.title", new Object[0]));
        $this$getShowEditorAndPreviewAction_u24lambda_u242.getTemplatePresentation().setDescription(KotlinJvmBundle.message("scratch.side.panel.output.mode.description", new Object[0]));
        return toggleAction;
    }

    protected void onLayoutChange(@Nullable TextEditorWithPreview.Layout oldValue, @Nullable TextEditorWithPreview.Layout newValue) {
        if (oldValue != newValue) {
            this.clearOutputHandlers();
        }
    }

    @TestOnly
    public final void setPreviewEnabled(boolean isPreviewEnabled) {
        this.setLayout(isPreviewEnabled ? TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW : TextEditorWithPreview.Layout.SHOW_EDITOR);
    }

    private static final void configureSyncScrollForSourceAndPreview$lambda$0(SyncScrollSupport.TwosideSyncScrollSupport $scrollSupport, VisibleAreaEvent e) {
        $scrollSupport.visibleAreaChanged(e);
    }

    public static final /* synthetic */ PreviewOutputBlocksManager access$getPreviewOutputManager$p(KtScratchFileEditorWithPreview $this) {
        return $this.previewOutputManager;
    }

    public static final /* synthetic */ EditorEx access$getSourceEditor$p(KtScratchFileEditorWithPreview $this) {
        return $this.sourceEditor;
    }

    public static final /* synthetic */ EditorEx access$getPreviewEditor$p(KtScratchFileEditorWithPreview $this) {
        return $this.previewEditor;
    }

    public /* synthetic */ KtScratchFileEditorWithPreview(ScratchFile scratchFile, TextEditor sourceTextEditor, TextEditor previewTextEditor, DefaultConstructorMarker $constructor_marker) {
        this(scratchFile, sourceTextEditor, previewTextEditor);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtScratchFileEditorWithPreview create(@NotNull ScratchFile scratchFile) {
            TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
            FileEditor fileEditor = textEditorProvider.createEditor(scratchFile.getProject(), scratchFile.getFile());
            Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
            TextEditor mainEditor = (TextEditor)fileEditor;
            EditorFactory editorFactory = EditorFactory.getInstance();
            Editor viewer = editorFactory.createViewer(editorFactory.createDocument((CharSequence)""), scratchFile.getProject(), EditorKind.PREVIEW);
            Disposer.register((Disposable)((Disposable)mainEditor), () -> Companion.create$lambda$0(editorFactory, viewer));
            TextEditor previewEditor = textEditorProvider.getTextEditor(viewer);
            return new KtScratchFileEditorWithPreview(scratchFile, mainEditor, previewEditor, null);
        }

        private static final void create$lambda$0(EditorFactory $editorFactory, Editor $viewer) {
            $editorFactory.releaseEditor($viewer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

