/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.repl;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\nH\u0014J\u0018\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0016H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "history", "Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "clearState", "", "executeStatement", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "needProcessToStart", "", "sendCommandToProcess", "command", "", "startExecution", "stopExecution", "callback", "Lkotlin/Function0;", "ReplHistory", "ReplOSProcessHandler", "kotlin.jvm"})
public final class KtScratchReplExecutor
extends SequentialScratchExecutor {
    @NotNull
    private final ReplHistory history = new ReplHistory();
    @Nullable
    private volatile OSProcessHandler osProcessHandler;

    public KtScratchReplExecutor(@NotNull ScratchFile file2) {
        super(file2);
    }

    @Override
    protected void startExecution() {
        block0: {
            Module module2 = this.getFile().getModule();
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = KotlinConsoleKeeper.Companion.createReplCommandLine(this.getFile().getProject(), module2);
            TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine cmdLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment = environmentRequest.prepareEnvironment(TargetProgressIndicator.EMPTY);
            String commandPresentation = cmdLine.getCommandPresentation(environment);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Execute REPL: " + commandPresentation);
            OSProcessHandler oSProcessHandler = this.osProcessHandler = (OSProcessHandler)new ReplOSProcessHandler(environment.createProcess(cmdLine, (ProgressIndicator)new EmptyProgressIndicator()), commandPresentation);
            if (oSProcessHandler == null) break block0;
            oSProcessHandler.startNotify();
        }
    }

    @Override
    protected void stopExecution(@Nullable Function0<Unit> callback2) {
        OSProcessHandler processHandler = this.osProcessHandler;
        if (processHandler == null) {
            Function0<Unit> function0 = callback2;
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        try {
            if (callback2 != null) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(callback2){
                    final /* synthetic */ Function0<Unit> $callback;
                    {
                        this.$callback = $callback;
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        this.$callback.invoke();
                    }
                });
            }
            this.sendCommandToProcess(":quit");
        }
        catch (Exception e) {
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.stop.repl.process", new Object[0]), e, false);
            processHandler.destroyProcess();
            this.clearState();
        }
    }

    private final void clearState() {
        this.history.clear();
        this.osProcessHandler = null;
        this.getHandler().onFinish(this.getFile());
    }

    @Override
    public void executeStatement(@NotNull ScratchExpression expression2) {
        if (this.needProcessToStart()) {
            this.startExecution();
        }
        this.history.addEntry(expression2);
        try {
            boolean $i$f$runReadAction = false;
            this.sendCommandToProcess((String)ApplicationManager.getApplication().runReadAction(new Computable(expression2){
                final /* synthetic */ ScratchExpression $expression$inlined;
                {
                    this.$expression$inlined = scratchExpression;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$expression$inlined.getElement().getText();
                }
            }));
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{expression2.getElement().getText()};
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.execute.statement.0", objectArray), e, true);
        }
    }

    @Override
    protected boolean needProcessToStart() {
        return this.osProcessHandler == null;
    }

    private final void sendCommandToProcess(String command2) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Send to REPL: " + command2);
        Object object = this.osProcessHandler;
        if (object == null || (object = object.getProcessInput()) == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), "<p>Broken execute stream</p>", null, 4, null);
            return;
        }
        Object processInputOS = object;
        Object object2 = this.osProcessHandler;
        if (object2 == null || (object2 = object2.getCharset()) == null) {
            object2 = Charsets.UTF_8;
        }
        Object charset = object2;
        String xmlRes = ReplUtilKt.replInputAsXml((String)command2);
        byte[] byArray = (xmlRes + "\n").getBytes((Charset)charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        ((OutputStream)processInputOS).write(bytes2);
        ((OutputStream)processInputOS).flush();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lkotlin/collections/ArrayList;", "processedEntriesCount", "", "addEntry", "", "entry", "clear", "entryProcessed", "isAllProcessed", "", "lastProcessedEntry", "lastUnprocessedEntry", "kotlin.jvm"})
    private static final class ReplHistory {
        @NotNull
        private ArrayList<ScratchExpression> entries = new ArrayList();
        private int processedEntriesCount;

        public final void addEntry(@NotNull ScratchExpression entry) {
            this.entries.add(entry);
        }

        @Nullable
        public final ScratchExpression lastUnprocessedEntry() {
            ArrayList<ScratchExpression> arrayList;
            ArrayList<ScratchExpression> it = arrayList = this.entries;
            boolean bl = false;
            ArrayList<ScratchExpression> arrayList2 = this.processedEntriesCount < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(this.processedEntriesCount) : null;
        }

        @Nullable
        public final ScratchExpression lastProcessedEntry() {
            ArrayList<ScratchExpression> arrayList;
            if (this.processedEntriesCount < 1) {
                return null;
            }
            int lastProcessedEntryIndex = this.processedEntriesCount - 1;
            ArrayList<ScratchExpression> it = arrayList = this.entries;
            boolean bl = false;
            ArrayList<ScratchExpression> arrayList2 = lastProcessedEntryIndex < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(lastProcessedEntryIndex) : null;
        }

        public final void entryProcessed() {
            int n = this.processedEntriesCount;
            this.processedEntriesCount = n + 1;
        }

        public final void clear() {
            this.entries = new ArrayList();
            this.processedEntriesCount = 0;
        }

        public final boolean isAllProcessed() {
            return this.entries.size() == this.processedEntriesCount;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplOSProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;Ljava/lang/Process;Ljava/lang/String;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "handleReplMessage", "", "text", "notifyProcessTerminated", "exitCode", "", "notifyTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "parseReplOutput", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "kotlin.jvm"})
    private final class ReplOSProcessHandler
    extends OSProcessHandler {
        private final DocumentBuilderFactory factory;

        public ReplOSProcessHandler(@NotNull Process process2, String commandLine) {
            super(process2, commandLine);
            this.factory = DocumentBuilderFactory.newInstance();
        }

        public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
            if (StringsKt.startsWith$default((String)text2, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
                return;
            }
            Key<?> key = outputType;
            if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
                this.handleReplMessage(text2);
            } else if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDERR)) {
                ScratchExecutor.errorOccurs$default(KtScratchReplExecutor.this, text2, null, false, 6, null);
            }
        }

        protected void notifyProcessTerminated(int exitCode) {
            KtScratchReplExecutor.this.clearState();
            super.notifyProcessTerminated(exitCode);
        }

        private final InputSource strToSource(String s, Charset encoding) {
            byte[] byArray = s.getBytes(encoding);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new InputSource(new ByteArrayInputStream(byArray));
        }

        static /* synthetic */ InputSource strToSource$default(ReplOSProcessHandler replOSProcessHandler, String string2, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return replOSProcessHandler.strToSource(string2, charset);
        }

        private final void handleReplMessage(String text2) {
            ScratchOutput result2;
            Document document;
            if (StringsKt.isBlank((CharSequence)text2)) {
                return;
            }
            try {
                document = this.factory.newDocumentBuilder().parse(ReplOSProcessHandler.strToSource$default(this, text2, null, 2, null));
            }
            catch (Exception e) {
                KtScratchReplExecutor.this.getHandler().error(KtScratchReplExecutor.this.getFile(), "Couldn't parse REPL output: " + text2);
                return;
            }
            Document output = document;
            Node node2 = output.getFirstChild();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element root = (Element)node2;
            String outputType = root.getAttribute("type");
            String content2 = ReplUtilKt.replRemoveLineBreaksInTheEnd((String)ReplUtilKt.replNormalizeLineBreaks((String)ReplUtilKt.replUnescapeLineBreaks((String)root.getTextContent())));
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "REPL output: " + outputType + " " + content2);
            Object[] objectArray = new String[]{"SUCCESS", "COMPILE_ERROR", "INTERNAL_ERROR", "RUNTIME_ERROR", "READLINE_END"};
            if (SetsKt.setOf((Object[])objectArray).contains(outputType)) {
                KtScratchReplExecutor.this.history.entryProcessed();
                if (KtScratchReplExecutor.this.history.isAllProcessed()) {
                    KtScratchReplExecutor.this.getHandler().onFinish(KtScratchReplExecutor.this.getFile());
                }
            }
            if ((result2 = this.parseReplOutput(content2, outputType)) != null) {
                ScratchExpression lastExpression;
                ScratchExpression scratchExpression = lastExpression = Intrinsics.areEqual((Object)outputType, (Object)"USER_OUTPUT") ? KtScratchReplExecutor.this.history.lastUnprocessedEntry() : KtScratchReplExecutor.this.history.lastProcessedEntry();
                if (lastExpression != null) {
                    KtScratchReplExecutor.this.getHandler().handle(KtScratchReplExecutor.this.getFile(), lastExpression, result2);
                }
            }
        }

        private final ScratchOutput parseReplOutput(String text2, String outputType) {
            return switch (outputType) {
                case "USER_OUTPUT" -> new ScratchOutput(text2, ScratchOutputType.OUTPUT);
                case "REPL_RESULT" -> new ScratchOutput(text2, ScratchOutputType.RESULT);
                case "RUNTIME_ERROR", "INTERNAL_ERROR", "COMPILE_ERROR", "REPL_INCOMPLETE" -> new ScratchOutput(text2, ScratchOutputType.ERROR);
                default -> null;
            };
        }
    }
}

