/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.scratch.output.ScratchToolWindowFactory;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandlerKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\u0002\b\u001aH\u0002J\u0014\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/ToolWindowScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "error", "message", "", "getToolWindow", "project", "Lcom/intellij/openapi/project/Project;", "handle", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "printToConsole", "print", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lkotlin/ExtensionFunctionType;", "convert", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;", "kotlin.jvm"})
final class ToolWindowScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    @NotNull
    private final Disposable parentDisposable;

    public ToolWindowScratchOutputHandler(@NotNull Disposable parentDisposable) {
        this.parentDisposable = parentDisposable;
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(file2, expression2, output, this){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchOutput $output;
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            {
                this.$file = $file;
                this.$expression = $expression;
                this.$output = $output;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                PsiFile psiFile2 = this.$file.getPsiFile();
                if (psiFile2 != null) {
                    $this$printToConsole.printHyperlink(ToolWindowScratchOutputHandlerKt.access$getLineInfo(psiFile2, this.$expression), (HyperlinkInfo)new OpenFileHyperlinkInfo($this$printToConsole.getProject(), psiFile2.getVirtualFile(), this.$expression.getLineStart()));
                    $this$printToConsole.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                $this$printToConsole.print(this.$output.getText(), ToolWindowScratchOutputHandler.access$convert(this.this$0, this.$output.getType()));
            }
        }));
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(message2){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                $this$printToConsole.print(this.$message, ConsoleViewContentType.ERROR_OUTPUT);
            }
        }));
    }

    private final void printToConsole(ScratchFile file2, Function1<? super ConsoleViewImpl, Unit> print2) {
        Object modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(file2, this, print2){
            final /* synthetic */ ScratchFile $file$inlined;
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            final /* synthetic */ Function1 $print$inlined;
            {
                this.$file$inlined = scratchFile;
                this.this$0 = toolWindowScratchOutputHandler;
                this.$print$inlined = function1;
            }

            public final void run() {
                Project project;
                boolean bl = false;
                Project it = project = this.$file$inlined.getProject();
                boolean bl2 = false;
                Object object = !it.isDisposed() ? project : null;
                if (object != null) {
                    Project project2 = object;
                    ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(this.this$0, project2);
                    if (toolWindow == null) {
                        toolWindow = ToolWindowScratchOutputHandler.access$createToolWindow(this.this$0, this.$file$inlined);
                    }
                    ToolWindow toolWindow2 = toolWindow;
                    for (Content content2 : toolWindow2.getContentManager().getContents()) {
                        JComponent component2 = content2.getComponent();
                        if (!(component2 instanceof ConsoleViewImpl)) continue;
                        this.$print$inlined.invoke((Object)component2);
                        ((ConsoleViewImpl)component2).print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    toolWindow2.setAvailable(true, null);
                    if (!this.$file$inlined.getOptions().isInteractiveMode()) {
                        toolWindow2.show(null);
                    }
                    toolWindow2.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.FileTypes.Text));
                }
            }
        }, ModalityState.defaultModalityState());
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Object modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, file2){
            final /* synthetic */ ToolWindowScratchOutputHandler this$0;
            final /* synthetic */ ScratchFile $file$inlined;
            {
                this.this$0 = toolWindowScratchOutputHandler;
                this.$file$inlined = scratchFile;
            }

            public final void run() {
                boolean bl = false;
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(this.this$0, this.$file$inlined.getProject());
                if (toolWindow != null) {
                    ToolWindow toolWindow2 = toolWindow;
                    for (Content content2 : toolWindow2.getContentManager().getContents()) {
                        JComponent component2 = content2.getComponent();
                        if (!(component2 instanceof ConsoleViewImpl)) continue;
                        ((ConsoleViewImpl)component2).clear();
                    }
                    if (!this.$file$inlined.getOptions().isInteractiveMode()) {
                        toolWindow2.hide(null);
                    }
                    toolWindow2.setIcon(AllIcons.FileTypes.Text);
                }
            }
        }, ModalityState.defaultModalityState());
    }

    private final ConsoleViewContentType convert(ScratchOutputType $this$convert) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1 -> ConsoleViewContentType.SYSTEM_OUTPUT;
            case 2 -> ConsoleViewContentType.NORMAL_OUTPUT;
            case 3 -> ConsoleViewContentType.ERROR_OUTPUT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        return toolWindowManager.getToolWindow("Scratch Output");
    }

    private final ToolWindow createToolWindow(ScratchFile file2) {
        Project project = file2.getProject();
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        toolWindowManager.registerToolWindow("Scratch Output", true, ToolWindowAnchor.BOTTOM);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("Scratch Output");
        if (toolWindow == null) {
            throw new IllegalStateException("ScratchToolWindowFactory.ID should be registered".toString());
        }
        ToolWindow window2 = toolWindow;
        new ScratchToolWindowFactory().createToolWindowContent(project, window2);
        Disposer.register((Disposable)this.parentDisposable, () -> ToolWindowScratchOutputHandler.createToolWindow$lambda$3(toolWindowManager));
        return window2;
    }

    private static final void createToolWindow$lambda$3(ToolWindowManager $toolWindowManager) {
        $toolWindowManager.unregisterToolWindow("Scratch Output");
    }

    public static final /* synthetic */ ConsoleViewContentType access$convert(ToolWindowScratchOutputHandler $this, ScratchOutputType $receiver) {
        return $this.convert($receiver);
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow(ToolWindowScratchOutputHandler $this, Project project) {
        return $this.getToolWindow(project);
    }

    public static final /* synthetic */ ToolWindow access$createToolWindow(ToolWindowScratchOutputHandler $this, ScratchFile file2) {
        return $this.createToolWindow(file2);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScratchOutputType.values().length];
            try {
                nArray[ScratchOutputType.OUTPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScratchOutputType.RESULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScratchOutputType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

