/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewEditorScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "previewOutputBlocksManager", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "toolwindowHandler", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;Lcom/intellij/openapi/Disposable;)V", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearOutputManager", "error", "message", "", "handle", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "onFinish", "onStart", "printToPreviewEditor", "kotlin.jvm"})
public final class PreviewEditorScratchOutputHandler
implements ScratchOutputHandler {
    @NotNull
    private final PreviewOutputBlocksManager previewOutputBlocksManager;
    @NotNull
    private final ScratchOutputHandler toolwindowHandler;
    @NotNull
    private final Disposable parentDisposable;

    public PreviewEditorScratchOutputHandler(@NotNull PreviewOutputBlocksManager previewOutputBlocksManager, @NotNull ScratchOutputHandler toolwindowHandler, @NotNull Disposable parentDisposable) {
        this.previewOutputBlocksManager = previewOutputBlocksManager;
        this.toolwindowHandler = toolwindowHandler;
        this.parentDisposable = parentDisposable;
    }

    @Override
    public void onStart(@NotNull ScratchFile file2) {
        this.toolwindowHandler.onStart(file2);
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        this.printToPreviewEditor(expression2, output);
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        this.toolwindowHandler.error(file2, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file2) {
        this.toolwindowHandler.onFinish(file2);
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        this.toolwindowHandler.clear(file2);
        this.clearOutputManager();
    }

    private final void printToPreviewEditor(ScratchExpression expression2, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.printToPreviewEditor$lambda$0(this, expression2, output));
    }

    private final void clearOutputManager() {
        TransactionGuard.submitTransaction((Disposable)this.parentDisposable, () -> PreviewEditorScratchOutputHandler.clearOutputManager$lambda$1(this));
    }

    private static final void printToPreviewEditor$lambda$0(PreviewEditorScratchOutputHandler this$0, ScratchExpression $expression, ScratchOutput $output) {
        ScratchOutputBlock scratchOutputBlock = this$0.previewOutputBlocksManager.getBlock($expression);
        if (scratchOutputBlock == null) {
            scratchOutputBlock = this$0.previewOutputBlocksManager.addBlockToTheEnd($expression);
        }
        ScratchOutputBlock targetCell = scratchOutputBlock;
        targetCell.addOutput($output);
    }

    private static final void clearOutputManager$lambda$1(PreviewEditorScratchOutputHandler this$0) {
        this$0.previewOutputBlocksManager.clear();
    }
}

