/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "toolWindowHandler", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;)V", "maxInsertOffset", "", "maxLineLength", "minSpaceCount", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearInlays", "editor", "createInlay", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "handle", "onFinish", "onStart", "printToToolWindow", "kotlin.jvm"})
public final class InlayScratchOutputHandler
implements ScratchOutputHandler {
    @NotNull
    private final TextEditor textEditor;
    @NotNull
    private final ScratchOutputHandler toolWindowHandler;
    private final int maxLineLength;
    private final int maxInsertOffset;
    private final int minSpaceCount;

    public InlayScratchOutputHandler(@NotNull TextEditor textEditor, @NotNull ScratchOutputHandler toolWindowHandler) {
        this.textEditor = textEditor;
        this.toolWindowHandler = toolWindowHandler;
        this.maxLineLength = 120;
        this.maxInsertOffset = 60;
        this.minSpaceCount = 4;
    }

    @Override
    public void onStart(@NotNull ScratchFile file2) {
        this.toolWindowHandler.onStart(file2);
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        if (StringsKt.isBlank((CharSequence)output.getText())) {
            return;
        }
        this.createInlay(file2, expression2, output);
        if (output.getType() == ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        this.toolWindowHandler.error(file2, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file2) {
        this.toolWindowHandler.onFinish(file2);
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        this.clearInlays(this.textEditor);
        this.toolWindowHandler.clear(file2);
    }

    private final void createInlay(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)KotlinPluginDisposable.Companion.getInstance(file2.getProject()), () -> InlayScratchOutputHandler.createInlay$lambda$2(this, expression2, file2, output));
    }

    private final void printToToolWindow(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        if (output.getType() != ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int maxLineLength(ScratchFile file2) {
        Comparable comparable;
        void $this$flatMapTo$iv$iv;
        Document doc = this.textEditor.getEditor().getDocument();
        Iterable $this$flatMap$iv = file2.getExpressions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ScratchExpression it = (ScratchExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)new IntRange(it.getLineStart(), it.getLineEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            int it = ((Number)iterator.next()).intValue();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(doc.getLineEndOffset(it) - doc.getLineStartOffset(it));
            while (iterator.hasNext()) {
                int it2 = ((Number)iterator.next()).intValue();
                $i$a$-maxOfOrNull-InlayScratchOutputHandler$maxLineLength$2 = false;
                Comparable comparable3 = Integer.valueOf(doc.getLineEndOffset(it2) - doc.getLineStartOffset(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private final void clearInlays(TextEditor editor2) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)editor2), () -> InlayScratchOutputHandler.clearInlays$lambda$7(editor2));
    }

    private static final void createInlay$lambda$2$addInlay(InlayScratchOutputHandler this$0, Ref.IntRef spaceCount, int lineLength, ScratchFile $file, ScratchExpression $expression, ScratchOutput $output, Editor editor2, int lineEndOffset, String text2) {
        String textBeforeNewLine = StringUtil.containsLineBreak((CharSequence)text2) ? StringsKt.substringBefore$default((String)text2, (String)"\n", null, (int)2, null) + "..." : text2;
        Integer n = this$0.maxLineLength - spaceCount.element - lineLength;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 5 ? n : null;
        int maxInlayLength = n2 != null ? n2 : 5;
        String shortText = StringUtil.shortenTextWithEllipsis((String)textBeforeNewLine, (int)maxInlayLength, (int)0);
        if (!Intrinsics.areEqual((Object)shortText, (Object)text2)) {
            this$0.printToToolWindow($file, $expression, $output);
        }
        editor2.getInlayModel().addAfterLineEndElement(lineEndOffset, false, (EditorCustomElementRenderer)new InlayScratchFileRenderer(StringsKt.repeat((CharSequence)" ", (int)spaceCount.element) + shortText, $output.getType()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void createInlay$lambda$2(InlayScratchOutputHandler this$0, ScratchExpression $expression, ScratchFile $file, ScratchOutput $output) {
        Object v0;
        Ref.IntRef spaceCount;
        int lineLength;
        int lineEndOffset;
        Editor editor2;
        block5: {
            void $this$singleOrNull$iv;
            editor2 = this$0.textEditor.getEditor();
            int line = $expression.getLineStart();
            int lineStartOffset = editor2.getDocument().getLineStartOffset(line);
            lineEndOffset = editor2.getDocument().getLineEndOffset(line);
            lineLength = lineEndOffset - lineStartOffset;
            spaceCount = new Ref.IntRef();
            spaceCount.element = this$0.maxLineLength($file) - lineLength + this$0.minSpaceCount;
            while (spaceCount.element + lineLength > this$0.maxInsertOffset && spaceCount.element > this$0.minSpaceCount) {
                int n = spaceCount.element;
                spaceCount.element = n + -1;
            }
            Iterable iterable = editor2.getInlayModel().getAfterLineEndElementsInRange(lineEndOffset, lineEndOffset);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                if (!(it.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                if (found$iv) {
                    v0 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Inlay existing = v0;
        if (existing != null) {
            existing.dispose();
            EditorCustomElementRenderer editorCustomElementRenderer = existing.getRenderer();
            Intrinsics.checkNotNull((Object)editorCustomElementRenderer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer");
            InlayScratchOutputHandler.createInlay$lambda$2$addInlay(this$0, spaceCount, lineLength, $file, $expression, $output, editor2, lineEndOffset, StringsKt.drop((String)(((InlayScratchFileRenderer)editorCustomElementRenderer).getText() + "; " + $output.getText()), (int)spaceCount.element));
        } else {
            InlayScratchOutputHandler.createInlay$lambda$2$addInlay(this$0, spaceCount, lineLength, $file, $expression, $output, editor2, lineEndOffset, $output.getText());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void clearInlays$lambda$7(TextEditor $editor) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $editor.getEditor().getInlayModel().getAfterLineEndElementsInRange(0, $editor.getEditor().getDocument().getTextLength());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Inlay it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!(it.getRenderer() instanceof InlayScratchFileRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }
}

