/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.KotlinCompilerIde;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 J5\u0010!\u001a\u00020\u001e2\b\b\u0001\u0010\"\u001a\u00020\u00182!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u001e0$H\u0002J\u001e\u0010(\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\fJL\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0006\u0010/\u001a\u00020\u001eJ.\u00100\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compileFileToTempDir", "Ljava/io/File;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "createCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "createFileWithLightClassSupport", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "execute", "", "callback", "Lkotlin/Function0;", "executeInBackground", "title", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "indicator", "reportError", "e", "", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScratchSourceFile", "stop", "tryRunCommandLine", "Companion", "kotlin.jvm"})
public final class KtScratchExecutionSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchFile file;
    @NotNull
    private final KtCompilingExecutor executor;
    @Nullable
    private volatile ProgressIndicator backgroundProcessIndicator;
    private static final int TIMEOUT_MS = 30000;

    public KtScratchExecutionSession(@NotNull ScratchFile file2, @NotNull KtCompilingExecutor executor) {
        this.file = file2;
        this.executor = executor;
    }

    public final void execute(@NotNull Function0<Unit> callback2) {
        KtFile ktFile = this.file.getKtScratchFile();
        if (ktFile == null) {
            ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
            return;
        }
        KtFile psiFile2 = ktFile;
        List<ScratchExpression> expressions2 = this.file.getExpressions();
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return;
        }
        boolean $i$f$runReadAction = false;
        KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ApplicationManager.getApplication().runReadAction(new Computable(expressions2){
            final /* synthetic */ List $expressions$inlined;
            {
                this.$expressions$inlined = list2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)new KtScratchSourceFileProcessor().process(this.$expressions$inlined);
            }
        });
        if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
            ScratchExecutor.errorOccurs$default(this.executor, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
            return;
        }
        if (result2 instanceof KtScratchSourceFileProcessor.Result.OK) {
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            this.executeInBackground(KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this, result2, psiFile2, callback2){
                final /* synthetic */ KtScratchExecutionSession this$0;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ Function0<Unit> $callback;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$psiFile = $psiFile;
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(@NotNull ProgressIndicator indicator) {
                    KtScratchExecutionSession.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    KtFile modifiedScratchSourceFile = KtScratchExecutionSession.access$createFileWithLightClassSupport(this.this$0, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$psiFile);
                    KtScratchExecutionSession.access$tryRunCommandLine(this.this$0, modifiedScratchSourceFile, this.$psiFile, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$callback);
                }
            }));
        }
    }

    private final void executeInBackground(@NlsContexts.ProgressTitle String title, Function1<? super ProgressIndicator, Unit> block2) {
        Project project = this.file.getProject();
        new Task.Backgroundable(title, block2, project){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $block;
            {
                this.$block = $block;
                super($super_call_param$1, $title, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                this.$block.invoke((Object)indicator);
            }
        }.queue();
    }

    private final KtFile createFileWithLightClassSupport(KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        boolean $i$f$runReadAction = false;
        return (KtFile)ApplicationManager.getApplication().runReadAction(new Computable(this, result2, psiFile2){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ KtScratchSourceFileProcessor.Result.OK $result$inlined;
            final /* synthetic */ KtFile $psiFile$inlined;
            {
                this.this$0 = ktScratchExecutionSession;
                this.$result$inlined = oK;
                this.$psiFile$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)new KtPsiFactory(KtScratchExecutionSession.access$getFile$p(this.this$0).getProject(), false, 2, null).createFileWithLightClassSupport("tmp.kt", this.$result$inlined.getCode(), (PsiElement)this.$psiFile$inlined);
            }
        });
    }

    private final void tryRunCommandLine(KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0<Unit> callback2) {
        boolean bl;
        boolean bl2 = bl = this.backgroundProcessIndicator != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            Project project = this.file.getProject();
            List<ScratchExpression> list2 = this.file.getExpressions();
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            this.runCommandLine(project, modifiedScratchSourceFile, list2, psiFile2, result2, progressIndicator, callback2);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.reportError(result2, e, psiFile2);
        }
    }

    public final void reportError(@NotNull KtScratchSourceFileProcessor.Result.OK result2, @NotNull Throwable e, @NotNull KtFile psiFile2) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), result2.getCode());
        String string2 = e.getMessage();
        if (string2 == null) {
            Object[] objectArray = new Object[]{psiFile2.getName()};
            string2 = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
        }
        this.executor.errorOccurs(string2, e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runCommandLine(Project project, KtFile modifiedScratchSourceFile, List<ScratchExpression> expressions2, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback2) {
        File file2 = (File)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> KtScratchExecutionSession.runCommandLine$lambda$2(this, modifiedScratchSourceFile, expressions2));
        if (file2 == null) {
            return;
        }
        File tempDir = file2;
        try {
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = this.createCommandLine(psiFile2, this.file.getModule(), result2.getMainClassName(), tempDir.getPath());
            TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine commandLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment = environmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
            String commandLinePresentation = commandLine.getCommandPresentation(environment);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), commandLinePresentation);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(environment.createProcess(commandLine, indicator), null, commandLinePresentation);
            ProcessOutput executionResult = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            if (executionResult.isTimeout()) {
                Object[] objectArray = new Object[]{30000};
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", objectArray), null, false, 6, null);
            } else if (!executionResult.isCancelled()) {
                this.executor.parseOutput(executionResult, expressions2);
            }
        }
        finally {
            tempDir.delete();
            callback2.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    private final File compileFileToTempDir(KtFile psiFile2, List<ScratchExpression> expressions2) {
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return null;
        }
        File tmpDir = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + tmpDir.getPath());
        new KotlinCompilerIde(psiFile2, null, null, null, false, 30, null).compileToDirectory(tmpDir);
        return tmpDir;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TargetEnvironmentRequest, TargetedCommandLine> createCommandLine(KtFile originalFile, Module module2, String mainClassName, String tempOutDir) {
        WslTargetEnvironmentConfiguration wslConfiguration;
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        JavaParameters javaParameters = new JavaParametersBuilder(originalFile.getProject()).withSdkFrom(module2, true).withMainClassName(mainClassName).build();
        javaParameters.getClassPath().add(tempOutDir);
        if (module2 != null) {
            javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module2));
        }
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = ScriptConfigurationManager.Companion.getInstance(originalFile.getProject()).getConfiguration(originalFile);
        if (scriptCompilationConfigurationWrapper != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper;
            boolean bl = false;
            Iterable iterable = it.getDependenciesClassPath();
            PathsList pathsList = javaParameters.getClassPath();
            boolean $i$f$map = false;
            void var13_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void f2;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(f2.getAbsolutePath());
            }
            pathsList.addAll((List)destination$iv$iv);
        }
        if ((wslTargetEnvironmentConfiguration = (wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk()))) == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(originalFile.getProject())) == null) {
            wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        WslTargetEnvironmentConfiguration request = wslTargetEnvironmentConfiguration;
        return TuplesKt.to((Object)request, (Object)javaParameters.toCommandLine((TargetEnvironmentRequest)request).build());
    }

    private static final File runCommandLine$lambda$2(KtScratchExecutionSession this$0, KtFile $modifiedScratchSourceFile, List $expressions) {
        return this$0.compileFileToTempDir($modifiedScratchSourceFile, $expressions);
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtScratchExecutionSession $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ KtFile access$createFileWithLightClassSupport(KtScratchExecutionSession $this, KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        return $this.createFileWithLightClassSupport(result2, psiFile2);
    }

    public static final /* synthetic */ void access$tryRunCommandLine(KtScratchExecutionSession $this, KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0 callback2) {
        $this.tryRunCommandLine(modifiedScratchSourceFile, psiFile2, result2, (Function0<Unit>)callback2);
    }

    public static final /* synthetic */ ScratchFile access$getFile$p(KtScratchExecutionSession $this) {
        return $this.file;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "()V", "TIMEOUT_MS", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

