/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "kotlin.jvm"})
public final class RunScratchAction
extends ScratchAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RunScratchAction() {
        block0: {
            super(KotlinJvmBundle.message("scratch.run.button", new Object[0]), AllIcons.Actions.Execute);
            Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])KeymapManager.getInstance().getActiveKeymap().getShortcuts("Kotlin.RunScratch"));
            if (shortcut == null) break block0;
            Shortcut it = shortcut;
            boolean bl = false;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ")");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ScratchFile scratchFile = this.getCurrentScratchFile(e);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        Companion.doAction(scratchFile2, false);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress());
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            e.getPresentation().setText(KotlinJvmBundle.message("other.scratch.file.execution.is.in.progress", new Object[0]));
        }
        ScratchFile scratchFile = this.getCurrentScratchFile(e);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        e.getPresentation().setVisible(!ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile2));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Companion;", "", "()V", "doAction", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "isAutoRun", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public final void doAction(@NotNull ScratchFile scratchFile, boolean isAutoRun) {
            Project project = scratchFile.getProject();
            boolean isRepl = scratchFile.getOptions().isRepl();
            ScratchExecutor scratchExecutor = isRepl ? (ScratchExecutor)scratchFile.getReplScratchExecutor() : scratchFile.getCompilingScratchExecutor();
            if (scratchExecutor == null) {
                return;
            }
            ScratchExecutor executor = scratchExecutor;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isRepl = " + isRepl);
            boolean isMakeBeforeRun = scratchFile.getOptions().isMakeBeforeRun();
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun);
            ScriptConfigurationManager $this$cast$iv = ScriptConfigurationManager.Companion.getInstance(project);
            boolean $i$f$cast = false;
            ScriptConfigurationManager scriptConfigurationManager = $this$cast$iv;
            if (scriptConfigurationManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager");
            }
            ((CompositeScriptConfigurationManager)scriptConfigurationManager).updateScriptDependenciesIfNeeded(scratchFile.getFile());
            Module module2 = scratchFile.getModule();
            Module module3 = module2;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: module = " + (module3 != null ? module3.getName() : null));
            if (!isAutoRun && module2 != null && isMakeBeforeRun) {
                Module[] moduleArray = new Module[]{module2};
                ProjectTaskManager.getInstance((Project)project).build(moduleArray).onSuccess(arg_0 -> Companion.doAction$lambda$0((Function1)new Function1<ProjectTaskManager.Result, Unit>(executor, module2, project, isAutoRun){
                    final /* synthetic */ ScratchExecutor $executor;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ boolean $isAutoRun;
                    {
                        this.$executor = $executor;
                        this.$module = $module;
                        this.$project = $project;
                        this.$isAutoRun = $isAutoRun;
                        super(1);
                    }

                    public final void invoke(ProjectTaskManager.Result executionResult) {
                        if (executionResult.isAborted() || executionResult.hasErrors()) {
                            Object[] objectArray = new Object[]{this.$module.getName()};
                            ScratchExecutor.errorOccurs$default(this.$executor, KotlinJvmBundle.message("there.were.compilation.errors.in.module.0", objectArray), null, false, 6, null);
                        }
                        if (DumbService.isDumb((Project)this.$project)) {
                            DumbService.getInstance((Project)this.$project).smartInvokeLater(() -> doAction.1.invoke$lambda$0(this.$isAutoRun, this.$executor));
                        } else {
                            org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction$Companion.access$doAction$executeScratch(this.$isAutoRun, this.$executor);
                        }
                    }

                    private static final void invoke$lambda$0(boolean $isAutoRun, ScratchExecutor $executor) {
                        org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction$Companion.access$doAction$executeScratch($isAutoRun, $executor);
                    }
                }, arg_0));
            } else {
                org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction$Companion.doAction$executeScratch(isAutoRun, executor);
            }
        }

        private static final void doAction$executeScratch(boolean $isAutoRun, ScratchExecutor executor) {
            try {
                if ($isAutoRun && executor instanceof SequentialScratchExecutor) {
                    ((SequentialScratchExecutor)executor).executeNew();
                } else {
                    executor.execute();
                }
            }
            catch (Throwable ex) {
                executor.errorOccurs(KotlinJvmBundle.message("exception.occurs.during.run.scratch.action", new Object[0]), ex, true);
            }
        }

        private static final void doAction$lambda$0(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$doAction$executeScratch(boolean $isAutoRun, ScratchExecutor executor) {
            org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction$Companion.doAction$executeScratch($isAutoRun, executor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

