/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0011\u001a\u00020\u0012H$J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\u0006\u0010\u0015\u001a\u00020\u000bJ\b\u0010\u0016\u001a\u00020\u000bH$J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\u001a\u0010\u0019\u001a\u00020\u000b2\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001bH$J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "lastExecuted", "", "listener", "org/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor$listener$1", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor$listener$1;", "execute", "", "executeNew", "executeStatement", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "getFirstNewExpression", "needProcessToStart", "", "needToRestartProcess", "resetLastExecutedIndex", "start", "startExecution", "stop", "stopAndWait", "stopExecution", "callback", "Lkotlin/Function0;", "wasExpressionExecuted", "index", "kotlin.jvm"})
public abstract class SequentialScratchExecutor
extends ScratchExecutor {
    @NotNull
    private final listener.1 listener;
    private int lastExecuted;

    public SequentialScratchExecutor(@NotNull ScratchFile file2) {
        super(file2);
        this.listener = new DocumentListener(this, file2){
            final /* synthetic */ SequentialScratchExecutor this$0;
            final /* synthetic */ ScratchFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                Document document;
                block10: {
                    block9: {
                        VirtualFile virtualFile;
                        if (StringsKt.isBlank((CharSequence)event.getNewFragment()) && StringsKt.isBlank((CharSequence)event.getOldFragment())) {
                            return;
                        }
                        if (!SequentialScratchExecutor.access$needToRestartProcess(this.this$0)) {
                            return;
                        }
                        document = event.getDocument();
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block9;
                        VirtualFile it = virtualFile = object;
                        boolean bl = false;
                        object = it.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block10;
                    }
                    return;
                }
                VirtualFile virtualFile = object;
                if (!virtualFile.isValid()) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)PsiManager.getInstance((Project)this.$file.getProject()).findFile(virtualFile), (Object)this.$file.getPsiFile())) {
                    return;
                }
                int changedLine = document.getLineNumber(event.getOffset());
                ScratchExpression scratchExpression = this.$file.getExpressionAtLine(changedLine);
                if (scratchExpression == null) {
                    return;
                }
                ScratchExpression changedExpression = scratchExpression;
                int changedExpressionIndex = this.$file.getExpressions().indexOf(changedExpression);
                if (SequentialScratchExecutor.access$wasExpressionExecuted(this.this$0, changedExpressionIndex)) {
                    SequentialScratchExecutor.access$resetLastExecutedIndex(this.this$0);
                    this.this$0.getHandler().clear(this.$file);
                    SequentialScratchExecutor.stopExecution$default(this.this$0, null, 1, null);
                }
            }
        };
        this.lastExecuted = -1;
    }

    public abstract void executeStatement(@NotNull ScratchExpression var1);

    protected abstract void startExecution();

    protected abstract void stopExecution(@Nullable Function0<Unit> var1);

    public static /* synthetic */ void stopExecution$default(SequentialScratchExecutor sequentialScratchExecutor, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopExecution");
        }
        if ((n & 1) != 0) {
            function0 = null;
        }
        sequentialScratchExecutor.stopExecution((Function0<Unit>)function0);
    }

    protected abstract boolean needProcessToStart();

    public final void start() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.listener, (Disposable)this.getFile().getProject().getMessageBus().connect());
        this.startExecution();
    }

    @Override
    public void stop() {
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this.listener);
        SequentialScratchExecutor.stopExecution$default(this, null, 1, null);
    }

    public final void executeNew() {
        List<ScratchExpression> expressions2 = this.getFile().getExpressions();
        if (this.wasExpressionExecuted(expressions2.size())) {
            return;
        }
        this.getHandler().onStart(this.getFile());
        Iterator<ScratchExpression> iterator = expressions2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ScratchExpression expression2 = iterator.next();
            if (this.wasExpressionExecuted(index)) continue;
            this.executeStatement(expression2);
            this.lastExecuted = index;
        }
    }

    @Override
    public void execute() {
        if (this.needToRestartProcess()) {
            this.resetLastExecutedIndex();
            this.getHandler().clear(this.getFile());
            this.getHandler().onStart(this.getFile());
            this.stopExecution((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SequentialScratchExecutor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ApplicationManager.getApplication().invokeLater(() -> execute.1.invoke$lambda$0(this.this$0));
                }

                private static final void invoke$lambda$0(SequentialScratchExecutor this$0) {
                    this$0.executeNew();
                }
            }));
        } else {
            this.executeNew();
        }
    }

    @Nullable
    public final ScratchExpression getFirstNewExpression() {
        boolean $i$f$runReadAction = false;
        List expressions2 = (List)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ SequentialScratchExecutor this$0;
            {
                this.this$0 = sequentialScratchExecutor;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.this$0.getFile().getExpressions();
            }
        });
        int firstNewExpressionIndex = this.lastExecuted + 1;
        boolean bl = 0 <= firstNewExpressionIndex ? firstNewExpressionIndex < expressions2.size() : false;
        if (bl) {
            return (ScratchExpression)expressions2.get(firstNewExpressionIndex);
        }
        return null;
    }

    private final boolean needToRestartProcess() {
        return this.lastExecuted > -1;
    }

    private final void resetLastExecutedIndex() {
        this.lastExecuted = -1;
    }

    private final boolean wasExpressionExecuted(int index) {
        return index <= this.lastExecuted;
    }

    @TestOnly
    public final void stopAndWait() {
        Semaphore lock = new Semaphore(1);
        lock.acquire();
        this.stopExecution((Function0<Unit>)((Function0)new Function0<Unit>(lock){
            final /* synthetic */ Semaphore $lock;
            {
                this.$lock = $lock;
                super(0);
            }

            public final void invoke() {
                this.$lock.release();
            }
        }));
        if (!lock.tryAcquire(2L, TimeUnit.SECONDS)) {
            boolean bl = false;
            String string2 = "Couldn't stop REPL process in 2 seconds";
            throw new IllegalStateException(string2.toString());
        }
    }

    public static final /* synthetic */ boolean access$needToRestartProcess(SequentialScratchExecutor $this) {
        return $this.needToRestartProcess();
    }

    public static final /* synthetic */ boolean access$wasExpressionExecuted(SequentialScratchExecutor $this, int index) {
        return $this.wasExpressionExecuted(index);
    }

    public static final /* synthetic */ void access$resetLastExecutedIndex(SequentialScratchExecutor $this) {
        $this.resetLastExecutedIndex();
    }
}

